/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.nio.channels.Channel;
import org.jruby.IRuby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyKernel;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.IOHandler;
import org.jruby.util.IOHandlerJavaIO;
import org.jruby.util.IOHandlerNio;
import org.jruby.util.IOHandlerNull;
import org.jruby.util.IOHandlerProcess;
import org.jruby.util.IOHandlerSeekable;
import org.jruby.util.IOHandlerUnseekable;
import org.jruby.util.IOModes;

public class RubyIO
extends RubyObject {
    public static final int STDIN = 0;
    public static final int STDOUT = 1;
    public static final int STDERR = 2;
    protected IOHandler handler = null;
    protected IOModes modes = null;
    protected int lineNumber = 0;
    protected boolean isOpen = true;
    protected static int fileno = 2;

    public void registerIOHandler(IOHandler newHandler) {
        this.getRuntime().getIoHandlers().put(new Integer(newHandler.getFileno()), new WeakReference<IOHandler>(newHandler));
    }

    public void unregisterIOHandler(int aFileno) {
        this.getRuntime().getIoHandlers().remove(new Integer(aFileno));
    }

    public IOHandler getIOHandlerByFileno(int aFileno) {
        return (IOHandler)((WeakReference)this.getRuntime().getIoHandlers().get(new Integer(aFileno))).get();
    }

    public static int getNewFileno() {
        return ++fileno;
    }

    public RubyIO(IRuby runtime, RubyClass type) {
        super(runtime, type);
    }

    public RubyIO(IRuby runtime, OutputStream outputStream) {
        super(runtime, runtime.getClass("IO"));
        if (outputStream == null) {
            throw runtime.newIOError("Opening invalid stream");
        }
        try {
            this.handler = new IOHandlerUnseekable(runtime, null, outputStream);
        }
        catch (IOException e) {
            throw runtime.newIOError(e.getMessage());
        }
        this.modes = this.handler.getModes();
        this.registerIOHandler(this.handler);
    }

    public RubyIO(IRuby runtime, InputStream inputStream) {
        super(runtime, runtime.getClass("IO"));
        if (inputStream == null) {
            throw runtime.newIOError("Opening invalid stream");
        }
        try {
            this.handler = new IOHandlerUnseekable(runtime, inputStream, null);
        }
        catch (IOException e) {
            throw runtime.newIOError(e.getMessage());
        }
        this.modes = this.handler.getModes();
        this.registerIOHandler(this.handler);
    }

    public RubyIO(IRuby runtime, Channel channel) {
        super(runtime, runtime.getClass("IO"));
        if (channel == null) {
            throw runtime.newIOError("Opening invalid stream");
        }
        try {
            this.handler = new IOHandlerNio(runtime, channel);
        }
        catch (IOException e) {
            throw runtime.newIOError(e.getMessage());
        }
        this.modes = this.handler.getModes();
        this.registerIOHandler(this.handler);
    }

    public RubyIO(IRuby runtime, Process process) {
        super(runtime, runtime.getClass("IO"));
        this.modes = new IOModes(runtime, "w+");
        try {
            this.handler = new IOHandlerProcess(runtime, process, this.modes);
        }
        catch (IOException e) {
            throw runtime.newIOError(e.getMessage());
        }
        this.modes = this.handler.getModes();
        this.registerIOHandler(this.handler);
    }

    public RubyIO(IRuby runtime, int descriptor) {
        super(runtime, runtime.getClass("IO"));
        try {
            this.handler = new IOHandlerUnseekable(runtime, descriptor);
        }
        catch (IOException e) {
            throw runtime.newIOError(e.getMessage());
        }
        this.modes = this.handler.getModes();
        this.registerIOHandler(this.handler);
    }

    public static IRubyObject fdOpen(IRuby runtime, int descriptor) {
        return new RubyIO(runtime, descriptor);
    }

    protected void checkWriteable() {
        if (!this.isOpen() || !this.modes.isWriteable()) {
            throw this.getRuntime().newIOError("not opened for writing");
        }
    }

    protected void checkReadable() {
        if (!this.isOpen() || !this.modes.isReadable()) {
            throw this.getRuntime().newIOError("not opened for reading");
        }
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public OutputStream getOutStream() {
        if (this.handler instanceof IOHandlerJavaIO) {
            return ((IOHandlerJavaIO)this.handler).getOutputStream();
        }
        return null;
    }

    public InputStream getInStream() {
        if (this.handler instanceof IOHandlerJavaIO) {
            return ((IOHandlerJavaIO)this.handler).getInputStream();
        }
        return null;
    }

    public Channel getChannel() {
        if (this.handler instanceof IOHandlerNio) {
            return ((IOHandlerNio)this.handler).getChannel();
        }
        return null;
    }

    public IRubyObject reopen(IRubyObject[] args) {
        if (args.length < 1) {
            throw this.getRuntime().newArgumentError("wrong number of arguments");
        }
        if (args[0].isKindOf(this.getRuntime().getClass("IO"))) {
            RubyIO ios = (RubyIO)args[0];
            int keepFileno = this.handler.getFileno();
            if (this.handler.isOpen()) {
                try {
                    this.handler.close();
                }
                catch (IOHandler.BadDescriptorException e) {
                    throw this.getRuntime().newErrnoEBADFError();
                }
                catch (EOFException e) {
                    return this.getRuntime().getNil();
                }
                catch (IOException e) {
                    throw this.getRuntime().newIOError(e.getMessage());
                }
            }
            try {
                this.handler = ios.handler.cloneIOHandler();
            }
            catch (IOHandler.InvalidValueException e) {
                throw this.getRuntime().newErrnoEINVALError();
            }
            catch (IOHandler.PipeException e) {
                throw this.getRuntime().newErrnoESPIPEError();
            }
            catch (FileNotFoundException e) {
                throw this.getRuntime().newErrnoENOENTError();
            }
            catch (IOException e) {
                throw this.getRuntime().newIOError(e.getMessage());
            }
            this.handler.setFileno(keepFileno);
            this.registerIOHandler(this.handler);
        } else if (args[0].isKindOf(this.getRuntime().getString())) {
            String path = ((RubyString)args[0]).toString();
            IOModes newModes = null;
            if (args.length > 1) {
                if (!args[1].isKindOf(this.getRuntime().getString())) {
                    throw this.getRuntime().newTypeError(args[1], this.getRuntime().getString());
                }
                newModes = new IOModes(this.getRuntime(), ((RubyString)args[1]).toString());
            }
            try {
                if (this.handler != null) {
                    this.close();
                }
                if (newModes != null) {
                    this.modes = newModes;
                }
                this.handler = "/dev/null".equals(path) ? new IOHandlerNull(this.getRuntime(), this.modes) : new IOHandlerSeekable(this.getRuntime(), path, this.modes);
                this.registerIOHandler(this.handler);
            }
            catch (IOHandler.InvalidValueException e) {
                throw this.getRuntime().newErrnoEINVALError();
            }
            catch (IOException e) {
                throw this.getRuntime().newIOError(e.toString());
            }
        }
        this.isOpen = true;
        return this;
    }

    public IRubyObject internalGets(IRubyObject[] args) {
        String separator;
        this.checkReadable();
        IRubyObject sepVal = this.getRuntime().getGlobalVariables().get("$/");
        if (args.length > 0) {
            sepVal = args[0];
        }
        String string = separator = sepVal.isNil() ? null : ((RubyString)sepVal).toString();
        if (separator != null && separator.length() == 0) {
            separator = "PARAGRPH_DELIM_MRK_ER";
        }
        try {
            String newLine = this.handler.gets(separator);
            if (newLine != null) {
                ++this.lineNumber;
                this.getRuntime().getGlobalVariables().set("$.", this.getRuntime().newFixnum(this.lineNumber));
                RubyString result = this.getRuntime().newString(newLine);
                result.taint();
                return result;
            }
            return this.getRuntime().getNil();
        }
        catch (IOHandler.BadDescriptorException e) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        catch (IOException e) {
            throw this.getRuntime().newIOError(e.getMessage());
        }
    }

    @Override
    public IRubyObject initialize(IRubyObject[] args) {
        IOHandler existingIOHandler;
        int count = this.checkArgumentCount(args, 1, 2);
        int newFileno = RubyNumeric.fix2int(args[0]);
        String mode = null;
        if (count > 1) {
            mode = args[1].convertToString().toString();
        }
        if ((existingIOHandler = this.getIOHandlerByFileno(newFileno)) == null) {
            if (mode == null) {
                mode = "r";
            }
            try {
                this.handler = new IOHandlerUnseekable(this.getRuntime(), newFileno, mode);
            }
            catch (IOException e) {
                throw this.getRuntime().newIOError(e.getMessage());
            }
            this.modes = new IOModes(this.getRuntime(), mode);
            this.registerIOHandler(this.handler);
        } else {
            this.handler = existingIOHandler;
            this.modes = mode == null ? this.handler.getModes() : new IOModes(this.getRuntime(), mode);
            try {
                this.handler.reset(this.modes);
            }
            catch (IOHandler.InvalidValueException e) {
                throw this.getRuntime().newErrnoEINVALError();
            }
            catch (IOException e) {
                throw this.getRuntime().newIOError(e.getMessage());
            }
        }
        return this;
    }

    public IRubyObject binmode() {
        return this;
    }

    public IRubyObject syswrite(IRubyObject obj) {
        try {
            return this.getRuntime().newFixnum(this.handler.syswrite(obj.toString()));
        }
        catch (IOHandler.BadDescriptorException e) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        catch (IOException e) {
            throw this.getRuntime().newSystemCallError(e.getMessage());
        }
    }

    public IRubyObject write(IRubyObject obj) {
        this.checkWriteable();
        try {
            int totalWritten = this.handler.write(obj.toString());
            return this.getRuntime().newFixnum(totalWritten);
        }
        catch (IOHandler.BadDescriptorException e) {
            return RubyFixnum.zero(this.getRuntime());
        }
        catch (IOException e) {
            return RubyFixnum.zero(this.getRuntime());
        }
    }

    public IRubyObject addString(IRubyObject anObject) {
        IRubyObject strObject = anObject.callMethod(this.getRuntime().getCurrentContext(), "to_s");
        this.write(strObject);
        return this;
    }

    public RubyFixnum fileno() {
        return this.getRuntime().newFixnum(this.handler.getFileno());
    }

    public RubyFixnum lineno() {
        return this.getRuntime().newFixnum(this.lineNumber);
    }

    public RubyFixnum lineno_set(IRubyObject newLineNumber) {
        this.lineNumber = RubyNumeric.fix2int(newLineNumber);
        return (RubyFixnum)newLineNumber;
    }

    public RubyBoolean sync() {
        return this.getRuntime().newBoolean(this.handler.isSync());
    }

    public IRubyObject pid() {
        int pid = this.handler.pid();
        if (pid == -1) {
            return this.getRuntime().getNil();
        }
        return this.getRuntime().newFixnum(pid);
    }

    public RubyFixnum pos() {
        try {
            return this.getRuntime().newFixnum(this.handler.pos());
        }
        catch (IOHandler.PipeException e) {
            throw this.getRuntime().newErrnoESPIPEError();
        }
        catch (IOException e) {
            throw this.getRuntime().newIOError(e.getMessage());
        }
    }

    public RubyFixnum pos_set(IRubyObject newPosition) {
        long offset = RubyNumeric.fix2long(newPosition);
        if (offset < 0L) {
            throw this.getRuntime().newSystemCallError("Negative seek offset");
        }
        try {
            this.handler.seek(offset, 0);
        }
        catch (IOHandler.InvalidValueException e) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        catch (IOHandler.PipeException e) {
            throw this.getRuntime().newErrnoESPIPEError();
        }
        catch (IOException e) {
            throw this.getRuntime().newIOError(e.getMessage());
        }
        return (RubyFixnum)newPosition;
    }

    public IRubyObject print(IRubyObject[] args) {
        if (args.length == 0) {
            args = new IRubyObject[]{this.getRuntime().getCurrentContext().getLastline()};
        }
        IRubyObject fs = this.getRuntime().getGlobalVariables().get("$,");
        IRubyObject rs = this.getRuntime().getGlobalVariables().get("$\\");
        ThreadContext context = this.getRuntime().getCurrentContext();
        for (int i = 0; i < args.length; ++i) {
            if (i > 0 && !fs.isNil()) {
                this.callMethod(context, "write", fs);
            }
            if (args[i].isNil()) {
                this.callMethod(context, "write", this.getRuntime().newString("nil"));
                continue;
            }
            this.callMethod(context, "write", args[i]);
        }
        if (!rs.isNil()) {
            this.callMethod(context, "write", rs);
        }
        return this.getRuntime().getNil();
    }

    public IRubyObject printf(IRubyObject[] args) {
        this.checkArgumentCount(args, 1, -1);
        this.callMethod(this.getRuntime().getCurrentContext(), "write", RubyKernel.sprintf(this, args));
        return this.getRuntime().getNil();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IRubyObject putc(IRubyObject object) {
        int c;
        if (object.isKindOf(this.getRuntime().getString())) {
            String value = ((RubyString)object).toString();
            if (value.length() <= 0) throw this.getRuntime().newTypeError("Cannot convert String to Integer");
            c = value.charAt(0);
        } else {
            c = object.isKindOf(this.getRuntime().getFixnum()) ? RubyNumeric.fix2int(object) : RubyNumeric.fix2int(object.callMethod(this.getRuntime().getCurrentContext(), "to_i"));
        }
        try {
            this.handler.putc(c);
            return this.getRuntime().newFixnum(c);
        }
        catch (IOHandler.BadDescriptorException e) {
            return RubyFixnum.zero(this.getRuntime());
        }
        catch (IOException e) {
            return RubyFixnum.zero(this.getRuntime());
        }
    }

    public RubyFixnum seek(IRubyObject[] args) {
        if (args.length == 0) {
            throw this.getRuntime().newArgumentError("wrong number of arguments");
        }
        long offset = RubyNumeric.fix2long(args[0]);
        int type = 0;
        if (args.length > 1) {
            type = RubyNumeric.fix2int(args[1].convertToInteger());
        }
        try {
            this.handler.seek(offset, type);
        }
        catch (IOHandler.InvalidValueException e) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        catch (IOHandler.PipeException e) {
            throw this.getRuntime().newErrnoESPIPEError();
        }
        catch (IOException e) {
            throw this.getRuntime().newIOError(e.getMessage());
        }
        return RubyFixnum.zero(this.getRuntime());
    }

    public RubyFixnum rewind() {
        try {
            this.handler.rewind();
        }
        catch (IOHandler.InvalidValueException e) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        catch (IOHandler.PipeException e) {
            throw this.getRuntime().newErrnoESPIPEError();
        }
        catch (IOException e) {
            throw this.getRuntime().newIOError(e.getMessage());
        }
        this.lineNumber = 0;
        return RubyFixnum.zero(this.getRuntime());
    }

    public RubyFixnum fsync() {
        this.checkWriteable();
        try {
            this.handler.sync();
        }
        catch (IOException e) {
            throw this.getRuntime().newIOError(e.getMessage());
        }
        catch (IOHandler.BadDescriptorException e) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        return RubyFixnum.zero(this.getRuntime());
    }

    public IRubyObject sync_set(IRubyObject newSync) {
        this.handler.setIsSync(newSync.isTrue());
        return this;
    }

    public RubyBoolean eof() {
        try {
            boolean isEOF = this.handler.isEOF();
            return isEOF ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
        }
        catch (IOHandler.BadDescriptorException e) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        catch (IOException e) {
            throw this.getRuntime().newIOError(e.getMessage());
        }
    }

    public RubyBoolean tty() {
        int fileno = this.handler.getFileno();
        if (fileno == 1 || fileno == 0 || fileno == 2) {
            return this.getRuntime().getTrue();
        }
        return this.getRuntime().getFalse();
    }

    public RubyIO clone_IO() {
        RubyIO io = new RubyIO(this.getRuntime(), this.getMetaClass());
        io.handler = this.handler;
        io.modes = (IOModes)this.modes.clone();
        return io;
    }

    public RubyBoolean closed() {
        return this.isOpen() ? this.getRuntime().getFalse() : this.getRuntime().getTrue();
    }

    public IRubyObject close() {
        this.isOpen = false;
        try {
            this.handler.close();
        }
        catch (IOHandler.BadDescriptorException e) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        catch (IOException e) {
            throw this.getRuntime().newIOError(e.getMessage());
        }
        this.unregisterIOHandler(this.handler.getFileno());
        return this;
    }

    public RubyIO flush() {
        try {
            this.handler.flush();
        }
        catch (IOHandler.BadDescriptorException e) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        catch (IOException e) {
            throw this.getRuntime().newIOError(e.getMessage());
        }
        return this;
    }

    public IRubyObject gets(IRubyObject[] args) {
        IRubyObject result = this.internalGets(args);
        if (!result.isNil()) {
            this.getRuntime().getCurrentContext().setLastline(result);
        }
        return result;
    }

    public boolean getBlocking() {
        if (!(this.handler instanceof IOHandlerNio)) {
            return true;
        }
        return ((IOHandlerNio)this.handler).getBlocking();
    }

    public IRubyObject fcntl(IRubyObject cmd, IRubyObject arg) throws IOException {
        long realCmd = cmd.convertToInteger().getLongValue();
        if (!(arg instanceof RubyNumeric)) {
            return this.getRuntime().newFixnum(0L);
        }
        long realArg = ((RubyNumeric)arg).getLongValue();
        if (realCmd == 1L) {
            boolean block = true;
            if ((realArg & 0x800L) == 2048L) {
                block = false;
            }
            if (!(this.handler instanceof IOHandlerNio)) {
                throw this.getRuntime().newNotImplementedError("FCNTL only works with Nio based handlers");
            }
            try {
                ((IOHandlerNio)this.handler).setBlocking(block);
            }
            catch (IOException e) {
                throw this.getRuntime().newIOError(e.getMessage());
            }
        }
        return this.getRuntime().newFixnum(0L);
    }

    public IRubyObject puts(IRubyObject[] args) {
        this.checkArgumentCount(args, 0, -1);
        ThreadContext context = this.getRuntime().getCurrentContext();
        if (args.length == 0) {
            this.callMethod(context, "write", this.getRuntime().newString("\n"));
            return this.getRuntime().getNil();
        }
        for (int i = 0; i < args.length; ++i) {
            String line = null;
            if (args[i].isNil()) {
                line = "nil";
            } else {
                if (args[i] instanceof RubyArray) {
                    this.puts(((RubyArray)args[i]).toJavaArray());
                    continue;
                }
                line = args[i].toString();
            }
            this.callMethod(this.getRuntime().getCurrentContext(), "write", this.getRuntime().newString(line + (line.endsWith("\n") ? "" : "\n")));
        }
        return this.getRuntime().getNil();
    }

    public IRubyObject readline(IRubyObject[] args) {
        IRubyObject line = this.gets(args);
        if (line.isNil()) {
            throw this.getRuntime().newEOFError();
        }
        return line;
    }

    public IRubyObject getc() {
        this.checkReadable();
        try {
            int c = this.handler.getc();
            return c == -1 ? this.getRuntime().getNil() : this.getRuntime().newFixnum(c);
        }
        catch (IOHandler.BadDescriptorException e) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        catch (EOFException e) {
            return this.getRuntime().getNil();
        }
        catch (IOException e) {
            throw this.getRuntime().newIOError(e.getMessage());
        }
    }

    public IRubyObject ungetc(IRubyObject number) {
        this.handler.ungetc(RubyNumeric.fix2int(number));
        return this.getRuntime().getNil();
    }

    public IRubyObject readpartial(IRubyObject[] args) {
        if (!(this.handler instanceof IOHandlerNio)) {
            throw this.getRuntime().newNotImplementedError("readpartial only works with Nio based handlers");
        }
        try {
            String buf = ((IOHandlerNio)this.handler).readpartial(RubyNumeric.fix2int(args[0]));
            RubyString strbuf = this.getRuntime().newString(buf == null ? "" : buf);
            if (args.length > 1) {
                args[1].callMethod(this.getRuntime().getCurrentContext(), "<<", strbuf);
                return args[1];
            }
            return strbuf;
        }
        catch (IOHandler.BadDescriptorException e) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        catch (EOFException e) {
            return this.getRuntime().getNil();
        }
        catch (IOException e) {
            throw this.getRuntime().newIOError(e.getMessage());
        }
    }

    public IRubyObject sysread(IRubyObject number) {
        try {
            String buf = this.handler.sysread(RubyNumeric.fix2int(number));
            return this.getRuntime().newString(buf);
        }
        catch (IOHandler.BadDescriptorException e) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        catch (EOFException e) {
            throw this.getRuntime().newEOFError();
        }
        catch (IOException e) {
            if ("File not open".equals(e.getMessage())) {
                throw this.getRuntime().newIOError(e.getMessage());
            }
            throw this.getRuntime().newSystemCallError(e.getMessage());
        }
    }

    public IRubyObject read(IRubyObject[] args) {
        try {
            String buf;
            String string = buf = args.length > 0 ? this.handler.read(RubyNumeric.fix2int(args[0])) : this.handler.getsEntireStream();
            if (buf == null) {
                if (args.length > 0) {
                    return this.getRuntime().getNil();
                }
                return this.getRuntime().newString("");
            }
            return this.getRuntime().newString(buf);
        }
        catch (IOHandler.BadDescriptorException e) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        catch (EOFException e) {
            return this.getRuntime().getNil();
        }
        catch (IOException e) {
            throw this.getRuntime().newIOError(e.getMessage());
        }
    }

    public IRubyObject readchar() {
        this.checkReadable();
        try {
            int c = this.handler.getc();
            if (c == -1) {
                throw this.getRuntime().newEOFError();
            }
            return this.getRuntime().newFixnum(c);
        }
        catch (IOHandler.BadDescriptorException e) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        catch (EOFException e) {
            throw this.getRuntime().newEOFError();
        }
        catch (IOException e) {
            throw this.getRuntime().newIOError(e.getMessage());
        }
    }

    public IRubyObject each_byte() {
        try {
            ThreadContext context = this.getRuntime().getCurrentContext();
            int c = this.handler.getc();
            while (c != -1) {
                assert (c < 256);
                context.yield(this.getRuntime().newFixnum(c));
                c = this.handler.getc();
            }
            return this.getRuntime().getNil();
        }
        catch (IOHandler.BadDescriptorException e) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        catch (EOFException e) {
            return this.getRuntime().getNil();
        }
        catch (IOException e) {
            throw this.getRuntime().newIOError(e.getMessage());
        }
    }

    public RubyIO each_line(IRubyObject[] args) {
        ThreadContext context = this.getRuntime().getCurrentContext();
        IRubyObject line = this.internalGets(args);
        while (!line.isNil()) {
            context.yield(line);
            line = this.internalGets(args);
        }
        return this;
    }

    public RubyArray readlines(IRubyObject[] args) {
        IRubyObject line;
        IRubyObject[] separatorArgument;
        if (args.length > 0) {
            if (!args[0].isKindOf(this.getRuntime().getNilClass()) && !args[0].isKindOf(this.getRuntime().getString())) {
                throw this.getRuntime().newTypeError(args[0], this.getRuntime().getString());
            }
            separatorArgument = new IRubyObject[]{args[0]};
        } else {
            separatorArgument = IRubyObject.NULL_ARRAY;
        }
        RubyArray result = this.getRuntime().newArray();
        while (!(line = this.internalGets(separatorArgument)).isNil()) {
            result.append(line);
        }
        return result;
    }

    public RubyIO to_io() {
        return this;
    }

    @Override
    public String toString() {
        return "RubyIO(" + this.modes + ", " + fileno + ")";
    }
}

