/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.IRuby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.exceptions.JumpException;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyProc
extends RubyObject {
    private Block block = null;
    private RubyModule wrapper = null;

    public RubyProc(IRuby runtime, RubyClass rubyClass) {
        super(runtime, rubyClass);
    }

    public Block getBlock() {
        return this.block;
    }

    public RubyModule getWrapper() {
        return this.wrapper;
    }

    public static RubyProc newProc(IRuby runtime, boolean isLambda) {
        ThreadContext tc = runtime.getCurrentContext();
        if (!tc.isBlockGiven() && !tc.isFBlockGiven()) {
            throw runtime.newArgumentError("tried to create Proc object without a block");
        }
        if (!isLambda || !tc.isBlockGiven()) {
            // empty if block
        }
        Block block = tc.getCurrentBlock();
        if (!isLambda && block.getBlockObject() instanceof RubyProc) {
            return (RubyProc)block.getBlockObject();
        }
        RubyProc newProc = new RubyProc(runtime, runtime.getClass("Proc"));
        newProc.block = block.cloneBlock();
        newProc.wrapper = tc.getWrapper();
        newProc.block.isLambda = isLambda;
        block.setBlockObject(newProc);
        return newProc;
    }

    @Override
    protected IRubyObject doClone() {
        RubyProc newProc = new RubyProc(this.getRuntime(), this.getRuntime().getClass("Proc"));
        newProc.block = this.getBlock();
        newProc.wrapper = this.getWrapper();
        return newProc;
    }

    public IRubyObject binding() {
        return this.getRuntime().newBinding(this.block);
    }

    public IRubyObject call(IRubyObject[] args) {
        return this.call(args, null);
    }

    public IRubyObject call(IRubyObject[] args, IRubyObject self) {
        assert (args != null);
        ThreadContext context = this.getRuntime().getCurrentContext();
        RubyModule oldWrapper = context.getWrapper();
        context.setWrapper(this.wrapper);
        try {
            if (this.block.isLambda) {
                this.block.arity().checkArity(this.getRuntime(), args);
            }
            IRubyObject iRubyObject = this.block.call(args, self);
            return iRubyObject;
        }
        catch (JumpException je) {
            if (je.getJumpType() == JumpException.JumpType.BreakJump) {
                if (this.block.isLambda) {
                    IRubyObject iRubyObject = (IRubyObject)je.getPrimaryData();
                    return iRubyObject;
                }
                throw this.getRuntime().newLocalJumpError("unexpected return");
            }
            if (je.getJumpType() == JumpException.JumpType.ReturnJump) {
                Object target = je.getPrimaryData();
                if (target == this || this.block.isLambda) {
                    IRubyObject iRubyObject = (IRubyObject)je.getSecondaryData();
                    return iRubyObject;
                }
                if (target == null) {
                    throw this.getRuntime().newLocalJumpError("unexpected return");
                }
                throw je;
            }
            throw je;
        }
        finally {
            context.setWrapper(oldWrapper);
        }
    }

    public RubyFixnum arity() {
        return this.getRuntime().newFixnum(this.block.arity().getValue());
    }

    public RubyProc to_proc() {
        return this;
    }
}

