/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jruby.IRuby;
import org.jruby.RegexpTranslator;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyMatchData;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.parser.ReOptions;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.util.PrintfFormat;

public class RubyRegexp
extends RubyObject
implements ReOptions {
    private static final RegexpTranslator REGEXP_TRANSLATOR = new RegexpTranslator();
    private static final Pattern SPECIAL_CHARS = Pattern.compile("([\\\t\\\n\\\f\\\r\\ \\#\\\u000b\\+\\[\\]\\.\\?\\*\\(\\)\\{\\}\\|\\\\\\^\\$])");
    private Pattern pattern;
    private Code code;
    private String lastTarget = null;
    private Matcher matcher = null;

    Code getCode() {
        return this.code;
    }

    public RubyRegexp(IRuby runtime) {
        super(runtime, runtime.getClass("Regexp"));
    }

    public static RubyClass createRegexpClass(IRuby runtime) {
        RubyClass regexpClass = runtime.defineClass("Regexp", runtime.getObject());
        CallbackFactory callbackFactory = runtime.callbackFactory(RubyRegexp.class);
        regexpClass.defineConstant("IGNORECASE", runtime.newFixnum(1L));
        regexpClass.defineConstant("EXTENDED", runtime.newFixnum(2L));
        regexpClass.defineConstant("MULTILINE", runtime.newFixnum(4L));
        regexpClass.defineMethod("initialize", callbackFactory.getOptMethod("initialize"));
        regexpClass.defineMethod("clone", callbackFactory.getMethod("rbClone"));
        regexpClass.defineMethod("==", callbackFactory.getMethod("equal", IRubyObject.class));
        regexpClass.defineMethod("===", callbackFactory.getMethod("match", IRubyObject.class));
        regexpClass.defineMethod("=~", callbackFactory.getMethod("match", IRubyObject.class));
        regexpClass.defineMethod("~", callbackFactory.getMethod("match2"));
        regexpClass.defineMethod("match", callbackFactory.getMethod("match_m", IRubyObject.class));
        regexpClass.defineMethod("inspect", callbackFactory.getMethod("inspect"));
        regexpClass.defineMethod("source", callbackFactory.getMethod("source"));
        regexpClass.defineMethod("casefold?", callbackFactory.getMethod("casefold"));
        regexpClass.defineMethod("kcode", callbackFactory.getMethod("kcode"));
        regexpClass.defineMethod("to_s", callbackFactory.getMethod("to_s"));
        regexpClass.defineSingletonMethod("new", callbackFactory.getOptSingletonMethod("newInstance"));
        regexpClass.defineSingletonMethod("compile", callbackFactory.getOptSingletonMethod("newInstance"));
        regexpClass.defineSingletonMethod("quote", callbackFactory.getSingletonMethod("quote", RubyString.class));
        regexpClass.defineSingletonMethod("escape", callbackFactory.getSingletonMethod("quote", RubyString.class));
        regexpClass.defineSingletonMethod("last_match", callbackFactory.getSingletonMethod("last_match_s"));
        regexpClass.defineSingletonMethod("union", callbackFactory.getOptSingletonMethod("union"));
        return regexpClass;
    }

    public void initialize(String regex, int options) {
        try {
            this.pattern = REGEXP_TRANSLATOR.translate(regex, options, this.code.flags());
        }
        catch (PatternSyntaxException e) {
            throw this.getRuntime().newSyntaxError(e.getMessage());
        }
    }

    public static String escapeSpecialChars(String original) {
        return SPECIAL_CHARS.matcher(original).replaceAll("\\\\$1");
    }

    private void recompileIfNeeded() {
        this.checkInitialized();
    }

    private void checkInitialized() {
        if (this.pattern == null) {
            throw this.getRuntime().newTypeError("uninitialized Regexp");
        }
    }

    public static RubyRegexp regexpValue(IRubyObject obj) {
        if (obj instanceof RubyRegexp) {
            return (RubyRegexp)obj;
        }
        if (obj instanceof RubyString) {
            return RubyRegexp.newRegexp(obj.getRuntime().newString(RubyRegexp.escapeSpecialChars(((RubyString)obj).toString())), 0, null);
        }
        throw obj.getRuntime().newArgumentError("can't convert arg to Regexp");
    }

    public static RubyRegexp newRegexp(RubyString str, int options, String lang) {
        return RubyRegexp.newRegexp(str.getRuntime(), str.toString(), options, lang);
    }

    public static RubyRegexp newRegexp(IRuby runtime, Pattern pattern, String lang) {
        RubyRegexp re = new RubyRegexp(runtime);
        re.code = Code.create(runtime, lang);
        re.pattern = pattern;
        return re;
    }

    public static RubyRegexp newRegexp(IRuby runtime, String str, int options, String kcode) {
        RubyRegexp re = new RubyRegexp(runtime);
        re.code = Code.create(runtime, kcode);
        re.initialize(str, options);
        return re;
    }

    public static RubyRegexp newInstance(IRubyObject recv, IRubyObject[] args) {
        RubyRegexp re = new RubyRegexp(recv.getRuntime());
        re.setMetaClass((RubyClass)recv);
        re.initialize(args);
        return re;
    }

    @Override
    public IRubyObject initialize(IRubyObject[] args) {
        String pat = args[0] instanceof RubyRegexp ? ((RubyRegexp)args[0]).source().toString() : RubyString.stringValue(args[0]).toString();
        int opts = 0;
        if (args.length > 1) {
            if (args[1] instanceof RubyFixnum) {
                opts = (int)((RubyFixnum)args[1]).getLongValue();
            } else if (args[1].isTrue()) {
                opts |= 1;
            }
        }
        this.code = args.length > 2 ? Code.create(this.getRuntime(), RubyString.stringValue(args[2]).toString()) : Code.create(this.getRuntime(), null);
        this.initialize(pat, opts);
        return this.getRuntime().getNil();
    }

    public static RubyString quote(IRubyObject recv, RubyString str) {
        return (RubyString)recv.getRuntime().newString(RubyRegexp.escapeSpecialChars(str.toString())).infectBy(str);
    }

    public static IRubyObject last_match_s(IRubyObject recv) {
        return recv.getRuntime().getCurrentContext().getBackref();
    }

    @Override
    public IRubyObject equal(IRubyObject other) {
        if (other == this) {
            return this.getRuntime().getTrue();
        }
        if (!(other instanceof RubyRegexp)) {
            return this.getRuntime().getFalse();
        }
        RubyRegexp re = (RubyRegexp)other;
        this.checkInitialized();
        if (!re.pattern.pattern().equals(this.pattern.pattern()) || re.pattern.flags() != this.pattern.flags()) {
            return this.getRuntime().getFalse();
        }
        if (this.code != re.code) {
            return this.getRuntime().getFalse();
        }
        return this.getRuntime().getTrue();
    }

    public IRubyObject match2() {
        IRubyObject target = this.getRuntime().getCurrentContext().getLastline();
        return target instanceof RubyString ? this.match(target) : this.getRuntime().getNil();
    }

    @Override
    public IRubyObject match(IRubyObject target) {
        int result;
        if (target.isNil()) {
            return this.getRuntime().getFalse();
        }
        if (target instanceof RubySymbol || target instanceof RubyHash || target instanceof RubyArray) {
            return this.getRuntime().getFalse();
        }
        String string = RubyString.stringValue(target).toString();
        if (string.length() == 0) {
            string = "\n";
        }
        return (result = this.search(string, 0)) < 0 ? this.getRuntime().getNil() : this.getRuntime().newFixnum(result);
    }

    public IRubyObject match_m(IRubyObject target) {
        if (target.isNil()) {
            return target;
        }
        IRubyObject result = this.match(target);
        return result.isNil() ? result : this.getRuntime().getCurrentContext().getBackref().rbClone();
    }

    public RubyString source() {
        this.checkInitialized();
        return this.getRuntime().newString(this.pattern.pattern());
    }

    public IRubyObject kcode() {
        return this.code.kcode(this.getRuntime());
    }

    public RubyBoolean casefold() {
        this.checkInitialized();
        return this.getRuntime().newBoolean((this.pattern.flags() & 2) != 0);
    }

    public static IRubyObject nth_match(int n, IRubyObject match) {
        IRubyObject nil = match.getRuntime().getNil();
        if (match.isNil()) {
            return nil;
        }
        RubyMatchData rmd = (RubyMatchData)match;
        if ((long)n > rmd.getSize()) {
            return nil;
        }
        if (n < 0 && (n = (int)((long)n + rmd.getSize())) <= 0) {
            return nil;
        }
        return rmd.group(n);
    }

    public static IRubyObject last_match(IRubyObject match) {
        return match.isNil() ? match : ((RubyMatchData)match).group(0L);
    }

    public static IRubyObject match_pre(IRubyObject match) {
        return match.isNil() ? match : ((RubyMatchData)match).pre_match();
    }

    public static IRubyObject match_post(IRubyObject match) {
        return match.isNil() ? match : ((RubyMatchData)match).post_match();
    }

    public static IRubyObject match_last(IRubyObject match) {
        if (match.isNil()) {
            return match;
        }
        RubyMatchData md = (RubyMatchData)match;
        for (long i = md.getSize() - 1L; i > 0L; --i) {
            if (md.group(i).isNil()) continue;
            return md.group(i);
        }
        return md.getRuntime().getNil();
    }

    public int search(String target, int pos) {
        if (pos > target.length()) {
            return -1;
        }
        this.recompileIfNeeded();
        IRubyObject result = this.match(target, pos);
        this.getRuntime().getCurrentContext().setBackref(result);
        return result instanceof RubyMatchData ? ((RubyMatchData)result).matchStartPosition() : -1;
    }

    public IRubyObject search2(String str) {
        IRubyObject result = this.match(str, 0);
        this.getRuntime().getCurrentContext().setBackref(result);
        return result;
    }

    public int searchAgain(String target) {
        if (this.matcher == null || !target.equals(this.lastTarget)) {
            this.matcher = this.pattern.matcher(target);
            this.lastTarget = target;
        }
        if (!this.matcher.find()) {
            return -1;
        }
        int count = this.matcher.groupCount() + 1;
        int[] begin = new int[count];
        int[] end = new int[count];
        for (int i = 0; i < count; ++i) {
            begin[i] = this.matcher.start(i);
            end[i] = this.matcher.end(i);
        }
        RubyMatchData match = new RubyMatchData(this.getRuntime(), target, begin, end);
        this.getRuntime().getCurrentContext().setBackref(match);
        return match.matchStartPosition();
    }

    public IRubyObject match(String target, int startPos) {
        Matcher aMatcher = this.pattern.matcher(target);
        if (aMatcher.find(startPos)) {
            int count = aMatcher.groupCount() + 1;
            int[] begin = new int[count];
            int[] end = new int[count];
            for (int i = 0; i < count; ++i) {
                begin[i] = aMatcher.start(i);
                end[i] = aMatcher.end(i);
            }
            return new RubyMatchData(this.getRuntime(), target, begin, end);
        }
        return this.getRuntime().getNil();
    }

    public IRubyObject regsub(IRubyObject str, RubyMatchData match) {
        String repl = RubyString.stringValue(str).toString();
        StringBuffer sb = new StringBuffer("");
        int pos = 0;
        int end = repl.length();
        block8: while (pos < end) {
            char c;
            if ((c = repl.charAt(pos++)) == '\\' && pos < end) {
                IRubyObject ins;
                c = repl.charAt(pos++);
                switch (c) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        ins = match.group(c - 48);
                        break;
                    }
                    case '&': {
                        ins = match.group(0L);
                        break;
                    }
                    case '`': {
                        ins = match.pre_match();
                        break;
                    }
                    case '\'': {
                        ins = match.post_match();
                        break;
                    }
                    case '+': {
                        ins = RubyRegexp.match_last(match);
                        break;
                    }
                    case '\\': {
                        sb.append(c);
                        continue block8;
                    }
                    default: {
                        sb.append('\\').append(c);
                        continue block8;
                    }
                }
                if (ins.isNil()) continue;
                sb.append(((RubyString)ins).getValue());
                continue;
            }
            sb.append(c);
        }
        return this.getRuntime().newString(sb.toString());
    }

    @Override
    public IRubyObject rbClone() {
        RubyRegexp newObj = new RubyRegexp(this.getRuntime());
        newObj.pattern = this.pattern;
        newObj.code = this.code;
        newObj.setTaint(this.isTaint());
        newObj.initCopy(this);
        newObj.setFrozen(this.isFrozen());
        return newObj;
    }

    @Override
    public IRubyObject inspect() {
        String regex = this.pattern.pattern();
        int length = regex.length();
        StringBuffer sb = new StringBuffer(length + 2);
        sb.append('/');
        for (int i = 0; i < length; ++i) {
            char c = regex.charAt(i);
            if (RubyString.isAlnum(c)) {
                sb.append(c);
                continue;
            }
            if (c == '/') {
                if (i == 0 || regex.charAt(i - 1) != '\\') {
                    sb.append("\\");
                }
                sb.append(c);
                continue;
            }
            if (RubyString.isPrint(c)) {
                sb.append(c);
                continue;
            }
            if (c == '\n') {
                sb.append('\\').append('n');
                continue;
            }
            if (c == '\r') {
                sb.append('\\').append('r');
                continue;
            }
            if (c == '\t') {
                sb.append('\\').append('t');
                continue;
            }
            if (c == '\f') {
                sb.append('\\').append('f');
                continue;
            }
            if (c == '\u000b') {
                sb.append('\\').append('v');
                continue;
            }
            if (c == '\u0007') {
                sb.append('\\').append('a');
                continue;
            }
            if (c == '\u001b') {
                sb.append('\\').append('e');
                continue;
            }
            sb.append(new PrintfFormat("\\%.3o").sprintf(c));
        }
        sb.append('/');
        if (this.code == Code.NONE) {
            sb.append('n');
        } else if (this.code == Code.UTF8) {
            sb.append('u');
        } else if (this.code == Code.SJIS) {
            sb.append('s');
        }
        if ((this.pattern.flags() & 2) > 0) {
            sb.append('i');
        }
        if ((this.pattern.flags() & 0x20) > 0) {
            sb.append('m');
        }
        if ((this.pattern.flags() & 4) > 0) {
            sb.append('x');
        }
        return this.getRuntime().newString(sb.toString());
    }

    public static IRubyObject union(IRubyObject recv, IRubyObject[] args) {
        if (args.length == 0) {
            return RubyRegexp.newInstance(recv, new IRubyObject[]{recv.getRuntime().newString("(?!)")});
        }
        if (args.length == 1) {
            IRubyObject arg = args[0].convertToType("Regexp", "to_regexp", false);
            if (!arg.isNil()) {
                return arg;
            }
            return RubyRegexp.newInstance(recv, new IRubyObject[]{RubyRegexp.quote(recv, args[0].convertToString())});
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < args.length; ++i) {
            IRubyObject arg;
            if (i > 0) {
                buffer.append("|");
            }
            if ((arg = args[i].convertToType("Regexp", "to_regexp", false)).isNil()) {
                arg = RubyRegexp.quote(recv, args[i].convertToString());
            }
            buffer.append(arg.toString());
        }
        return RubyRegexp.newInstance(recv, new IRubyObject[]{recv.getRuntime().newString(buffer.toString())});
    }

    @Override
    public IRubyObject to_s() {
        return this.getRuntime().newString(this.toString());
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer(100);
        StringBuffer off = new StringBuffer(3);
        buffer.append("(?");
        this.flagToString(buffer, off, 32, 'm');
        this.flagToString(buffer, off, 2, 'i');
        this.flagToString(buffer, off, 4, 'x');
        if (off.length() > 0) {
            buffer.append('-').append(off);
        }
        buffer.append(':');
        buffer.append(this.pattern.pattern().replaceAll("^/|([^\\\\])/", "$1\\\\/"));
        buffer.append(')');
        return buffer.toString();
    }

    private void flagToString(StringBuffer buffer, StringBuffer off, int flag, char c) {
        if ((this.pattern.flags() & flag) != 0) {
            buffer.append(c);
        } else {
            off.append(c);
        }
    }

    @Override
    public void marshalTo(MarshalStream output) throws IOException {
        output.write(47);
        output.dumpString(this.pattern.pattern());
        int flags = 0;
        if ((this.pattern.flags() & 0x20) > 0) {
            flags |= 4;
        }
        if ((this.pattern.flags() & 2) > 0) {
            flags |= 1;
        }
        if ((this.pattern.flags() & 4) > 0) {
            flags |= 2;
        }
        output.dumpInt(flags);
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public static final class Code {
        public static final Code NIL = new Code(null);
        public static final Code NONE = new Code("none");
        public static final Code UTF8 = new Code("utf8");
        public static final Code SJIS = new Code("sjis");
        private String kcode;

        private Code(String kcode) {
            this.kcode = kcode;
        }

        public static Code create(IRuby runtime, String lang) {
            if (lang == null) {
                return NIL;
            }
            if (lang.charAt(0) == 'n' || lang.charAt(0) == 'N') {
                return NONE;
            }
            if (lang.charAt(0) == 'u' || lang.charAt(0) == 'U') {
                return UTF8;
            }
            if (lang.charAt(0) == 's' || lang.charAt(0) == 'S') {
                runtime.getWarnings().warn("JRuby supports only Unicode regexp.");
                return SJIS;
            }
            return NIL;
        }

        public IRubyObject kcode(IRuby runtime) {
            if (this.kcode == null) {
                return runtime.getNil();
            }
            return runtime.newString(this.kcode);
        }

        public int flags() {
            int flags = 0;
            if (this == UTF8) {
                flags |= 0x40;
            }
            return flags |= 1;
        }
    }
}

