/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;
import org.jruby.ast.Node;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.Instruction;
import org.jruby.lexer.yacc.ISourcePosition;

public class DVarNode
extends Node {
    static final long serialVersionUID = -8479281167248673970L;
    private String name;
    private int location;

    public DVarNode(ISourcePosition position, int location, String name) {
        super(position, 33);
        this.location = location;
        this.name = name.intern();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.name = this.name.intern();
    }

    @Override
    public Instruction accept(NodeVisitor iVisitor) {
        return iVisitor.visitDVarNode(this);
    }

    public int getDepth() {
        return this.location >> 16;
    }

    public int getIndex() {
        return this.location & 0xFFFF;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public List childNodes() {
        return EMPTY_LIST;
    }
}

