/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;
import org.jruby.ast.Node;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.Instruction;
import org.jruby.lexer.yacc.ISourcePosition;

public class OpAsgnNode
extends Node {
    static final long serialVersionUID = -1950295226516487753L;
    private final Node receiverNode;
    private final Node valueNode;
    private String variableName;
    private String operatorName;
    private String variableNameAsgn;

    public OpAsgnNode(ISourcePosition position, Node receiverNode, Node valueNode, String variableName, String methodName) {
        super(position, 66);
        this.receiverNode = receiverNode;
        this.valueNode = valueNode;
        this.variableName = variableName.intern();
        this.operatorName = methodName.intern();
        this.variableNameAsgn = (variableName + "=").intern();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.variableName = this.variableName.intern();
        this.operatorName = this.operatorName.intern();
        this.variableNameAsgn = this.variableNameAsgn.intern();
    }

    @Override
    public Instruction accept(NodeVisitor iVisitor) {
        return iVisitor.visitOpAsgnNode(this);
    }

    public String getOperatorName() {
        return this.operatorName;
    }

    public Node getReceiverNode() {
        return this.receiverNode;
    }

    public Node getValueNode() {
        return this.valueNode;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public String getVariableNameAsgn() {
        return this.variableNameAsgn;
    }

    @Override
    public List childNodes() {
        return Node.createList(this.receiverNode, this.valueNode);
    }
}

