/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast.visitor;

import org.jruby.ast.BeginNode;
import org.jruby.ast.BlockNode;
import org.jruby.ast.BreakNode;
import org.jruby.ast.ClassNode;
import org.jruby.ast.DefnNode;
import org.jruby.ast.DefsNode;
import org.jruby.ast.IfNode;
import org.jruby.ast.ModuleNode;
import org.jruby.ast.NewlineNode;
import org.jruby.ast.NextNode;
import org.jruby.ast.Node;
import org.jruby.ast.RedoNode;
import org.jruby.ast.RetryNode;
import org.jruby.ast.ReturnNode;
import org.jruby.ast.UntilNode;
import org.jruby.ast.WhileNode;
import org.jruby.ast.visitor.AbstractVisitor;
import org.jruby.evaluator.Instruction;

public class ExpressionVisitor
extends AbstractVisitor {
    private boolean expression;

    public boolean isExpression(Node node) {
        this.acceptNode(node);
        return this.expression;
    }

    @Override
    protected Instruction visitNode(Node iVisited) {
        this.expression = true;
        return null;
    }

    @Override
    public Instruction visitBeginNode(BeginNode iVisited) {
        this.acceptNode(iVisited.getBodyNode());
        return null;
    }

    @Override
    public Instruction visitBlockNode(BlockNode iVisited) {
        this.acceptNode(iVisited.getLast());
        return null;
    }

    @Override
    public Instruction visitBreakNode(BreakNode iVisited) {
        this.acceptNode(iVisited.getValueNode());
        return null;
    }

    @Override
    public Instruction visitClassNode(ClassNode iVisited) {
        this.expression = false;
        return null;
    }

    @Override
    public Instruction visitDefnNode(DefnNode iVisited) {
        this.expression = false;
        return null;
    }

    @Override
    public Instruction visitDefsNode(DefsNode iVisited) {
        this.expression = false;
        return null;
    }

    @Override
    public Instruction visitIfNode(IfNode iVisited) {
        this.expression = this.isExpression(iVisited.getThenBody()) && this.isExpression(iVisited.getElseBody());
        return null;
    }

    @Override
    public Instruction visitModuleNode(ModuleNode iVisited) {
        this.expression = false;
        return null;
    }

    @Override
    public Instruction visitNewlineNode(NewlineNode iVisited) {
        this.acceptNode(iVisited.getNextNode());
        return null;
    }

    @Override
    public Instruction visitNextNode(NextNode iVisited) {
        this.expression = false;
        return null;
    }

    @Override
    public Instruction visitRedoNode(RedoNode iVisited) {
        this.expression = false;
        return null;
    }

    @Override
    public Instruction visitRetryNode(RetryNode iVisited) {
        this.expression = false;
        return null;
    }

    @Override
    public Instruction visitReturnNode(ReturnNode iVisited) {
        this.expression = false;
        return null;
    }

    @Override
    public Instruction visitUntilNode(UntilNode iVisited) {
        this.expression = false;
        return null;
    }

    @Override
    public Instruction visitWhileNode(WhileNode iVisited) {
        this.expression = false;
        return null;
    }
}

