/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.environment;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStreamReader;
import java.util.Map;
import org.jruby.IRuby;
import org.jruby.RubyKernel;
import org.jruby.RubyString;
import org.jruby.environment.IOSEnvironmentReader;
import org.jruby.environment.OSEnvironment;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.builtin.IRubyObject;

class OSEnvironmentReaderFromRuntimeExec
implements IOSEnvironmentReader {
    private final OSEnvironment environmentReader = new OSEnvironment();

    OSEnvironmentReaderFromRuntimeExec() {
    }

    @Override
    public boolean isAccessible(IRuby runtime) {
        return true;
    }

    private String getEnvCommand() {
        String osname = System.getProperty("os.name").toLowerCase();
        String command = osname.indexOf("windows 9") > -1 ? "command.com /c set" : (osname.indexOf("nt") > -1 || osname.indexOf("windows 20") > -1 || osname.indexOf("windows xp") > -1 ? "cmd.exe /c set" : "env");
        return command;
    }

    @Override
    public Map getVariables(IRuby runtime) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            RubyKernel.runInShell(runtime, new IRubyObject[]{RubyString.newString(runtime, this.getEnvCommand())}, output);
        }
        catch (RaiseException e) {
            this.environmentReader.handleException(e);
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(output.toByteArray())));
        return this.environmentReader.getVariablesFrom(reader);
    }
}

