/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.evaluator;

import org.jruby.IRuby;
import org.jruby.RubyArray;
import org.jruby.RubyModule;
import org.jruby.ast.CallNode;
import org.jruby.ast.ClassVarAsgnNode;
import org.jruby.ast.ClassVarDeclNode;
import org.jruby.ast.ConstDeclNode;
import org.jruby.ast.DAsgnNode;
import org.jruby.ast.GlobalAsgnNode;
import org.jruby.ast.InstAsgnNode;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.ast.MultipleAsgnNode;
import org.jruby.ast.Node;
import org.jruby.evaluator.EvaluationState;
import org.jruby.runtime.CallType;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class AssignmentVisitor {
    public static IRubyObject assign(ThreadContext context, IRubyObject self, Node node, IRubyObject value, boolean check) {
        IRubyObject result = null;
        IRuby runtime = context.getRuntime();
        switch (node.nodeId) {
            case 15: {
                CallNode iVisited = (CallNode)node;
                IRubyObject receiver = EvaluationState.eval(context, iVisited.getReceiverNode(), self);
                if (iVisited.getArgsNode() == null) {
                    receiver.callMethod(context, iVisited.getName(), new IRubyObject[]{value}, CallType.NORMAL);
                    break;
                }
                RubyArray args = (RubyArray)EvaluationState.eval(context, iVisited.getArgsNode(), self);
                args.append(value);
                receiver.callMethod(context, iVisited.getName(), args.toJavaArray(), CallType.NORMAL);
                break;
            }
            case 18: {
                ClassVarAsgnNode iVisited = (ClassVarAsgnNode)node;
                context.getRubyClass().setClassVar(iVisited.getName(), value);
                break;
            }
            case 19: {
                ClassVarDeclNode iVisited = (ClassVarDeclNode)node;
                if (runtime.getVerbose().isTrue() && context.getRubyClass().isSingleton()) {
                    runtime.getWarnings().warn(iVisited.getPosition(), "Declaring singleton class variable.");
                }
                context.getRubyClass().setClassVar(iVisited.getName(), value);
                break;
            }
            case 23: {
                ConstDeclNode iVisited = (ConstDeclNode)node;
                if (iVisited.getPathNode() == null) {
                    context.getRubyClass().defineConstant(iVisited.getName(), value);
                    break;
                }
                ((RubyModule)EvaluationState.eval(context, iVisited.getPathNode(), self)).defineConstant(iVisited.getName(), value);
                break;
            }
            case 25: {
                DAsgnNode iVisited = (DAsgnNode)node;
                context.getCurrentScope().setValue(iVisited.getIndex(), value, iVisited.getDepth());
                break;
            }
            case 43: {
                GlobalAsgnNode iVisited = (GlobalAsgnNode)node;
                runtime.getGlobalVariables().set(iVisited.getName(), value);
                break;
            }
            case 47: {
                InstAsgnNode iVisited = (InstAsgnNode)node;
                self.setInstanceVariable(iVisited.getName(), value);
                break;
            }
            case 52: {
                LocalAsgnNode iVisited = (LocalAsgnNode)node;
                context.getCurrentScope().setValue(iVisited.getIndex(), value, iVisited.getDepth());
                break;
            }
            case 58: {
                MultipleAsgnNode iVisited = (MultipleAsgnNode)node;
                if (!(value instanceof RubyArray)) {
                    value = RubyArray.newArray(runtime, value);
                }
                result = context.mAssign(self, iVisited, (RubyArray)value, check);
                break;
            }
        }
        return result;
    }
}

