/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime;

import java.util.ArrayList;
import org.jruby.IRuby;
import org.jruby.RubyProc;
import org.jruby.internal.runtime.UndefinedAccessor;
import org.jruby.runtime.IAccessor;

public final class GlobalVariable {
    private IAccessor accessor;
    private ArrayList traces = null;
    private boolean tracing;

    public GlobalVariable(IAccessor accessor) {
        this.accessor = accessor;
    }

    public static GlobalVariable newUndefined(IRuby runtime, String name) {
        GlobalVariable variable = new GlobalVariable(null);
        variable.setAccessor(new UndefinedAccessor(runtime, variable, name));
        return variable;
    }

    public IAccessor getAccessor() {
        return this.accessor;
    }

    public ArrayList getTraces() {
        return this.traces;
    }

    public void addTrace(RubyProc trace) {
        if (this.traces == null) {
            this.traces = new ArrayList();
        }
        this.traces.add(trace);
    }

    public void setAccessor(IAccessor accessor) {
        this.accessor = accessor;
    }

    public boolean isTracing() {
        return this.tracing;
    }
}

