/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.main;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import org.ablaf.ast.IAstEncoder;
import org.jruby.ast.util.RubyAstMarshal;
import org.jruby.common.NullWarnings;
import org.jruby.lexer.yacc.LexerSource;
import org.jruby.lexer.yacc.SyntaxException;
import org.jruby.parser.DefaultRubyParser;
import org.jruby.parser.RubyParserConfiguration;
import org.jruby.parser.RubyParserPool;
import org.jruby.parser.RubyParserResult;

public class ASTSerializer {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void serialize(File input, File outputFile) throws IOException {
        BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(outputFile));
        IAstEncoder encoder = RubyAstMarshal.getInstance().openEncoder(output);
        try {
            ASTSerializer.serialize(input, encoder);
        }
        finally {
            encoder.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void serialize(File input, IAstEncoder encoder) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(input));
        RubyParserConfiguration config = new RubyParserConfiguration();
        DefaultRubyParser parser = null;
        RubyParserResult result = null;
        try {
            parser = RubyParserPool.getInstance().borrowParser();
            parser.setWarnings(new NullWarnings());
            result = parser.parse(config, LexerSource.getSource(input.toString(), reader));
        }
        catch (SyntaxException e) {
        }
        finally {
            RubyParserPool.getInstance().returnParser(parser);
        }
        ((Reader)reader).close();
        encoder.writeNode(result.getAST());
    }
}

