/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.parser;

import java.util.Iterator;
import org.jruby.ast.AndNode;
import org.jruby.ast.ArgsCatNode;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.AssignableNode;
import org.jruby.ast.BackRefNode;
import org.jruby.ast.BlockNode;
import org.jruby.ast.BlockPassNode;
import org.jruby.ast.CallNode;
import org.jruby.ast.ClassVarAsgnNode;
import org.jruby.ast.ClassVarDeclNode;
import org.jruby.ast.ClassVarNode;
import org.jruby.ast.ConstDeclNode;
import org.jruby.ast.ConstNode;
import org.jruby.ast.DAsgnNode;
import org.jruby.ast.DRegexpNode;
import org.jruby.ast.DStrNode;
import org.jruby.ast.DotNode;
import org.jruby.ast.EvStrNode;
import org.jruby.ast.FCallNode;
import org.jruby.ast.FalseNode;
import org.jruby.ast.FixnumNode;
import org.jruby.ast.FlipNode;
import org.jruby.ast.GlobalAsgnNode;
import org.jruby.ast.GlobalVarNode;
import org.jruby.ast.InstAsgnNode;
import org.jruby.ast.InstVarNode;
import org.jruby.ast.ListNode;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.ast.Match2Node;
import org.jruby.ast.Match3Node;
import org.jruby.ast.MatchNode;
import org.jruby.ast.MultipleAsgnNode;
import org.jruby.ast.NewlineNode;
import org.jruby.ast.NilNode;
import org.jruby.ast.Node;
import org.jruby.ast.NthRefNode;
import org.jruby.ast.OptNNode;
import org.jruby.ast.OrNode;
import org.jruby.ast.RegexpNode;
import org.jruby.ast.RootNode;
import org.jruby.ast.SValueNode;
import org.jruby.ast.SelfNode;
import org.jruby.ast.SplatNode;
import org.jruby.ast.StrNode;
import org.jruby.ast.SuperNode;
import org.jruby.ast.TrueNode;
import org.jruby.ast.YieldNode;
import org.jruby.ast.types.ILiteralNode;
import org.jruby.ast.visitor.BreakStatementVisitor;
import org.jruby.ast.visitor.ExpressionVisitor;
import org.jruby.ast.visitor.UselessStatementVisitor;
import org.jruby.common.IRubyWarnings;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.lexer.yacc.ISourcePositionHolder;
import org.jruby.lexer.yacc.SyntaxException;
import org.jruby.lexer.yacc.Token;
import org.jruby.parser.BlockStaticScope;
import org.jruby.parser.LocalStaticScope;
import org.jruby.parser.RubyParserConfiguration;
import org.jruby.parser.RubyParserResult;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.util.IdUtil;

public class ParserSupport {
    private StaticScope currentScope;
    private ExpressionVisitor expressionVisitor = new ExpressionVisitor();
    private int inSingleton;
    private boolean inDefinition;
    private IRubyWarnings warnings;
    private RubyParserConfiguration configuration;
    private RubyParserResult result;

    public void reset() {
        this.inSingleton = 0;
        this.inDefinition = false;
    }

    public StaticScope getCurrentScope() {
        return this.currentScope;
    }

    public void popCurrentScope() {
        this.currentScope = this.currentScope.getEnclosingScope();
    }

    public void pushBlockScope() {
        this.currentScope = new BlockStaticScope(this.currentScope);
    }

    public void pushLocalScope() {
        this.currentScope = new LocalStaticScope(this.currentScope);
    }

    public Node arg_concat(ISourcePosition position, Node node1, Node node2) {
        return node2 == null ? node1 : new ArgsCatNode(position, node1, node2);
    }

    public Node arg_blk_pass(Node firstNode, BlockPassNode secondNode) {
        if (secondNode != null) {
            secondNode.setArgsNode(firstNode);
            return secondNode;
        }
        return firstNode;
    }

    public Node appendPrintToBlock(Node block) {
        ISourcePosition position = block.getPosition();
        return this.appendToBlock(block, new FCallNode(position, "print", new ArrayNode(position).add(new GlobalVarNode(position, "$_"))));
    }

    public Node appendWhileLoopToBlock(Node block, boolean chop, boolean split) {
        ISourcePosition position = block.getPosition();
        if (split) {
            block = this.appendToBlock(new GlobalAsgnNode(position, "$F", new CallNode(position, new GlobalVarNode(position, "$_"), "split", null)), block);
        }
        if (chop) {
            block = this.appendToBlock(new CallNode(position, new GlobalVarNode(position, "$_"), "chop!", null), block);
        }
        return new OptNNode(position, block);
    }

    public Node gettable2(String id, ISourcePosition position) {
        switch (IdUtil.getVarType(id)) {
            case 8: {
                return this.currentScope.declare(position, id);
            }
            case 0: {
                return new ConstNode(position, id);
            }
            case 1: {
                return new InstVarNode(position, id);
            }
            case 2: {
                return new ClassVarNode(position, id);
            }
            case 4: {
                return new GlobalVarNode(position, id);
            }
        }
        throw new SyntaxException(position, "identifier " + id + " is not valid");
    }

    public Node gettable(String id, ISourcePosition position) {
        if (id.equals("self")) {
            return new SelfNode(position);
        }
        if (id.equals("nil")) {
            return new NilNode(position);
        }
        if (id.equals("true")) {
            return new TrueNode(position);
        }
        if (id.equals("false")) {
            return new FalseNode(position);
        }
        if (id.equals("__FILE__")) {
            return new StrNode(position, position.getFile());
        }
        if (id.equals("__LINE__")) {
            return new FixnumNode(position, (long)(position.getEndLine() + 1));
        }
        return this.gettable2(id, position);
    }

    public AssignableNode assignable(Token lhs, Node value) {
        this.checkExpression(value);
        String id = (String)lhs.getValue();
        if ("self".equals(id)) {
            throw new SyntaxException(lhs.getPosition(), "Can't change the value of self");
        }
        if ("nil".equals(id)) {
            throw new SyntaxException(lhs.getPosition(), "Can't assign to nil");
        }
        if ("true".equals(id)) {
            throw new SyntaxException(lhs.getPosition(), "Can't assign to true");
        }
        if ("false".equals(id)) {
            throw new SyntaxException(lhs.getPosition(), "Can't assign to false");
        }
        if ("__FILE__".equals(id)) {
            throw new SyntaxException(lhs.getPosition(), "Can't assign to __FILE__");
        }
        if ("__LINE__".equals(id)) {
            throw new SyntaxException(lhs.getPosition(), "Can't assign to __LINE__");
        }
        switch (IdUtil.getVarType(id)) {
            case 8: {
                return this.currentScope.assign(lhs.getPosition(), id, value);
            }
            case 0: {
                if (this.isInDef() || this.isInSingle()) {
                    throw new SyntaxException(lhs.getPosition(), "dynamic constant assignment");
                }
                return new ConstDeclNode(lhs.getPosition(), null, id, value);
            }
            case 1: {
                return new InstAsgnNode(lhs.getPosition(), id, value);
            }
            case 2: {
                if (this.isInDef() || this.isInSingle()) {
                    return new ClassVarAsgnNode(lhs.getPosition(), id, value);
                }
                return new ClassVarDeclNode(lhs.getPosition(), id, value);
            }
            case 4: {
                return new GlobalAsgnNode(lhs.getPosition(), id, value);
            }
        }
        throw new SyntaxException(lhs.getPosition(), "identifier " + id + " is not valid");
    }

    public Node newline_node(Node node, ISourcePosition position) {
        if (node == null) {
            return null;
        }
        return node instanceof NewlineNode ? node : new NewlineNode(position, node);
    }

    public ISourcePosition union(ISourcePositionHolder first, ISourcePositionHolder second) {
        while (first instanceof NewlineNode) {
            first = ((NewlineNode)first).getNextNode();
        }
        while (second instanceof NewlineNode) {
            second = ((NewlineNode)second).getNextNode();
        }
        return first.getPosition().union(second.getPosition());
    }

    public Node addRootNode(Node topOfAST) {
        RootNode root = new RootNode(null, this.result.getScope(), this.appendToBlock(this.result.getAST(), topOfAST));
        return root;
    }

    public Node appendToBlock(Node head, Node tail) {
        if (tail == null) {
            return head;
        }
        if (head == null) {
            return tail;
        }
        while (head instanceof NewlineNode) {
            head = ((NewlineNode)head).getNextNode();
        }
        if (!(head instanceof BlockNode)) {
            head = new BlockNode(head.getPosition()).add(head);
        }
        if (this.warnings.isVerbose() && new BreakStatementVisitor().isBreakStatement(((ListNode)head).getLast())) {
            this.warnings.warning(tail.getPosition(), "Statement not reached.");
        }
        return ((ListNode)head).addAll(tail);
    }

    public Node getOperatorCallNode(Node firstNode, String operator) {
        this.checkExpression(firstNode);
        return new CallNode(firstNode.getPosition(), firstNode, operator, null);
    }

    public Node getOperatorCallNode(Node firstNode, String operator, Node secondNode) {
        this.checkExpression(firstNode);
        this.checkExpression(secondNode);
        return new CallNode(this.union(firstNode, secondNode), firstNode, operator, new ArrayNode(secondNode.getPosition()).add(secondNode));
    }

    public Node getMatchNode(Node firstNode, Node secondNode) {
        if (firstNode instanceof DRegexpNode || firstNode instanceof RegexpNode) {
            return new Match2Node(firstNode.getPosition(), firstNode, secondNode);
        }
        if (secondNode instanceof DRegexpNode || secondNode instanceof RegexpNode) {
            return new Match3Node(firstNode.getPosition(), secondNode, firstNode);
        }
        return this.getOperatorCallNode(firstNode, "=~", secondNode);
    }

    public Node getElementAssignmentNode(Node recv, Node idx) {
        this.checkExpression(recv);
        return new CallNode(recv.getPosition(), recv, "[]=", idx);
    }

    public Node getAttributeAssignmentNode(Node recv, String name) {
        this.checkExpression(recv);
        return new CallNode(recv.getPosition(), recv, name + "=", null);
    }

    public void backrefAssignError(Node node) {
        if (node instanceof NthRefNode) {
            throw new SyntaxException(node.getPosition(), "Can't set variable $" + ((NthRefNode)node).getMatchNumber() + '.');
        }
        if (node instanceof BackRefNode) {
            throw new SyntaxException(node.getPosition(), "Can't set variable $" + ((BackRefNode)node).getType() + '.');
        }
    }

    public Node node_assign(Node lhs, Node rhs) {
        if (lhs == null) {
            return null;
        }
        Node newNode = lhs;
        this.checkExpression(rhs);
        if (lhs instanceof AssignableNode) {
            ((AssignableNode)lhs).setValueNode(rhs);
        } else if (lhs instanceof CallNode) {
            CallNode lCallLHS = (CallNode)lhs;
            Node lArgs = lCallLHS.getArgsNode();
            if (lArgs == null) {
                lArgs = new ArrayNode(lhs.getPosition());
                newNode = new CallNode(lCallLHS.getPosition(), lCallLHS.getReceiverNode(), lCallLHS.getName(), lArgs);
            } else if (!(lArgs instanceof ListNode)) {
                lArgs = new ArrayNode(lhs.getPosition()).add(lArgs);
                newNode = new CallNode(lCallLHS.getPosition(), lCallLHS.getReceiverNode(), lCallLHS.getName(), lArgs);
            }
            ((ListNode)lArgs).add(rhs);
        }
        return newNode;
    }

    public Node ret_args(Node node, ISourcePosition position) {
        if (node != null) {
            if (node instanceof BlockPassNode) {
                throw new SyntaxException(position, "Dynamic constant assignment.");
            }
            if (node instanceof ArrayNode && ((ArrayNode)node).size() == 1) {
                node = (Node)((ArrayNode)node).iterator().next();
            } else if (node instanceof SplatNode) {
                node = new SValueNode(position, node);
            }
        }
        return node;
    }

    public void checkExpression(Node node) {
        if (!this.expressionVisitor.isExpression(node)) {
            this.warnings.warning(node.getPosition(), "void value expression");
        }
    }

    public void checkUselessStatement(Node node) {
        if (this.warnings.isVerbose()) {
            new UselessStatementVisitor(this.warnings).acceptNode(node);
        }
    }

    public void checkUselessStatements(BlockNode blockNode) {
        if (this.warnings.isVerbose()) {
            Node lastNode = blockNode.getLast();
            Iterator iterator = blockNode.iterator();
            while (iterator.hasNext()) {
                Node currentNode = (Node)iterator.next();
                if (lastNode == currentNode) continue;
                this.checkUselessStatement(currentNode);
            }
        }
    }

    private boolean checkAssignmentInCondition(Node node) {
        if (node instanceof MultipleAsgnNode) {
            throw new SyntaxException(node.getPosition(), "Multiple assignment in conditional.");
        }
        if (node instanceof LocalAsgnNode || node instanceof DAsgnNode || node instanceof GlobalAsgnNode || node instanceof InstAsgnNode) {
            Node valueNode = ((AssignableNode)node).getValueNode();
            if (valueNode instanceof ILiteralNode || valueNode instanceof NilNode || valueNode instanceof TrueNode || valueNode instanceof FalseNode) {
                this.warnings.warn(node.getPosition(), "Found '=' in conditional, should be '=='.");
            }
            return true;
        }
        return false;
    }

    private Node cond0(Node node) {
        this.checkAssignmentInCondition(node);
        if (node instanceof DRegexpNode) {
            ISourcePosition position = node.getPosition();
            return new Match2Node(position, node, new GlobalVarNode(position, "$_"));
        }
        if (node instanceof DotNode) {
            int slot = this.currentScope.getLocalScope().addVariable("");
            return new FlipNode(node.getPosition(), this.getFlipConditionNode(((DotNode)node).getBeginNode()), this.getFlipConditionNode(((DotNode)node).getEndNode()), ((DotNode)node).isExclusive(), slot);
        }
        if (node instanceof RegexpNode) {
            return new MatchNode(node.getPosition(), node);
        }
        if (node instanceof StrNode) {
            ISourcePosition position = node.getPosition();
            return new MatchNode(position, new RegexpNode(position, ((StrNode)node).getValue(), 0));
        }
        return node;
    }

    public Node getConditionNode(Node node) {
        if (node == null) {
            return null;
        }
        if (node instanceof NewlineNode) {
            return new NewlineNode(node.getPosition(), this.cond0(((NewlineNode)node).getNextNode()));
        }
        return this.cond0(node);
    }

    private Node getFlipConditionNode(Node node) {
        if ((node = this.getConditionNode(node)) instanceof NewlineNode) {
            return ((NewlineNode)node).getNextNode();
        }
        if (node instanceof FixnumNode) {
            return this.getOperatorCallNode(node, "==", new GlobalVarNode(node.getPosition(), "$."));
        }
        return node;
    }

    public AndNode newAndNode(Node left, Node right) {
        this.checkExpression(left);
        return new AndNode(this.union(left, right), left, right);
    }

    public OrNode newOrNode(Node left, Node right) {
        this.checkExpression(left);
        return new OrNode(this.union(left, right), left, right);
    }

    public Node getReturnArgsNode(Node node) {
        if (node instanceof ArrayNode && ((ArrayNode)node).size() == 1) {
            return (Node)((ListNode)node).iterator().next();
        }
        if (node instanceof BlockPassNode) {
            throw new SyntaxException(node.getPosition(), "Block argument should not be given.");
        }
        return node;
    }

    public Node new_call(Node receiver, Token name, Node args) {
        if (args != null) {
            if (args instanceof BlockPassNode) {
                Node argsNode = ((BlockPassNode)args).getArgsNode();
                ((BlockPassNode)args).setIterNode(new CallNode(this.union(receiver, name), receiver, (String)name.getValue(), argsNode));
                return args;
            }
            return new CallNode(this.union(receiver, args), receiver, (String)name.getValue(), args);
        }
        return new CallNode(this.union(receiver, name), receiver, (String)name.getValue(), args);
    }

    public Node new_fcall(Token operation, Node args) {
        String name = (String)operation.getValue();
        if (args != null) {
            if (args instanceof BlockPassNode) {
                ((BlockPassNode)args).setIterNode(new FCallNode(this.union(operation, args), name, ((BlockPassNode)args).getArgsNode()));
                return args;
            }
            return new FCallNode(this.union(operation, args), name, args);
        }
        return new FCallNode(operation.getPosition(), name, args);
    }

    public Node new_super(Node args, Token operation) {
        if (args != null && args instanceof BlockPassNode) {
            ((BlockPassNode)args).setIterNode(new SuperNode(this.union(operation, args), ((BlockPassNode)args).getArgsNode()));
            return args;
        }
        return new SuperNode(operation.getPosition(), args);
    }

    public void initTopLocalVariables() {
        DynamicScope scope = this.configuration.getScope();
        this.currentScope = scope.getStaticScope();
        this.result.setScope(scope);
    }

    public boolean isInSingle() {
        return this.inSingleton != 0;
    }

    public void setInSingle(int inSingle) {
        this.inSingleton = inSingle;
    }

    public boolean isInDef() {
        return this.inDefinition;
    }

    public void setInDef(boolean inDef) {
        this.inDefinition = inDef;
    }

    public int getInSingle() {
        return this.inSingleton;
    }

    public RubyParserResult getResult() {
        return this.result;
    }

    public void setResult(RubyParserResult result) {
        this.result = result;
    }

    public void setConfiguration(RubyParserConfiguration configuration) {
        this.configuration = configuration;
    }

    public void setWarnings(IRubyWarnings warnings) {
        this.warnings = warnings;
    }

    public Node literal_concat(Node head, Node tail) {
        if (head == null) {
            return tail;
        }
        if (tail == null) {
            return head;
        }
        if (head instanceof EvStrNode) {
            head = new DStrNode(head.getPosition()).add(head);
        }
        if (tail instanceof StrNode) {
            if (head instanceof StrNode) {
                return new StrNode(this.union(head, tail), ((StrNode)head).getValue() + ((StrNode)tail).getValue());
            }
            return ((ListNode)head).add(tail);
        }
        if (tail instanceof DStrNode) {
            if (head instanceof StrNode) {
                ((DStrNode)tail).childNodes().add(0, head);
                return tail;
            }
            return ((ListNode)head).addAll(tail);
        }
        if (head instanceof StrNode) {
            head.getPosition().adjustStartOffset(-1);
            head = new DStrNode(head.getPosition()).add(head);
        }
        return ((DStrNode)head).add(tail);
    }

    public Node newEvStrNode(ISourcePosition position, Node node) {
        Node head = node;
        while (node != null) {
            if (node instanceof StrNode || node instanceof DStrNode || node instanceof EvStrNode) {
                return node;
            }
            if (!(node instanceof NewlineNode)) break;
            node = ((NewlineNode)node).getNextNode();
        }
        return new EvStrNode(position, head);
    }

    public Node new_yield(ISourcePosition position, Node node) {
        boolean state = true;
        if (node != null) {
            if (node instanceof BlockPassNode) {
                throw new SyntaxException(node.getPosition(), "Block argument should not be given.");
            }
            if (node instanceof ArrayNode && ((ArrayNode)node).size() == 1) {
                node = (Node)((ArrayNode)node).iterator().next();
                state = false;
            }
            if (node != null && node instanceof SplatNode) {
                state = true;
            }
        } else {
            state = false;
        }
        return new YieldNode(position, node, state);
    }
}

