/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.InputStream;
import java.io.PrintStream;
import java.io.Reader;
import org.jruby.IRuby;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyException;
import org.jruby.RubyFixnum;
import org.jruby.RubyGlobal;
import org.jruby.RubyKernel;
import org.jruby.RubyNumeric;
import org.jruby.ast.Node;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.MainExitException;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.ValueAccessor;
import org.jruby.javasupport.JavaUtil;
import org.jruby.parser.ParserSupport;
import org.jruby.runtime.Constants;
import org.jruby.runtime.IAccessor;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.CommandlineParser;

public class Main {
    private CommandlineParser commandline;
    private boolean hasPrintedUsage = false;
    private InputStream in;
    private PrintStream out;
    private PrintStream err;

    public Main(InputStream in, PrintStream out, PrintStream err) {
        this.in = in;
        this.out = out;
        this.err = err;
    }

    public Main() {
        this(System.in, System.out, System.err);
    }

    public static void main(String[] args) {
        Main main = new Main();
        try {
            main.run(args);
        }
        catch (MainExitException mee) {
            main.err.println(mee.getMessage());
            if (mee.isUsageError()) {
                main.printUsage();
            }
            System.exit(mee.getStatus());
        }
    }

    public int run(String[] args) {
        this.commandline = new CommandlineParser(this, args);
        if (this.commandline.isShowVersion()) {
            this.showVersion();
        }
        if (!this.commandline.shouldRunInterpreter()) {
            return 0;
        }
        long now = -1L;
        if (this.commandline.isBenchmarking()) {
            now = System.currentTimeMillis();
        }
        int status = this.runInterpreter(this.commandline);
        if (this.commandline.isBenchmarking()) {
            this.out.println("Runtime: " + (System.currentTimeMillis() - now) + " ms");
        }
        return status;
    }

    private void showVersion() {
        this.out.print("ruby ");
        this.out.print(Constants.RUBY_VERSION);
        this.out.print(" (");
        this.out.print(Constants.COMPILE_DATE);
        this.out.print(") [");
        this.out.print("java");
        this.out.println("]");
    }

    public void printUsage() {
        if (!this.hasPrintedUsage) {
            this.out.println("Usage: jruby [switches] [--] [rubyfile.rb] [arguments]");
            this.out.println("    -e 'command'    one line of script. Several -e's allowed. Omit [programfile]");
            this.out.println("    -b              benchmark mode, times the script execution");
            this.out.println("    -Idirectory     specify $LOAD_PATH directory (may be used more than once)");
            this.out.println("    --              optional -- before rubyfile.rb for compatibility with ruby");
            this.out.println("    -d              set debugging flags (set $DEBUG to true)");
            this.out.println("    -v              print version number, then turn on verbose mode");
            this.out.println("    -O              run with ObjectSpace disabled (improves performance)");
            this.out.println("    -C              pre-compile scripts before running (EXPERIMENTAL)");
            this.hasPrintedUsage = true;
        }
    }

    private int runInterpreter(CommandlineParser commandline) {
        Reader reader = commandline.getScriptSource();
        String filename = commandline.displayedFileName();
        IRuby runtime = Ruby.newInstance(this.in, this.out, this.err, commandline.isObjectSpaceEnabled());
        runtime.setEncoding(commandline.getEncoding());
        try {
            this.runInterpreter(runtime, reader, filename);
            return 0;
        }
        catch (JumpException je) {
            if (je.getJumpType() == JumpException.JumpType.RaiseJump) {
                RubyException raisedException = ((RaiseException)je).getException();
                if (raisedException.isKindOf(runtime.getClass("SystemExit"))) {
                    RubyFixnum status = (RubyFixnum)raisedException.getInstanceVariable("status");
                    if (status != null) {
                        return RubyNumeric.fix2int(status);
                    }
                    return 0;
                }
                runtime.printError(raisedException);
                return 1;
            }
            if (je.getJumpType() == JumpException.JumpType.ThrowJump) {
                runtime.printError((RubyException)je.getTertiaryData());
                return 1;
            }
            throw je;
        }
        catch (MainExitException e) {
            if (e.isAborted()) {
                return e.getStatus();
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runInterpreter(IRuby runtime, Reader reader, String filename) {
        try {
            this.initializeRuntime(runtime, filename);
            Node parsedScript = this.getParsedScript(runtime, reader, filename);
            if (this.commandline.isCompilerEnabled()) {
                runtime.compileAndRun(parsedScript);
            } else {
                runtime.eval(parsedScript);
            }
        }
        finally {
            runtime.tearDown();
        }
    }

    private Node getParsedScript(IRuby runtime, Reader reader, String filename) {
        Node result = runtime.parse(reader, filename, runtime.getCurrentContext().getCurrentScope());
        if (this.commandline.isAssumePrinting()) {
            result = new ParserSupport().appendPrintToBlock(result);
        }
        if (this.commandline.isAssumeLoop()) {
            result = new ParserSupport().appendWhileLoopToBlock(result, this.commandline.isProcessLineEnds(), this.commandline.isSplit());
        }
        return result;
    }

    private void initializeRuntime(IRuby runtime, String filename) {
        RubyArray argumentArray = runtime.newArray(JavaUtil.convertJavaArrayToRuby(runtime, this.commandline.getScriptArguments()));
        runtime.setVerbose(runtime.newBoolean(this.commandline.isVerbose()));
        runtime.setDebug(runtime.newBoolean(this.commandline.isDebug()));
        this.defineGlobalVERBOSE(runtime);
        this.defineGlobalDEBUG(runtime);
        runtime.getObject().setConstant("$VERBOSE", this.commandline.isVerbose() ? runtime.getTrue() : runtime.getNil());
        runtime.defineGlobalConstant("ARGV", argumentArray);
        this.defineGlobal(runtime, "$-p", this.commandline.isAssumePrinting());
        this.defineGlobal(runtime, "$-n", this.commandline.isAssumeLoop());
        this.defineGlobal(runtime, "$-a", this.commandline.isSplit());
        this.defineGlobal(runtime, "$-l", this.commandline.isProcessLineEnds());
        runtime.getGlobalVariables().defineReadonly("$*", new ValueAccessor(argumentArray));
        runtime.getGlobalVariables().defineReadonly("$$", new ValueAccessor(runtime.newFixnum(runtime.hashCode())));
        runtime.defineVariable(new RubyGlobal.StringGlobalVariable(runtime, "$0", runtime.newString(filename)));
        runtime.getLoadService().init(this.commandline.loadPaths());
        for (String scriptName : this.commandline.requiredLibraries()) {
            RubyKernel.require(runtime.getTopSelf(), runtime.newString(scriptName));
        }
    }

    private void defineGlobalVERBOSE(final IRuby runtime) {
        runtime.getGlobalVariables().define("$VERBOSE", new IAccessor(){

            @Override
            public IRubyObject getValue() {
                return runtime.getVerbose();
            }

            @Override
            public IRubyObject setValue(IRubyObject newValue) {
                if (newValue.isNil()) {
                    runtime.setVerbose(newValue);
                } else {
                    runtime.setVerbose(runtime.newBoolean(newValue != runtime.getFalse()));
                }
                return newValue;
            }
        });
    }

    private void defineGlobalDEBUG(final IRuby runtime) {
        IAccessor d = new IAccessor(){

            @Override
            public IRubyObject getValue() {
                return runtime.getDebug();
            }

            @Override
            public IRubyObject setValue(IRubyObject newValue) {
                if (newValue.isNil()) {
                    runtime.setDebug(newValue);
                } else {
                    runtime.setDebug(runtime.newBoolean(newValue != runtime.getFalse()));
                }
                return newValue;
            }
        };
        runtime.getGlobalVariables().define("$DEBUG", d);
        runtime.getGlobalVariables().define("$-d", d);
    }

    private void defineGlobal(IRuby runtime, String name, boolean value) {
        runtime.getGlobalVariables().defineReadonly(name, new ValueAccessor(value ? runtime.getTrue() : runtime.getNil()));
    }
}

