/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.IRuby;
import org.jruby.MetaClass;
import org.jruby.RubyClass;
import org.jruby.RubyMethod;
import org.jruby.RubyModule;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ICallable;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyUnboundMethod
extends RubyMethod {
    protected RubyUnboundMethod(IRuby runtime) {
        super(runtime, runtime.getClass("UnboundMethod"));
    }

    public static RubyUnboundMethod newUnboundMethod(RubyModule implementationModule, String methodName, RubyModule originModule, String originName, ICallable method) {
        RubyUnboundMethod newMethod = new RubyUnboundMethod(implementationModule.getRuntime());
        newMethod.implementationModule = implementationModule;
        newMethod.methodName = methodName;
        newMethod.originModule = originModule;
        newMethod.originName = originName;
        newMethod.method = method;
        return newMethod;
    }

    public static RubyClass defineUnboundMethodClass(IRuby runtime) {
        RubyClass newClass = runtime.defineClass("UnboundMethod", runtime.getClass("Method"));
        CallbackFactory callbackFactory = runtime.callbackFactory(RubyUnboundMethod.class);
        newClass.defineMethod("[]", callbackFactory.getOptMethod("call"));
        newClass.defineMethod("bind", callbackFactory.getMethod("bind", IRubyObject.class));
        newClass.defineMethod("call", callbackFactory.getOptMethod("call"));
        newClass.defineMethod("to_proc", callbackFactory.getMethod("to_proc"));
        newClass.defineMethod("unbind", callbackFactory.getMethod("unbind"));
        return newClass;
    }

    @Override
    public IRubyObject call(IRubyObject[] args) {
        throw this.getRuntime().newTypeError("you cannot call unbound method; bind first");
    }

    @Override
    public RubyUnboundMethod unbind() {
        return this;
    }

    public RubyMethod bind(IRubyObject aReceiver) {
        RubyClass receiverClass = aReceiver.getMetaClass();
        if (!aReceiver.isKindOf(this.originModule)) {
            if (this.originModule instanceof MetaClass) {
                throw this.getRuntime().newTypeError("singleton method called for a different object");
            }
            if (receiverClass instanceof MetaClass && receiverClass.getMethods().containsKey(this.originName)) {
                throw this.getRuntime().newTypeError("method `" + this.originName + "' overridden");
            }
            if (!(!this.originModule.isModule() ? aReceiver.getType() == this.originModule : aReceiver.isKindOf(this.originModule))) {
                throw this.getRuntime().newTypeError("bind argument must be an instance of " + this.originModule.getName());
            }
        }
        return RubyMethod.newMethod(this.implementationModule, this.methodName, receiverClass, this.originName, this.method, aReceiver);
    }
}

