/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.IRuby;
import org.jruby.RubyObject;
import org.jruby.runtime.Arity;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callback.Callback;

public final class TopSelfFactory {
    private TopSelfFactory() {
    }

    public static IRubyObject createTopSelf(final IRuby runtime) {
        RubyObject topSelf = new RubyObject(runtime, runtime.getObject());
        topSelf.defineSingletonMethod("to_s", new Callback(){

            @Override
            public IRubyObject execute(IRubyObject recv, IRubyObject[] args) {
                return runtime.newString("main");
            }

            @Override
            public Arity getArity() {
                return Arity.noArguments();
            }
        });
        topSelf.defineSingletonMethod("include", new Callback(){

            @Override
            public IRubyObject execute(IRubyObject recv, IRubyObject[] args) {
                runtime.secure(4);
                return runtime.getObject().include(args);
            }

            @Override
            public Arity getArity() {
                return Arity.optional();
            }
        });
        topSelf.defineSingletonMethod("public", new Callback(){

            @Override
            public IRubyObject execute(IRubyObject recv, IRubyObject[] args) {
                return runtime.getObject().rbPublic(args);
            }

            @Override
            public Arity getArity() {
                return Arity.optional();
            }
        });
        topSelf.defineSingletonMethod("private", new Callback(){

            @Override
            public IRubyObject execute(IRubyObject recv, IRubyObject[] args) {
                return runtime.getObject().rbPrivate(args);
            }

            @Override
            public Arity getArity() {
                return Arity.optional();
            }
        });
        return topSelf;
    }
}

