/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import org.jruby.RubyModule;
import org.jruby.ast.CallNode;
import org.jruby.ast.Node;
import org.jruby.ast.types.IArityNode;
import org.jruby.evaluator.EvaluationState;
import org.jruby.internal.runtime.methods.AbstractCallable;
import org.jruby.runtime.Arity;
import org.jruby.runtime.ICallable;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class EvaluateCallable
extends AbstractCallable {
    private final Node node;
    private final Arity arity;

    private EvaluateCallable(Node node, Visibility visibility, Arity arity) {
        super(null, visibility);
        this.node = node;
        this.arity = arity;
    }

    public EvaluateCallable(Node node, Node vars) {
        this(node, null, EvaluateCallable.procArityOf(vars));
    }

    @Override
    public void preMethod(ThreadContext context, RubyModule implementationClass, IRubyObject recv, String name, IRubyObject[] args, boolean noSuper) {
    }

    @Override
    public void postMethod(ThreadContext context) {
    }

    @Override
    public IRubyObject internalCall(ThreadContext context, IRubyObject receiver, RubyModule lastClass, String name, IRubyObject[] args, boolean noSuper) {
        return EvaluationState.eval(context, this.node, receiver);
    }

    public Node getNode() {
        return this.node;
    }

    @Override
    public Arity getArity() {
        return this.arity;
    }

    private static Arity procArityOf(Node node) {
        if (node == null) {
            return Arity.optional();
        }
        if (node instanceof IArityNode) {
            return ((IArityNode)((Object)node)).getArity();
        }
        if (node instanceof CallNode) {
            return Arity.singleArgument();
        }
        throw new Error("unexpected type " + node.getClass() + " at " + node.getPosition());
    }

    @Override
    public ICallable dup() {
        return new EvaluateCallable(this.node, this.getVisibility(), this.arity);
    }
}

