/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import org.jruby.IRuby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.javasupport.JavaArray;
import org.jruby.javasupport.JavaClass;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.builtin.IRubyObject;

public class JavaObject
extends RubyObject {
    private static Object NULL_LOCK = new Object();
    private final Object value;

    protected JavaObject(IRuby runtime, RubyClass rubyClass, Object value) {
        super(runtime, rubyClass);
        this.value = value;
    }

    protected JavaObject(IRuby runtime, Object value) {
        this(runtime, runtime.getModule("Java").getClass("JavaObject"), value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JavaObject wrap(IRuby runtime, Object value) {
        Object lock;
        Object object = lock = value == null ? NULL_LOCK : value;
        synchronized (object) {
            JavaObject wrapper = runtime.getJavaSupport().getJavaObjectFromCache(value);
            if (wrapper == null) {
                wrapper = value == null ? new JavaObject(runtime, value) : (value.getClass().isArray() ? new JavaArray(runtime, value) : (value.getClass().equals(Class.class) ? JavaClass.get(runtime, (Class)value) : new JavaObject(runtime, value)));
                runtime.getJavaSupport().putJavaObjectIntoCache(wrapper);
            }
            return wrapper;
        }
    }

    @Override
    public Class getJavaClass() {
        return this.value != null ? this.value.getClass() : Void.TYPE;
    }

    public Object getValue() {
        return this.value;
    }

    public static RubyClass createJavaObjectClass(IRuby runtime, RubyModule javaModule) {
        RubyClass result = javaModule.defineClassUnder("JavaObject", runtime.getObject());
        JavaObject.registerRubyMethods(runtime, result);
        result.getMetaClass().undefineMethod("new");
        return result;
    }

    protected static void registerRubyMethods(IRuby runtime, RubyClass result) {
        CallbackFactory callbackFactory = runtime.callbackFactory(JavaObject.class);
        result.defineMethod("to_s", callbackFactory.getMethod("to_s"));
        result.defineMethod("==", callbackFactory.getMethod("equal", IRubyObject.class));
        result.defineMethod("eql?", callbackFactory.getMethod("equal", IRubyObject.class));
        result.defineMethod("equal?", callbackFactory.getMethod("same", IRubyObject.class));
        result.defineMethod("hash", callbackFactory.getMethod("hash"));
        result.defineMethod("java_type", callbackFactory.getMethod("java_type"));
        result.defineMethod("java_class", callbackFactory.getMethod("java_class"));
        result.defineMethod("java_proxy?", callbackFactory.getMethod("is_java_proxy"));
        result.defineMethod("length", callbackFactory.getMethod("length"));
        result.defineMethod("[]", callbackFactory.getMethod("aref", IRubyObject.class));
        result.defineMethod("[]=", callbackFactory.getMethod("aset", IRubyObject.class, IRubyObject.class));
    }

    @Override
    public RubyFixnum hash() {
        return this.getRuntime().newFixnum(this.value == null ? 0L : (long)this.value.hashCode());
    }

    @Override
    public IRubyObject to_s() {
        return this.getRuntime().newString(this.value == null ? "null" : this.value.toString());
    }

    @Override
    public IRubyObject equal(IRubyObject other) {
        if (!(other instanceof JavaObject) && !((other = other.getInstanceVariable("@java_object")) instanceof JavaObject)) {
            return this.getRuntime().getFalse();
        }
        if (this.getValue() == null && ((JavaObject)other).getValue() == null) {
            return this.getRuntime().getTrue();
        }
        boolean isEqual = this.getValue().equals(((JavaObject)other).getValue());
        return isEqual ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    @Override
    public IRubyObject same(IRubyObject other) {
        if (!(other instanceof JavaObject) && !((other = other.getInstanceVariable("@java_object")) instanceof JavaObject)) {
            return this.getRuntime().getFalse();
        }
        if (this.getValue() == null && ((JavaObject)other).getValue() == null) {
            return this.getRuntime().getTrue();
        }
        boolean isSame = this.getValue() == ((JavaObject)other).getValue();
        return isSame ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    public RubyString java_type() {
        return this.getRuntime().newString(this.getJavaClass().getName());
    }

    public IRubyObject java_class() {
        return JavaClass.get(this.getRuntime(), this.getJavaClass());
    }

    public RubyFixnum length() {
        throw this.getRuntime().newTypeError("not a java array");
    }

    public IRubyObject aref(IRubyObject index) {
        throw this.getRuntime().newTypeError("not a java array");
    }

    public IRubyObject aset(IRubyObject index, IRubyObject someValue) {
        throw this.getRuntime().newTypeError("not a java array");
    }

    public IRubyObject is_java_proxy() {
        return this.getRuntime().getTrue();
    }
}

