/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport.bsf;

import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import org.apache.bsf.BSFDeclaredBean;
import org.apache.bsf.BSFEngine;
import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;
import org.apache.bsf.util.BSFEngineImpl;
import org.apache.bsf.util.BSFFunctions;
import org.jruby.IRuby;
import org.jruby.ast.Node;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.RaiseException;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.javasupport.JavaObject;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.GlobalVariable;
import org.jruby.runtime.IAccessor;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class JRubyEngine
extends BSFEngineImpl {
    private IRuby runtime;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object apply(String file, int line, int col, Object funcBody, Vector paramNames, Vector args) {
        ThreadContext threadContext = this.runtime.getCurrentContext();
        try {
            String[] names = new String[paramNames.size()];
            paramNames.toArray(names);
            threadContext.preBsfApply(names);
            DynamicScope scope = threadContext.getCurrentScope();
            int size = args.size();
            for (int i = 0; i < size; ++i) {
                scope.setValue(i, JavaEmbedUtils.javaToRuby(this.runtime, args.get(i)), 0);
            }
            Node node = this.runtime.parse(file, funcBody.toString(), null);
            Object object = JavaEmbedUtils.rubyToJava(this.runtime, this.runtime.getTopSelf().eval(node), Object.class);
            return object;
        }
        finally {
            threadContext.postBsfApply();
        }
    }

    public Object eval(String file, int line, int col, Object expr) throws BSFException {
        try {
            IRubyObject result = this.runtime.evalScript(expr.toString());
            return JavaEmbedUtils.rubyToJava(this.runtime, result, Object.class);
        }
        catch (Exception excptn) {
            throw new BSFException(BSFException.REASON_EXECUTION_ERROR, "Exception", (Throwable)excptn);
        }
    }

    public void exec(String file, int line, int col, Object expr) throws BSFException {
        try {
            this.runtime.evalScript(expr.toString());
        }
        catch (Exception excptn) {
            throw new BSFException(BSFException.REASON_EXECUTION_ERROR, "Exception", (Throwable)excptn);
        }
    }

    public Object call(Object recv, String method, Object[] args) throws BSFException {
        try {
            return JavaEmbedUtils.invokeMethod(this.runtime, recv, method, args, Object.class);
        }
        catch (Exception excptn) {
            JRubyEngine.printException(this.runtime, excptn);
            throw new BSFException(BSFException.REASON_EXECUTION_ERROR, excptn.getMessage(), (Throwable)excptn);
        }
    }

    public void initialize(BSFManager manager, String language, Vector someDeclaredBeans) throws BSFException {
        super.initialize(manager, language, someDeclaredBeans);
        this.runtime = JavaEmbedUtils.initialize(this.getClassPath(manager));
        int size = someDeclaredBeans.size();
        for (int i = 0; i < size; ++i) {
            BSFDeclaredBean bean = (BSFDeclaredBean)someDeclaredBeans.elementAt(i);
            this.runtime.getGlobalVariables().define(GlobalVariable.variableName(bean.name), new BeanGlobalVariable(this.runtime, bean));
        }
        this.runtime.getGlobalVariables().defineReadonly("$bsf", new FunctionsGlobalVariable(this.runtime, new BSFFunctions(manager, (BSFEngine)this)));
    }

    private List getClassPath(BSFManager manager) {
        return Arrays.asList(manager.getClassPath().split(System.getProperty("path.separator")));
    }

    public void declareBean(BSFDeclaredBean bean) throws BSFException {
        this.runtime.getGlobalVariables().define(GlobalVariable.variableName(bean.name), new BeanGlobalVariable(this.runtime, bean));
    }

    public void undeclareBean(BSFDeclaredBean bean) throws BSFException {
        this.runtime.getGlobalVariables().set(GlobalVariable.variableName(bean.name), this.runtime.getNil());
    }

    public void handleException(BSFException bsfExcptn) {
        JRubyEngine.printException(this.runtime, (Exception)bsfExcptn.getTargetException());
    }

    private static void printException(IRuby runtime, Exception exception) {
        if (exception instanceof JumpException) {
            JumpException je = (JumpException)exception;
            if (je.getJumpType() == JumpException.JumpType.RaiseJump) {
                runtime.printError(((RaiseException)je).getException());
            } else if (je.getJumpType() == JumpException.JumpType.ThrowJump) {
                runtime.getErrorStream().println("internal error: throw jump caught");
            } else if (je.getJumpType() == JumpException.JumpType.BreakJump) {
                runtime.getErrorStream().println("break without block.");
            } else if (je.getJumpType() == JumpException.JumpType.ReturnJump) {
                runtime.getErrorStream().println("return without block.");
            }
        }
    }

    public void terminate() {
        JavaEmbedUtils.terminate(this.runtime);
        this.runtime = null;
        super.terminate();
    }

    private static class FunctionsGlobalVariable
    implements IAccessor {
        private IRuby runtime;
        private BSFFunctions functions;

        public FunctionsGlobalVariable(IRuby runtime, BSFFunctions functions) {
            this.runtime = runtime;
            this.functions = functions;
        }

        @Override
        public IRubyObject getValue() {
            IRubyObject result = JavaUtil.convertJavaToRuby(this.runtime, this.functions, BSFFunctions.class);
            if (result instanceof JavaObject) {
                return this.runtime.getModule("JavaUtilities").callMethod(this.runtime.getCurrentContext(), "wrap", result);
            }
            return result;
        }

        @Override
        public IRubyObject setValue(IRubyObject value) {
            return value;
        }
    }

    private static class BeanGlobalVariable
    implements IAccessor {
        private IRuby runtime;
        private BSFDeclaredBean bean;

        public BeanGlobalVariable(IRuby runtime, BSFDeclaredBean bean) {
            this.runtime = runtime;
            this.bean = bean;
        }

        @Override
        public IRubyObject getValue() {
            IRubyObject result = JavaUtil.convertJavaToRuby(this.runtime, this.bean.bean, this.bean.type);
            if (result instanceof JavaObject) {
                return this.runtime.getModule("JavaUtilities").callMethod(this.runtime.getCurrentContext(), "wrap", result);
            }
            return result;
        }

        @Override
        public IRubyObject setValue(IRubyObject value) {
            this.bean.bean = JavaUtil.convertArgument(Java.ruby_to_java(this.runtime.getObject(), value), this.bean.type);
            return value;
        }
    }
}

