/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.libraries;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import org.jruby.IRuby;
import org.jruby.RubyArray;
import org.jruby.RubyFixnum;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.libraries.RubySocket;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.builtin.meta.AbstractMetaClass;
import org.jruby.runtime.builtin.meta.BasicSocketMetaClass;

public class SocketMetaClass
extends BasicSocketMetaClass {
    public RubySocket.SocketMethod gethostname = new RubySocket.SocketMethod(this, Arity.singleArgument(), Visibility.PUBLIC){

        @Override
        public IRubyObject invoke(RubySocket self, IRubyObject[] args) {
            return self.getRuntime().getNil();
        }
    };

    public SocketMetaClass(IRuby runtime) {
        super("Socket", RubySocket.class, runtime.getClass("BasicSocket"));
    }

    public RubyString gethostname() {
        try {
            String hostName = InetAddress.getLocalHost().getHostName();
            return this.getRuntime().newString(hostName);
        }
        catch (UnknownHostException e) {
            return this.getRuntime().newString("");
        }
    }

    public RubyArray gethostbyname(IRubyObject hostname) {
        try {
            RubyString name = (RubyString)hostname;
            InetAddress inetAddress = InetAddress.getByName(name.toString());
            ArrayList<RubyObject> parts = new ArrayList<RubyObject>();
            parts.add(this.getRuntime().newString(inetAddress.getCanonicalHostName()));
            parts.add(RubyArray.newArray(this.getRuntime()));
            parts.add(new RubyFixnum(this.getRuntime(), 2L));
            parts.add(this.getRuntime().newString(RubyString.bytesToString(inetAddress.getAddress())));
            return RubyArray.newArray(this.getRuntime(), parts);
        }
        catch (UnknownHostException e) {
            return RubyArray.newArray(this.getRuntime());
        }
    }

    @Override
    protected AbstractMetaClass.Meta getMeta() {
        return new SocketMeta();
    }

    protected class SocketMeta
    extends AbstractMetaClass.Meta {
        protected SocketMeta() {
            super(SocketMetaClass.this);
        }

        @Override
        protected void initializeClass() {
            SocketMetaClass.this.defineSingletonMethod("gethostname", Arity.noArguments());
            SocketMetaClass.this.defineSingletonMethod("gethostbyname", Arity.singleArgument());
        }
    }
}

