/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.parser;

import java.util.ArrayList;
import java.util.List;
import org.jruby.ast.BlockNode;
import org.jruby.ast.CommentNode;
import org.jruby.ast.Node;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;

public class RubyParserResult {
    private final List beginNodes = new ArrayList();
    private final List endNodes = new ArrayList();
    private Node ast;
    private boolean endSeen;
    private List commentNodes = new ArrayList();
    private DynamicScope scope;

    public List getCommentNodes() {
        return this.commentNodes;
    }

    public Node getAST() {
        return this.ast;
    }

    public DynamicScope getScope() {
        return this.scope;
    }

    public void setScope(DynamicScope scope) {
        this.scope = scope;
    }

    public void setAST(Node ast) {
        this.ast = ast;
    }

    public void addComment(CommentNode node) {
        this.commentNodes.add(node);
    }

    public void addBeginNode(StaticScope scope, Node node) {
        this.beginNodes.add(node);
    }

    public void addEndNode(Node node) {
        this.endNodes.add(node);
    }

    public void addAppendBeginAndEndNodes() {
        int i;
        BlockNode n;
        if (this.beginNodes.isEmpty() && this.endNodes.isEmpty()) {
            return;
        }
        if (this.getAST() != null) {
            n = new BlockNode(this.getAST().getPosition());
        } else {
            ISourcePosition p = !this.beginNodes.isEmpty() ? ((Node)this.beginNodes.get(0)).getPosition() : ((Node)this.endNodes.get(this.endNodes.size() - 1)).getPosition();
            n = new BlockNode(p);
        }
        for (i = 0; i < this.beginNodes.size(); ++i) {
            n.add((Node)this.beginNodes.get(i));
        }
        if (this.getAST() != null) {
            n.add(this.getAST());
        }
        for (i = this.endNodes.size() - 1; i >= 0; --i) {
            n.add((Node)this.endNodes.get(i));
        }
        this.setAST(n);
    }

    public boolean isEndSeen() {
        return this.endSeen;
    }

    public void setEndSeen(boolean endSeen) {
        this.endSeen = endSeen;
    }
}

