/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.marshal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jruby.IRuby;
import org.jruby.RubySymbol;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.UnmarshalStream;

public class UnmarshalCache {
    private final IRuby runtime;
    private List links = new ArrayList();
    private List symbols = new ArrayList();

    public UnmarshalCache(IRuby runtime) {
        this.runtime = runtime;
    }

    public void register(IRubyObject value) {
        this.selectCache(value).add(value);
    }

    private List selectCache(IRubyObject value) {
        return value instanceof RubySymbol ? this.symbols : this.links;
    }

    public boolean isLinkType(int c) {
        return c == 59 || c == 64;
    }

    public IRubyObject readLink(UnmarshalStream input, int type) throws IOException {
        if (type == 64) {
            return this.linkedByIndex(input.unmarshalInt());
        }
        assert (type == 59);
        return this.symbolByIndex(input.unmarshalInt());
    }

    private IRubyObject linkedByIndex(int index) {
        try {
            return (IRubyObject)this.links.get(index);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.runtime.newArgumentError("dump format error (unlinked, index: " + index + ")");
        }
    }

    private RubySymbol symbolByIndex(int index) {
        try {
            return (RubySymbol)this.symbols.get(index);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.runtime.newTypeError("bad symbol");
        }
    }
}

