/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.ablaf.ast.IAstDecoder;
import org.jruby.IRuby;
import org.jruby.ast.Node;
import org.jruby.ast.util.RubyAstMarshal;
import org.jruby.runtime.load.Library;

public class BuiltinScript
implements Library {
    private final String name;

    public BuiltinScript(String name) {
        this.name = name;
    }

    @Override
    public void load(IRuby runtime) throws IOException {
        runtime.loadNode("jruby builtin", this.getNode(runtime), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node getNode(IRuby runtime) throws IOException {
        String resourceName = "/builtin/" + this.name + ".rb.ast.ser";
        InputStream in = this.getClass().getResourceAsStream(resourceName);
        if (in == null) {
            throw runtime.newIOError("Resource not found: " + resourceName);
        }
        in = new BufferedInputStream(in);
        IAstDecoder decoder = RubyAstMarshal.getInstance().openDecoder(in);
        try {
            Node node = decoder.readNode();
            return node;
        }
        finally {
            decoder.close();
        }
    }
}

