/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.IRuby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.runtime.Block;
import org.jruby.runtime.Frame;
import org.jruby.runtime.Iter;
import org.jruby.runtime.ThreadContext;

public class RubyBinding
extends RubyObject {
    private Block block = null;
    private RubyModule wrapper = null;

    public RubyBinding(IRuby runtime, RubyClass rubyClass, Block block, RubyModule wrapper) {
        super(runtime, rubyClass);
        this.block = block;
        this.wrapper = wrapper;
    }

    public Block getBlock() {
        return this.block;
    }

    public RubyModule getWrapper() {
        return this.wrapper;
    }

    public static RubyBinding newBinding(IRuby runtime, Block block) {
        return new RubyBinding(runtime, runtime.getClass("Binding"), block, block.getKlass());
    }

    public static RubyBinding newBinding(IRuby runtime) {
        ThreadContext context = runtime.getCurrentContext();
        RubyModule wrapper = context.getWrapper();
        Iter iter = Iter.ITER_NOT;
        Frame frame = context.getCurrentFrame();
        if (context.getPreviousFrame() != null) {
            iter = context.getPreviousFrameIter();
        }
        Block bindingBlock = Block.createBinding(wrapper, iter, frame, context.getCurrentScope());
        RubyBinding newBinding = new RubyBinding(runtime, runtime.getClass("Binding"), bindingBlock, context.getRubyClass());
        return newBinding;
    }
}

