/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.IRuby;
import org.jruby.RubyBoolean;
import org.jruby.RubyException;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyComparable {
    public static RubyModule createComparable(IRuby runtime) {
        RubyModule comparableModule = runtime.defineModule("Comparable");
        CallbackFactory callbackFactory = runtime.callbackFactory(RubyComparable.class);
        comparableModule.defineMethod("==", callbackFactory.getSingletonMethod("equal", IRubyObject.class));
        comparableModule.defineMethod(">", callbackFactory.getSingletonMethod("op_gt", IRubyObject.class));
        comparableModule.defineMethod(">=", callbackFactory.getSingletonMethod("op_ge", IRubyObject.class));
        comparableModule.defineMethod("<", callbackFactory.getSingletonMethod("op_lt", IRubyObject.class));
        comparableModule.defineMethod("<=", callbackFactory.getSingletonMethod("op_le", IRubyObject.class));
        comparableModule.defineMethod("between?", callbackFactory.getSingletonMethod("between_p", IRubyObject.class, IRubyObject.class));
        return comparableModule;
    }

    public static IRubyObject equal(IRubyObject recv, IRubyObject other) {
        try {
            if (recv == other) {
                return recv.getRuntime().getTrue();
            }
            IRubyObject result = recv.callMethod(recv.getRuntime().getCurrentContext(), "<=>", other);
            if (result.isNil()) {
                return result;
            }
            return RubyNumeric.fix2int(result) != 0 ? recv.getRuntime().getFalse() : recv.getRuntime().getTrue();
        }
        catch (RaiseException e) {
            RubyException raisedException = e.getException();
            if (raisedException.isKindOf(recv.getRuntime().getClass("NoMethodError"))) {
                return recv.getRuntime().getFalse();
            }
            if (raisedException.isKindOf(recv.getRuntime().getClass("NameError"))) {
                return recv.getRuntime().getFalse();
            }
            throw e;
        }
    }

    private static void cmperr(IRubyObject recv, IRubyObject other) {
        String message = "comparison of " + recv.getType() + " with " + other.getType() + " failed";
        throw recv.getRuntime().newArgumentError(message);
    }

    public static RubyBoolean op_gt(IRubyObject recv, IRubyObject other) {
        IRubyObject tmp = recv.callMethod(recv.getRuntime().getCurrentContext(), "<=>", other);
        if (tmp.isNil()) {
            RubyComparable.cmperr(recv, other);
        }
        return RubyNumeric.fix2int(tmp) > 0 ? recv.getRuntime().getTrue() : recv.getRuntime().getFalse();
    }

    public static RubyBoolean op_ge(IRubyObject recv, IRubyObject other) {
        IRubyObject tmp = recv.callMethod(recv.getRuntime().getCurrentContext(), "<=>", other);
        if (tmp.isNil()) {
            RubyComparable.cmperr(recv, other);
        }
        return RubyNumeric.fix2int(tmp) >= 0 ? recv.getRuntime().getTrue() : recv.getRuntime().getFalse();
    }

    public static RubyBoolean op_lt(IRubyObject recv, IRubyObject other) {
        IRubyObject tmp = recv.callMethod(recv.getRuntime().getCurrentContext(), "<=>", other);
        if (tmp.isNil()) {
            RubyComparable.cmperr(recv, other);
        }
        return RubyNumeric.fix2int(tmp) < 0 ? recv.getRuntime().getTrue() : recv.getRuntime().getFalse();
    }

    public static RubyBoolean op_le(IRubyObject recv, IRubyObject other) {
        IRubyObject tmp = recv.callMethod(recv.getRuntime().getCurrentContext(), "<=>", other);
        if (tmp.isNil()) {
            RubyComparable.cmperr(recv, other);
        }
        return RubyNumeric.fix2int(tmp) <= 0 ? recv.getRuntime().getTrue() : recv.getRuntime().getFalse();
    }

    public static RubyBoolean between_p(IRubyObject recv, IRubyObject first, IRubyObject second) {
        return recv.getRuntime().newBoolean(RubyComparable.op_lt(recv, first).isFalse() && RubyComparable.op_gt(recv, second).isFalse());
    }
}

