/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.PrintStream;
import org.jruby.IRuby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyException
extends RubyObject {
    private RubyArray backtrace;
    public IRubyObject message;
    public static final int TRACE_HEAD = 8;
    public static final int TRACE_TAIL = 4;
    public static final int TRACE_MAX = 18;

    protected RubyException(IRuby runtime, RubyClass rubyClass) {
        this(runtime, rubyClass, null);
    }

    public RubyException(IRuby runtime, RubyClass rubyClass, String message) {
        super(runtime, rubyClass);
        this.message = message == null ? runtime.getNil() : runtime.newString(message);
    }

    public static RubyClass createExceptionClass(IRuby runtime) {
        RubyClass exceptionClass = runtime.defineClass("Exception", runtime.getObject());
        CallbackFactory callbackFactory = runtime.callbackFactory(RubyException.class);
        exceptionClass.defineSingletonMethod("new", callbackFactory.getOptSingletonMethod("newInstance"));
        exceptionClass.defineSingletonMethod("exception", callbackFactory.getOptSingletonMethod("newInstance"));
        exceptionClass.defineMethod("initialize", callbackFactory.getOptMethod("initialize"));
        exceptionClass.defineMethod("exception", callbackFactory.getOptMethod("exception"));
        exceptionClass.defineMethod("to_s", callbackFactory.getMethod("to_s"));
        exceptionClass.defineMethod("to_str", callbackFactory.getMethod("to_s"));
        exceptionClass.defineMethod("message", callbackFactory.getMethod("to_s"));
        exceptionClass.defineMethod("inspect", callbackFactory.getMethod("inspect"));
        exceptionClass.defineMethod("backtrace", callbackFactory.getMethod("backtrace"));
        exceptionClass.defineMethod("set_backtrace", callbackFactory.getMethod("set_backtrace", IRubyObject.class));
        return exceptionClass;
    }

    public static RubyException newException(IRuby runtime, RubyClass excptnClass, String msg) {
        return new RubyException(runtime, excptnClass, msg);
    }

    public static RubyException newInstance(IRubyObject recv, IRubyObject[] args) {
        RubyException newException = new RubyException(recv.getRuntime(), (RubyClass)recv);
        newException.callInit(args);
        return newException;
    }

    @Override
    public IRubyObject initialize(IRubyObject[] args) {
        if (args.length > 0) {
            this.message = args[0];
        }
        return this;
    }

    public IRubyObject backtrace() {
        return this.backtrace == null ? this.getRuntime().getNil() : this.backtrace;
    }

    public IRubyObject set_backtrace(IRubyObject obj) {
        if (obj.isNil()) {
            this.backtrace = null;
        } else {
            if (!this.isArrayOfStrings(obj)) {
                throw this.getRuntime().newTypeError("backtrace must be Array of String");
            }
            this.backtrace = (RubyArray)obj;
        }
        return this.backtrace();
    }

    public RubyException exception(IRubyObject[] args) {
        switch (args.length) {
            case 0: {
                return this;
            }
            case 1: {
                if (args[0] == this) {
                    return this;
                }
                RubyException ret = (RubyException)this.rbClone();
                ret.initialize(args);
                return ret;
            }
        }
        throw this.getRuntime().newArgumentError("Wrong argument count");
    }

    @Override
    public IRubyObject to_s() {
        if (this.message.isNil()) {
            return this.getRuntime().newString(this.getMetaClass().getName());
        }
        this.message.setTaint(this.isTaint());
        return (RubyString)this.message.callMethod(this.getRuntime().getCurrentContext(), "to_s");
    }

    @Override
    public IRubyObject inspect() {
        RubyClass rubyClass = this.getMetaClass();
        RubyString exception = RubyString.stringValue(this);
        if (exception.getValue().length() == 0) {
            return this.getRuntime().newString(rubyClass.getName());
        }
        StringBuffer sb = new StringBuffer("#<");
        sb.append(rubyClass.getName()).append(": ").append(exception.getValue()).append(">");
        return this.getRuntime().newString(sb.toString());
    }

    public void printBacktrace(PrintStream errorStream) {
        IRubyObject backtrace = this.callMethod(this.getRuntime().getCurrentContext(), "backtrace");
        if (!backtrace.isNil() && backtrace instanceof RubyArray) {
            IRubyObject[] elements = backtrace.convertToArray().toJavaArray();
            for (int i = 1; i < elements.length; ++i) {
                IRubyObject stackTraceLine = elements[i];
                if (stackTraceLine instanceof RubyString) {
                    this.printStackTraceLine(errorStream, stackTraceLine);
                }
                if (i != 8 || elements.length <= 18) continue;
                int hiddenLevels = elements.length - 8 - 4;
                errorStream.print("\t ... " + hiddenLevels + " levels...\n");
                i = elements.length - 4;
            }
        }
    }

    private void printStackTraceLine(PrintStream errorStream, IRubyObject stackTraceLine) {
        errorStream.print("\tfrom " + stackTraceLine + '\n');
    }

    private boolean isArrayOfStrings(IRubyObject backtrace) {
        if (!(backtrace instanceof RubyArray)) {
            return false;
        }
        IRubyObject[] elements = ((RubyArray)backtrace).toJavaArray();
        for (int i = 0; i < elements.length; ++i) {
            if (elements[i] instanceof RubyString) continue;
            return false;
        }
        return true;
    }

    @Override
    protected IRubyObject doClone() {
        RubyException newObject = new RubyException(this.getRuntime(), this.getMetaClass().getRealClass());
        if (newObject.getType() != this.getMetaClass().getRealClass()) {
            throw this.getRuntime().newTypeError("wrong instance allocation");
        }
        return newObject;
    }
}

