/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.IRuby;
import org.jruby.RubyArray;
import org.jruby.RubyFloat;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyMath {
    public static RubyModule createMathModule(IRuby runtime) {
        RubyModule result = runtime.defineModule("Math");
        CallbackFactory callbackFactory = runtime.callbackFactory(RubyMath.class);
        result.defineConstant("E", RubyFloat.newFloat(runtime, Math.E));
        result.defineConstant("PI", RubyFloat.newFloat(runtime, Math.PI));
        result.defineModuleFunction("atan2", callbackFactory.getSingletonMethod("atan2", RubyNumeric.class, RubyNumeric.class));
        result.defineModuleFunction("cos", callbackFactory.getSingletonMethod("cos", RubyNumeric.class));
        result.defineModuleFunction("exp", callbackFactory.getSingletonMethod("exp", RubyNumeric.class));
        result.defineModuleFunction("frexp", callbackFactory.getSingletonMethod("frexp", RubyNumeric.class));
        result.defineModuleFunction("ldexp", callbackFactory.getSingletonMethod("ldexp", RubyNumeric.class, RubyNumeric.class));
        result.defineModuleFunction("log", callbackFactory.getSingletonMethod("log", RubyNumeric.class));
        result.defineModuleFunction("log10", callbackFactory.getSingletonMethod("log10", RubyNumeric.class));
        result.defineModuleFunction("sin", callbackFactory.getSingletonMethod("sin", RubyNumeric.class));
        result.defineModuleFunction("sqrt", callbackFactory.getSingletonMethod("sqrt", RubyNumeric.class));
        result.defineModuleFunction("tan", callbackFactory.getSingletonMethod("tan", RubyNumeric.class));
        return result;
    }

    public static RubyFloat atan2(IRubyObject recv, RubyNumeric x, RubyNumeric y) {
        return RubyFloat.newFloat(recv.getRuntime(), Math.atan2(x.getDoubleValue(), y.getDoubleValue()));
    }

    public static RubyFloat cos(IRubyObject recv, RubyNumeric x) {
        return RubyFloat.newFloat(recv.getRuntime(), Math.cos(x.getDoubleValue()));
    }

    public static RubyFloat exp(IRubyObject recv, RubyNumeric exponent) {
        return RubyFloat.newFloat(recv.getRuntime(), Math.exp(exponent.getDoubleValue()));
    }

    public static RubyArray frexp(IRubyObject recv, RubyNumeric other) {
        double mantissa = other.getDoubleValue();
        int sign = 1;
        double exponent = 0.0;
        if (mantissa != 0.0) {
            if (mantissa < 0.0) {
                mantissa = -mantissa;
                sign = -1;
            }
            while (mantissa < 0.5) {
                mantissa *= 2.0;
                exponent -= 1.0;
            }
            while (mantissa >= 1.0) {
                mantissa *= 0.5;
                exponent += 1.0;
            }
        }
        RubyArray result = recv.getRuntime().newArray(2);
        result.append(RubyFloat.newFloat(recv.getRuntime(), (double)sign * mantissa));
        result.append(RubyFloat.newFloat(recv.getRuntime(), exponent));
        return result;
    }

    public static RubyFloat ldexp(IRubyObject recv, RubyNumeric mantissa, RubyNumeric exponent) {
        return RubyFloat.newFloat(recv.getRuntime(), mantissa.getDoubleValue() * Math.pow(2.0, exponent.getDoubleValue()));
    }

    public static RubyFloat log(IRubyObject recv, RubyNumeric x) {
        return RubyFloat.newFloat(recv.getRuntime(), Math.log(x.getDoubleValue()));
    }

    public static RubyFloat log10(IRubyObject recv, RubyNumeric x) {
        return RubyFloat.newFloat(recv.getRuntime(), Math.log(x.getDoubleValue()) / Math.log(10.0));
    }

    public static RubyFloat sin(IRubyObject recv, RubyNumeric x) {
        return RubyFloat.newFloat(recv.getRuntime(), Math.sin(x.getDoubleValue()));
    }

    public static RubyFloat sqrt(IRubyObject recv, RubyNumeric other) {
        double x = other.getDoubleValue();
        if (x < 0.0) {
            return RubyFloat.newFloat(recv.getRuntime(), Double.NaN);
        }
        return RubyFloat.newFloat(recv.getRuntime(), Math.sqrt(x));
    }

    public static RubyFloat tan(IRubyObject recv, RubyNumeric x) {
        return RubyFloat.newFloat(recv.getRuntime(), Math.tan(x.getDoubleValue()));
    }
}

