/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.IRuby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyObject;
import org.jruby.runtime.CallbackFactory;

public class RubyMutex
extends RubyObject {
    private boolean isLocked = false;

    public RubyMutex(IRuby runtime) {
        super(runtime, runtime.getClass("Mutex"));
    }

    public static void createMutexClass(IRuby runtime) {
        RubyClass mutexClass = runtime.defineClass("Mutex", runtime.getObject());
        CallbackFactory callbackFactory = runtime.callbackFactory(RubyMutex.class);
        mutexClass.defineMethod("lock", callbackFactory.getMethod("lock"));
        mutexClass.defineMethod("unlock", callbackFactory.getMethod("unlock"));
        mutexClass.defineMethod("locked?", callbackFactory.getMethod("locked_p"));
    }

    public RubyMutex lock() {
        this.isLocked = true;
        return this;
    }

    public RubyMutex unlock() {
        this.isLocked = false;
        return this;
    }

    public RubyBoolean locked_p() {
        return this.getRuntime().newBoolean(this.isLocked);
    }
}

