/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.IRuby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyObject;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.StringScanner;

public class RubyStringScanner
extends RubyObject {
    private StringScanner scanner;

    public static RubyClass createScannerClass(IRuby runtime) {
        RubyClass scannerClass = runtime.defineClass("StringScanner", runtime.getObject());
        CallbackFactory callbackFactory = runtime.callbackFactory(RubyStringScanner.class);
        scannerClass.defineSingletonMethod("new", callbackFactory.getOptSingletonMethod("newInstance"));
        scannerClass.defineMethod("initialize", callbackFactory.getOptMethod("initialize"));
        scannerClass.defineMethod("<<", callbackFactory.getMethod("concat", IRubyObject.class));
        scannerClass.defineMethod("concat", callbackFactory.getMethod("concat", IRubyObject.class));
        scannerClass.defineMethod("[]", callbackFactory.getMethod("group", RubyFixnum.class));
        scannerClass.defineMethod("beginning_of_line?", callbackFactory.getMethod("bol_p"));
        scannerClass.defineMethod("bol?", callbackFactory.getMethod("bol_p"));
        scannerClass.defineMethod("check", callbackFactory.getMethod("check", RubyRegexp.class));
        scannerClass.defineMethod("check_until", callbackFactory.getMethod("check_until", RubyRegexp.class));
        scannerClass.defineMethod("clear", callbackFactory.getMethod("terminate"));
        scannerClass.defineMethod("empty?", callbackFactory.getMethod("eos_p"));
        scannerClass.defineMethod("eos?", callbackFactory.getMethod("eos_p"));
        scannerClass.defineMethod("exist?", callbackFactory.getMethod("exist_p", RubyRegexp.class));
        scannerClass.defineMethod("get_byte", callbackFactory.getMethod("getch"));
        scannerClass.defineMethod("getbyte", callbackFactory.getMethod("getch"));
        scannerClass.defineMethod("getch", callbackFactory.getMethod("getch"));
        scannerClass.defineMethod("inspect", callbackFactory.getMethod("inspect"));
        scannerClass.defineMethod("match?", callbackFactory.getMethod("match_p", RubyRegexp.class));
        scannerClass.defineMethod("matched", callbackFactory.getMethod("matched"));
        scannerClass.defineMethod("matched?", callbackFactory.getMethod("matched_p"));
        scannerClass.defineMethod("matched_size", callbackFactory.getMethod("matched_size"));
        scannerClass.defineMethod("matchedsize", callbackFactory.getMethod("matched_size"));
        scannerClass.defineMethod("peek", callbackFactory.getMethod("peek", RubyFixnum.class));
        scannerClass.defineMethod("peep", callbackFactory.getMethod("peek", RubyFixnum.class));
        scannerClass.defineMethod("pointer", callbackFactory.getMethod("pos"));
        scannerClass.defineMethod("pointer=", callbackFactory.getMethod("set_pos", RubyFixnum.class));
        scannerClass.defineMethod("pos=", callbackFactory.getMethod("set_pos", RubyFixnum.class));
        scannerClass.defineMethod("pos", callbackFactory.getMethod("pos"));
        scannerClass.defineMethod("post_match", callbackFactory.getMethod("post_match"));
        scannerClass.defineMethod("pre_match", callbackFactory.getMethod("pre_match"));
        scannerClass.defineMethod("reset", callbackFactory.getMethod("reset"));
        scannerClass.defineMethod("rest", callbackFactory.getMethod("rest"));
        scannerClass.defineMethod("rest?", callbackFactory.getMethod("rest_p"));
        scannerClass.defineMethod("rest_size", callbackFactory.getMethod("rest_size"));
        scannerClass.defineMethod("restsize", callbackFactory.getMethod("rest_size"));
        scannerClass.defineMethod("scan", callbackFactory.getMethod("scan", RubyRegexp.class));
        scannerClass.defineMethod("scan_full", callbackFactory.getMethod("scan_full", RubyRegexp.class, RubyBoolean.class, RubyBoolean.class));
        scannerClass.defineMethod("scan_until", callbackFactory.getMethod("scan_until", RubyRegexp.class));
        scannerClass.defineMethod("search_full", callbackFactory.getMethod("search_full", RubyRegexp.class, RubyBoolean.class, RubyBoolean.class));
        scannerClass.defineMethod("skip", callbackFactory.getMethod("skip", RubyRegexp.class));
        scannerClass.defineMethod("skip_until", callbackFactory.getMethod("skip_until", RubyRegexp.class));
        scannerClass.defineMethod("string", callbackFactory.getMethod("string"));
        scannerClass.defineMethod("string=", callbackFactory.getMethod("set_string", RubyString.class));
        scannerClass.defineMethod("terminate", callbackFactory.getMethod("terminate"));
        scannerClass.defineMethod("unscan", callbackFactory.getMethod("unscan"));
        return scannerClass;
    }

    public static IRubyObject newInstance(IRubyObject recv, IRubyObject[] args) {
        RubyStringScanner result = new RubyStringScanner(recv.getRuntime(), (RubyClass)recv);
        result.callInit(args);
        return result;
    }

    protected RubyStringScanner(IRuby runtime, RubyClass type) {
        super(runtime, type);
    }

    @Override
    public IRubyObject initialize(IRubyObject[] args) {
        this.scanner = this.checkArgumentCount(args, 0, 2) > 0 ? new StringScanner(args[0].convertToString().getValue()) : new StringScanner();
        return this;
    }

    public IRubyObject concat(IRubyObject obj) {
        this.scanner.append(obj.convertToString().getValue());
        return this;
    }

    private RubyBoolean trueOrFalse(boolean p) {
        if (p) {
            return this.getRuntime().getTrue();
        }
        return this.getRuntime().getFalse();
    }

    private IRubyObject positiveFixnumOrNil(int val) {
        if (val > -1) {
            return RubyFixnum.newFixnum(this.getRuntime(), val);
        }
        return this.getRuntime().getNil();
    }

    private IRubyObject stringOrNil(CharSequence cs) {
        if (cs == null) {
            return this.getRuntime().getNil();
        }
        return RubyString.newString(this.getRuntime(), cs);
    }

    public IRubyObject group(RubyFixnum num) {
        return this.stringOrNil(this.scanner.group(RubyFixnum.fix2int(num)));
    }

    public RubyBoolean bol_p() {
        return this.trueOrFalse(this.scanner.isBeginningOfLine());
    }

    public IRubyObject check(RubyRegexp rx) {
        return this.stringOrNil(this.scanner.check(rx.getPattern()));
    }

    public IRubyObject check_until(RubyRegexp rx) {
        return this.stringOrNil(this.scanner.checkUntil(rx.getPattern()));
    }

    public IRubyObject terminate() {
        this.scanner.terminate();
        return this;
    }

    public RubyBoolean eos_p() {
        return this.trueOrFalse(this.scanner.isEndOfString());
    }

    public IRubyObject exist_p(RubyRegexp rx) {
        return this.positiveFixnumOrNil(this.scanner.exists(rx.getPattern()));
    }

    public IRubyObject getch() {
        char c = this.scanner.getChar();
        if (c == '\u0000') {
            return this.getRuntime().getNil();
        }
        return RubyString.newString(this.getRuntime(), new Character(c).toString());
    }

    @Override
    public IRubyObject inspect() {
        return super.inspect();
    }

    public IRubyObject match_p(RubyRegexp rx) {
        return this.positiveFixnumOrNil(this.scanner.matches(rx.getPattern()));
    }

    public IRubyObject matched() {
        return this.stringOrNil(this.scanner.matchedValue());
    }

    public RubyBoolean matched_p() {
        return this.trueOrFalse(this.scanner.matched());
    }

    public IRubyObject matched_size() {
        return this.positiveFixnumOrNil(this.scanner.matchedSize());
    }

    public IRubyObject peek(RubyFixnum length) {
        return RubyString.newString(this.getRuntime(), this.scanner.peek(RubyFixnum.fix2int(length)));
    }

    public RubyFixnum pos() {
        return RubyFixnum.newFixnum(this.getRuntime(), this.scanner.getPos());
    }

    public RubyFixnum set_pos(RubyFixnum pos) {
        try {
            this.scanner.setPos(RubyFixnum.fix2int(pos));
        }
        catch (IllegalArgumentException e) {
            throw this.getRuntime().newRangeError("index out of range");
        }
        return pos;
    }

    public IRubyObject post_match() {
        return this.stringOrNil(this.scanner.postMatch());
    }

    public IRubyObject pre_match() {
        return this.stringOrNil(this.scanner.preMatch());
    }

    public IRubyObject reset() {
        this.scanner.reset();
        return this;
    }

    public RubyString rest() {
        return RubyString.newString(this.getRuntime(), this.scanner.rest());
    }

    public RubyBoolean rest_p() {
        return this.trueOrFalse(!this.scanner.isEndOfString());
    }

    public RubyFixnum rest_size() {
        return RubyFixnum.newFixnum(this.getRuntime(), this.scanner.rest().length());
    }

    public IRubyObject scan(RubyRegexp rx) {
        return this.stringOrNil(this.scanner.scan(rx.getPattern()));
    }

    public IRubyObject scan_full(RubyRegexp rx, RubyBoolean adv_ptr, RubyBoolean ret_str) {
        if (adv_ptr.isTrue()) {
            if (ret_str.isTrue()) {
                return this.stringOrNil(this.scanner.scan(rx.getPattern()));
            }
            return this.positiveFixnumOrNil(this.scanner.skip(rx.getPattern()));
        }
        if (ret_str.isTrue()) {
            return this.stringOrNil(this.scanner.check(rx.getPattern()));
        }
        return this.positiveFixnumOrNil(this.scanner.matches(rx.getPattern()));
    }

    public IRubyObject scan_until(RubyRegexp rx) {
        return this.stringOrNil(this.scanner.scanUntil(rx.getPattern()));
    }

    public IRubyObject search_full(RubyRegexp rx, RubyBoolean adv_ptr, RubyBoolean ret_str) {
        if (adv_ptr.isTrue()) {
            if (ret_str.isTrue()) {
                return this.stringOrNil(this.scanner.scanUntil(rx.getPattern()));
            }
            return this.positiveFixnumOrNil(this.scanner.skipUntil(rx.getPattern()));
        }
        if (ret_str.isTrue()) {
            return this.stringOrNil(this.scanner.checkUntil(rx.getPattern()));
        }
        return this.positiveFixnumOrNil(this.scanner.exists(rx.getPattern()));
    }

    public IRubyObject skip(RubyRegexp rx) {
        return this.positiveFixnumOrNil(this.scanner.skip(rx.getPattern()));
    }

    public IRubyObject skip_until(RubyRegexp rx) {
        return this.positiveFixnumOrNil(this.scanner.skipUntil(rx.getPattern()));
    }

    public RubyString string() {
        return RubyString.newString(this.getRuntime(), this.scanner.getString());
    }

    public RubyString set_string(RubyString str) {
        this.scanner.setString(str.getValue());
        return str;
    }

    public IRubyObject unscan() {
        this.scanner.unscan();
        return this;
    }
}

