/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.util.HashMap;
import java.util.Map;
import org.jruby.IRuby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.RubyThreadGroup;
import org.jruby.exceptions.RaiseException;
import org.jruby.exceptions.ThreadKill;
import org.jruby.internal.runtime.NativeThread;
import org.jruby.internal.runtime.ThreadService;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyThread
extends RubyObject {
    private NativeThread threadImpl;
    private Map threadLocalVariables = new HashMap();
    private boolean abortOnException;
    private RaiseException exitingException;
    private IRubyObject receivedException;
    private RubyThreadGroup threadGroup;
    private ThreadService threadService;
    private Object hasStartedLock = new Object();
    private boolean hasStarted = false;
    private volatile boolean isStopped = false;
    public Object stopLock = new Object();
    private volatile boolean killed = false;
    public Object killLock = new Object();
    private RubyThread joinedByCriticalThread;

    public static RubyClass createThreadClass(IRuby runtime) {
        RubyClass threadClass = runtime.defineClass("Thread", runtime.getObject());
        CallbackFactory callbackFactory = runtime.callbackFactory(RubyThread.class);
        threadClass.defineMethod("[]", callbackFactory.getMethod("aref", IRubyObject.class));
        threadClass.defineMethod("[]=", callbackFactory.getMethod("aset", IRubyObject.class, IRubyObject.class));
        threadClass.defineMethod("abort_on_exception", callbackFactory.getMethod("abort_on_exception"));
        threadClass.defineMethod("abort_on_exception=", callbackFactory.getMethod("abort_on_exception_set", IRubyObject.class));
        threadClass.defineMethod("alive?", callbackFactory.getMethod("is_alive"));
        threadClass.defineMethod("group", callbackFactory.getMethod("group"));
        threadClass.defineMethod("join", callbackFactory.getMethod("join"));
        threadClass.defineMethod("key?", callbackFactory.getMethod("has_key", IRubyObject.class));
        threadClass.defineMethod("priority", callbackFactory.getMethod("priority"));
        threadClass.defineMethod("priority=", callbackFactory.getMethod("priority_set", IRubyObject.class));
        threadClass.defineMethod("raise", callbackFactory.getMethod("raise", IRubyObject.class));
        threadClass.defineMethod("run", callbackFactory.getMethod("run"));
        threadClass.defineMethod("status", callbackFactory.getMethod("status"));
        threadClass.defineMethod("stop?", callbackFactory.getMethod("isStopped"));
        threadClass.defineMethod("wakeup", callbackFactory.getMethod("wakeup"));
        threadClass.defineMethod("kill", callbackFactory.getMethod("kill"));
        threadClass.defineMethod("exit", callbackFactory.getMethod("exit"));
        threadClass.defineSingletonMethod("current", callbackFactory.getSingletonMethod("current"));
        threadClass.defineSingletonMethod("fork", callbackFactory.getOptSingletonMethod("newInstance"));
        threadClass.defineSingletonMethod("new", callbackFactory.getOptSingletonMethod("newInstance"));
        threadClass.defineSingletonMethod("list", callbackFactory.getSingletonMethod("list"));
        threadClass.defineSingletonMethod("pass", callbackFactory.getSingletonMethod("pass"));
        threadClass.defineSingletonMethod("start", callbackFactory.getOptSingletonMethod("start"));
        threadClass.defineSingletonMethod("critical=", callbackFactory.getSingletonMethod("critical_set", RubyBoolean.class));
        threadClass.defineSingletonMethod("critical", callbackFactory.getSingletonMethod("critical"));
        threadClass.defineSingletonMethod("stop", callbackFactory.getSingletonMethod("stop"));
        threadClass.defineSingletonMethod("kill", callbackFactory.getSingletonMethod("s_kill", RubyThread.class));
        threadClass.defineSingletonMethod("exit", callbackFactory.getSingletonMethod("s_exit"));
        threadClass.defineSingletonMethod("abort_on_exception", callbackFactory.getSingletonMethod("abort_on_exception"));
        threadClass.defineSingletonMethod("abort_on_exception=", callbackFactory.getSingletonMethod("abort_on_exception_set", IRubyObject.class));
        RubyThread rubyThread = new RubyThread(runtime, threadClass);
        rubyThread.hasStarted = true;
        rubyThread.threadImpl = new NativeThread(rubyThread, Thread.currentThread());
        runtime.getThreadService().setMainThread(rubyThread);
        threadClass.defineSingletonMethod("main", callbackFactory.getSingletonMethod("main"));
        return threadClass;
    }

    public static IRubyObject newInstance(IRubyObject recv, IRubyObject[] args) {
        return RubyThread.startThread(recv, args, true);
    }

    public static RubyThread start(IRubyObject recv, IRubyObject[] args) {
        return RubyThread.startThread(recv, args, false);
    }

    public static RubyThread adopt(IRubyObject recv, Thread t) {
        return RubyThread.adoptThread(recv, t);
    }

    private static RubyThread adoptThread(IRubyObject recv, Thread t) {
        IRuby runtime = recv.getRuntime();
        RubyThread rubyThread = new RubyThread(runtime, (RubyClass)recv, false);
        rubyThread.threadImpl = new NativeThread(rubyThread, t);
        runtime.getThreadService().registerNewThread(rubyThread);
        runtime.getCurrentContext().preAdoptThread();
        rubyThread.callInit(new IRubyObject[0]);
        rubyThread.notifyStarted();
        return rubyThread;
    }

    private static RubyThread startThread(IRubyObject recv, IRubyObject[] args, boolean callInit) {
        IRuby runtime = recv.getRuntime();
        if (!runtime.getCurrentContext().isBlockGiven()) {
            throw runtime.newThreadError("must be called with a block");
        }
        RubyThread rubyThread = new RubyThread(runtime, (RubyClass)recv);
        if (callInit) {
            rubyThread.callInit(args);
        }
        rubyThread.threadImpl = new NativeThread(rubyThread, args);
        rubyThread.threadImpl.start();
        rubyThread.ensureStarted();
        return rubyThread;
    }

    public void cleanTerminate() {
        try {
            this.isStopped = true;
            this.waitIfCriticalized();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitIfCriticalized() throws InterruptedException {
        RubyThread criticalThread = this.getRuntime().getThreadService().getCriticalThread();
        if (criticalThread != null && criticalThread != this && criticalThread != this.joinedByCriticalThread) {
            RubyThread rubyThread = criticalThread;
            synchronized (rubyThread) {
                criticalThread.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyStarted() {
        assert (this.isCurrent());
        Object object = this.hasStartedLock;
        synchronized (object) {
            this.hasStarted = true;
            this.hasStartedLock.notifyAll();
        }
    }

    public void pollThreadEvents() {
        this.pollReceivedExceptions();
        this.criticalizeOrDieIfKilled();
    }

    private void pollReceivedExceptions() {
        if (this.receivedException != null) {
            IRubyObject raiseException = this.receivedException;
            this.receivedException = null;
            RubyModule kernelModule = this.getRuntime().getModule("Kernel");
            kernelModule.callMethod(this.getRuntime().getCurrentContext(), "raise", raiseException);
        }
    }

    public void criticalizeOrDieIfKilled() {
        try {
            this.waitIfCriticalized();
        }
        catch (InterruptedException ie) {
            throw new ThreadKill();
        }
        this.dieIfKilled();
    }

    private RubyThread(IRuby runtime, RubyClass type) {
        super(runtime, type);
        this.threadService = runtime.getThreadService();
        RubyThreadGroup defaultThreadGroup = (RubyThreadGroup)runtime.getClass("ThreadGroup").getConstant("Default");
        defaultThreadGroup.add(this);
    }

    private RubyThread(IRuby runtime, RubyClass type, boolean narf) {
        super(runtime, type);
        this.threadService = runtime.getThreadService();
        RubyThreadGroup defaultThreadGroup = (RubyThreadGroup)runtime.getClass("ThreadGroup").getConstant("Default");
        defaultThreadGroup.add(this);
    }

    public static RubyBoolean abort_on_exception(IRubyObject recv) {
        IRuby runtime = recv.getRuntime();
        return runtime.isGlobalAbortOnExceptionEnabled() ? recv.getRuntime().getTrue() : recv.getRuntime().getFalse();
    }

    public static IRubyObject abort_on_exception_set(IRubyObject recv, IRubyObject value) {
        recv.getRuntime().setGlobalAbortOnExceptionEnabled(value.isTrue());
        return value;
    }

    public static RubyThread current(IRubyObject recv) {
        return recv.getRuntime().getCurrentContext().getThread();
    }

    public static RubyThread main(IRubyObject recv) {
        return recv.getRuntime().getThreadService().getMainThread();
    }

    public static IRubyObject pass(IRubyObject recv) {
        RubyThread currentThread;
        IRuby runtime = recv.getRuntime();
        ThreadService ts = runtime.getThreadService();
        RubyThread criticalThread = ts.getCriticalThread();
        if (criticalThread == (currentThread = ts.getCurrentContext().getThread())) {
            ts.setCritical(false);
        }
        Thread.yield();
        if (criticalThread != null) {
            ts.setCritical(true);
        }
        return recv.getRuntime().getNil();
    }

    public static RubyArray list(IRubyObject recv) {
        IRubyObject[] activeThreads = recv.getRuntime().getThreadService().getActiveRubyThreads();
        return recv.getRuntime().newArray(activeThreads);
    }

    public IRubyObject aref(IRubyObject key) {
        String name = this.keyName(key);
        if (!this.threadLocalVariables.containsKey(name)) {
            return this.getRuntime().getNil();
        }
        return (IRubyObject)this.threadLocalVariables.get(name);
    }

    public IRubyObject aset(IRubyObject key, IRubyObject value) {
        String name = this.keyName(key);
        this.threadLocalVariables.put(name, value);
        return value;
    }

    private String keyName(IRubyObject key) {
        String name;
        if (key instanceof RubySymbol) {
            name = key.asSymbol();
        } else if (key instanceof RubyString) {
            name = ((RubyString)key).toString();
        } else {
            throw this.getRuntime().newArgumentError(key.inspect() + " is not a symbol");
        }
        return name;
    }

    public RubyBoolean abort_on_exception() {
        return this.abortOnException ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    public IRubyObject abort_on_exception_set(IRubyObject val) {
        this.abortOnException = val.isTrue();
        return val;
    }

    public RubyBoolean is_alive() {
        return this.threadImpl.isAlive() ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    public RubyThread join() {
        block5: {
            if (this.isCurrent()) {
                throw this.getRuntime().newThreadError("thread tried to join itself");
            }
            this.ensureStarted();
            try {
                RubyThread criticalThread = this.getRuntime().getThreadService().getCriticalThread();
                if (criticalThread != null) {
                    this.joinedByCriticalThread = criticalThread;
                    this.threadImpl.interrupt();
                }
                this.threadImpl.join();
            }
            catch (InterruptedException iExcptn) {
                if ($assertionsDisabled) break block5;
                throw new AssertionError((Object)iExcptn);
            }
        }
        if (this.exitingException != null) {
            throw this.exitingException;
        }
        return this;
    }

    public IRubyObject group() {
        if (this.threadGroup == null) {
            return this.getRuntime().getNil();
        }
        return this.threadGroup;
    }

    void setThreadGroup(RubyThreadGroup rubyThreadGroup) {
        this.threadGroup = rubyThreadGroup;
    }

    public RubyBoolean has_key(IRubyObject key) {
        String name = this.keyName(key);
        return this.getRuntime().newBoolean(this.threadLocalVariables.containsKey(name));
    }

    public static IRubyObject critical_set(IRubyObject receiver, RubyBoolean value) {
        receiver.getRuntime().getThreadService().setCritical(value.isTrue());
        return value;
    }

    public static IRubyObject critical(IRubyObject receiver) {
        return receiver.getRuntime().newBoolean(receiver.getRuntime().getThreadService().getCriticalThread() != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject stop(IRubyObject receiver) {
        Object stopLock;
        RubyThread rubyThread = receiver.getRuntime().getThreadService().getCurrentContext().getThread();
        Object object = stopLock = rubyThread.stopLock;
        synchronized (object) {
            try {
                rubyThread.isStopped = true;
                receiver.getRuntime().getThreadService().setCritical(false);
                stopLock.wait();
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            rubyThread.isStopped = false;
        }
        return receiver.getRuntime().getNil();
    }

    public static IRubyObject s_kill(IRubyObject receiver, RubyThread rubyThread) {
        return rubyThread.kill();
    }

    public static IRubyObject s_exit(IRubyObject receiver) {
        RubyThread rubyThread = receiver.getRuntime().getThreadService().getCurrentContext().getThread();
        rubyThread.killed = true;
        receiver.getRuntime().getThreadService().setCritical(false);
        throw new ThreadKill();
    }

    public RubyBoolean isStopped() {
        return this.getRuntime().newBoolean(this.isStopped);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RubyThread wakeup() {
        Object object = this.stopLock;
        synchronized (object) {
            this.stopLock.notifyAll();
        }
        return this;
    }

    public RubyFixnum priority() {
        return this.getRuntime().newFixnum(this.threadImpl.getPriority());
    }

    public IRubyObject priority_set(IRubyObject priority) {
        int iPriority = RubyNumeric.fix2int(priority);
        if (iPriority < 1) {
            iPriority = 1;
        } else if (iPriority > 10) {
            iPriority = 10;
        }
        this.threadImpl.setPriority(iPriority);
        return priority;
    }

    public IRubyObject raise(IRubyObject exc) {
        this.receivedException = exc;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject run() {
        if (this.isStopped) {
            Object object = this.stopLock;
            synchronized (object) {
                this.isStopped = false;
                this.stopLock.notifyAll();
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sleep(long millis) throws InterruptedException {
        try {
            Object object = this.stopLock;
            synchronized (object) {
                this.isStopped = true;
                this.stopLock.wait(millis);
            }
        }
        finally {
            this.isStopped = false;
        }
    }

    public IRubyObject status() {
        if (this.threadImpl.isAlive()) {
            if (this.isStopped) {
                return this.getRuntime().newString("sleep");
            }
            if (this.killed) {
                return this.getRuntime().newString("aborting");
            }
            return this.getRuntime().newString("run");
        }
        if (this.exitingException != null) {
            return this.getRuntime().getNil();
        }
        return this.getRuntime().newBoolean(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject kill() {
        RubyThread rubyThread = this;
        synchronized (rubyThread) {
            if (this.killed) {
                return this;
            }
            this.killed = true;
            this.threadImpl.interrupt();
            try {
                if (!this.threadImpl.isInterrupted()) {
                    this.threadImpl.join();
                }
            }
            catch (InterruptedException ie) {
                throw new ThreadKill();
            }
        }
        return this;
    }

    public IRubyObject exit() {
        return this.kill();
    }

    public void dieIfKilled() {
        if (this.killed) {
            throw new ThreadKill();
        }
    }

    private boolean isCurrent() {
        return this.threadImpl.isCurrent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureStarted() {
        if (!this.hasStarted) {
            Object object = this.hasStartedLock;
            synchronized (object) {
                block7: {
                    if (!this.hasStarted) {
                        try {
                            this.hasStartedLock.wait();
                        }
                        catch (InterruptedException iExcptn) {
                            if ($assertionsDisabled) break block7;
                            throw new AssertionError((Object)iExcptn);
                        }
                    }
                }
            }
        }
    }

    public void exceptionRaised(RaiseException exception) {
        assert (this.isCurrent());
        IRuby runtime = exception.getException().getRuntime();
        if (this.abortOnException(runtime)) {
            RubyException re = RubyException.newException(this.getRuntime(), this.getRuntime().getClass("SystemExit"), exception.getMessage());
            re.setInstanceVariable("status", this.getRuntime().newFixnum(1L));
            this.threadService.getMainThread().raise(re);
        } else {
            this.exitingException = exception;
        }
    }

    private boolean abortOnException(IRuby runtime) {
        return runtime.isGlobalAbortOnExceptionEnabled() || this.abortOnException;
    }

    public static RubyThread mainThread(IRubyObject receiver) {
        return receiver.getRuntime().getThreadService().getMainThread();
    }
}

