/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast.visitor;

import org.jruby.ast.BackRefNode;
import org.jruby.ast.BignumNode;
import org.jruby.ast.CallNode;
import org.jruby.ast.ClassNode;
import org.jruby.ast.ClassVarNode;
import org.jruby.ast.Colon2Node;
import org.jruby.ast.ConstNode;
import org.jruby.ast.DRegexpNode;
import org.jruby.ast.DStrNode;
import org.jruby.ast.DVarNode;
import org.jruby.ast.DefinedNode;
import org.jruby.ast.DotNode;
import org.jruby.ast.FalseNode;
import org.jruby.ast.FixnumNode;
import org.jruby.ast.FloatNode;
import org.jruby.ast.GlobalVarNode;
import org.jruby.ast.InstVarNode;
import org.jruby.ast.LocalVarNode;
import org.jruby.ast.NewlineNode;
import org.jruby.ast.NilNode;
import org.jruby.ast.Node;
import org.jruby.ast.NthRefNode;
import org.jruby.ast.RegexpNode;
import org.jruby.ast.SelfNode;
import org.jruby.ast.StrNode;
import org.jruby.ast.SymbolNode;
import org.jruby.ast.TrueNode;
import org.jruby.ast.visitor.AbstractVisitor;
import org.jruby.common.IRubyWarnings;
import org.jruby.evaluator.Instruction;

public class UselessStatementVisitor
extends AbstractVisitor {
    private IRubyWarnings warnings;

    public UselessStatementVisitor(IRubyWarnings warnings) {
        this.warnings = warnings;
    }

    @Override
    protected Instruction visitNode(Node iVisited) {
        return null;
    }

    private void handleUselessWarn(Node node, String useless) {
        this.warnings.warn(node.getPosition(), "Useless use of " + useless + " in void context.");
    }

    @Override
    public Instruction visitCallNode(CallNode iVisited) {
        String name = iVisited.getName().intern();
        if (name == "+" || name == "-" || name == "*" || name == "/" || name == "%" || name == "**" || name == "+@" || name == "-@" || name == "|" || name == "^" || name == "&" || name == "<=>" || name == ">" || name == ">=" || name == "<" || name == "<=" || name == "==" || name == "!=") {
            this.handleUselessWarn(iVisited, name);
        }
        return null;
    }

    @Override
    public Instruction visitBackRefNode(BackRefNode iVisited) {
        this.handleUselessWarn(iVisited, "a variable");
        return null;
    }

    @Override
    public Instruction visitDVarNode(DVarNode iVisited) {
        this.handleUselessWarn(iVisited, "a variable");
        return null;
    }

    @Override
    public Instruction visitGlobalVarNode(GlobalVarNode iVisited) {
        this.handleUselessWarn(iVisited, "a variable");
        return null;
    }

    @Override
    public Instruction visitLocalVarNode(LocalVarNode iVisited) {
        this.handleUselessWarn(iVisited, "a variable");
        return null;
    }

    @Override
    public Instruction visitNthRefNode(NthRefNode iVisited) {
        this.handleUselessWarn(iVisited, "a variable");
        return null;
    }

    @Override
    public Instruction visitClassVarNode(ClassVarNode iVisited) {
        this.handleUselessWarn(iVisited, "a variable");
        return null;
    }

    @Override
    public Instruction visitInstVarNode(InstVarNode iVisited) {
        this.handleUselessWarn(iVisited, "a variable");
        return null;
    }

    @Override
    public Instruction visitConstNode(ConstNode iVisited) {
        this.handleUselessWarn(iVisited, "a constant");
        return null;
    }

    @Override
    public Instruction visitBignumNode(BignumNode iVisited) {
        this.handleUselessWarn(iVisited, "a literal");
        return null;
    }

    @Override
    public Instruction visitDRegxNode(DRegexpNode iVisited) {
        this.handleUselessWarn(iVisited, "a literal");
        return null;
    }

    @Override
    public Instruction visitDStrNode(DStrNode iVisited) {
        this.handleUselessWarn(iVisited, "a literal");
        return null;
    }

    @Override
    public Instruction visitFixnumNode(FixnumNode iVisited) {
        this.handleUselessWarn(iVisited, "a literal");
        return null;
    }

    @Override
    public Instruction visitFloatNode(FloatNode iVisited) {
        this.handleUselessWarn(iVisited, "a literal");
        return null;
    }

    @Override
    public Instruction visitRegexpNode(RegexpNode iVisited) {
        this.handleUselessWarn(iVisited, "a literal");
        return null;
    }

    @Override
    public Instruction visitStrNode(StrNode iVisited) {
        this.handleUselessWarn(iVisited, "a literal");
        return null;
    }

    @Override
    public Instruction visitSymbolNode(SymbolNode iVisited) {
        this.handleUselessWarn(iVisited, "a literal");
        return null;
    }

    @Override
    public Instruction visitClassNode(ClassNode iVisited) {
        this.handleUselessWarn(iVisited, "::");
        return null;
    }

    @Override
    public Instruction visitColon2Node(Colon2Node iVisited) {
        this.handleUselessWarn(iVisited, "::");
        return null;
    }

    @Override
    public Instruction visitDotNode(DotNode iVisited) {
        this.handleUselessWarn(iVisited, iVisited.isExclusive() ? "..." : "..");
        return null;
    }

    @Override
    public Instruction visitDefinedNode(DefinedNode iVisited) {
        this.handleUselessWarn(iVisited, "defined?");
        return null;
    }

    @Override
    public Instruction visitFalseNode(FalseNode iVisited) {
        this.handleUselessWarn(iVisited, "false");
        return null;
    }

    @Override
    public Instruction visitNilNode(NilNode iVisited) {
        this.handleUselessWarn(iVisited, "nil");
        return null;
    }

    @Override
    public Instruction visitSelfNode(SelfNode iVisited) {
        this.handleUselessWarn(iVisited, "self");
        return null;
    }

    @Override
    public Instruction visitTrueNode(TrueNode iVisited) {
        this.handleUselessWarn(iVisited, "true");
        return null;
    }

    @Override
    public Instruction visitNewlineNode(NewlineNode iVisited) {
        this.acceptNode(iVisited.getNextNode());
        return null;
    }
}

