/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.exceptions;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.jruby.IRuby;
import org.jruby.NativeException;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.exceptions.JumpException;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class RaiseException
extends JumpException {
    private static final long serialVersionUID = -7612079169559973951L;
    private RubyException exception;

    public RaiseException(RubyException actException) {
        this(actException, false);
    }

    public RaiseException(IRuby runtime, RubyClass excptnClass, String msg, boolean nativeException) {
        super(msg, JumpException.JumpType.RaiseJump);
        if (msg == null) {
            msg = "No message available";
        }
        this.setException((RubyException)excptnClass.callMethod(runtime.getCurrentContext(), "new", excptnClass.getRuntime().newString(msg)), nativeException);
    }

    public RaiseException(RubyException exception, boolean isNativeException) {
        super(JumpException.JumpType.RaiseJump);
        this.setException(exception, isNativeException);
    }

    public static RaiseException createNativeRaiseException(IRuby runtime, Throwable cause) {
        NativeException nativeException = new NativeException(runtime, runtime.getClass("NativeException"), cause);
        return new RaiseException(cause, nativeException);
    }

    private static String buildMessage(Throwable exception) {
        StringBuffer sb = new StringBuffer();
        StringWriter stackTrace = new StringWriter();
        exception.printStackTrace(new PrintWriter(stackTrace));
        sb.append("Native Exception: '").append(exception.getClass()).append("'; ");
        sb.append("Message: ").append(exception.getMessage()).append("; ");
        sb.append("StackTrace: ").append(stackTrace.getBuffer().toString());
        return sb.toString();
    }

    public RaiseException(Throwable cause, NativeException nativeException) {
        super(RaiseException.buildMessage(cause), cause, JumpException.JumpType.RaiseJump);
        this.setException(nativeException, false);
    }

    public RubyException getException() {
        return this.exception;
    }

    protected void setException(RubyException newException, boolean nativeException) {
        IRuby runtime = newException.getRuntime();
        ThreadContext context = runtime.getCurrentContext();
        if (!context.isWithinDefined()) {
            runtime.getGlobalVariables().set("$!", newException);
        }
        if (runtime.getTraceFunction() != null) {
            runtime.callTraceFunction(context, "return", context.getPosition(), context.getFrameSelf(), context.getFrameLastFunc(), context.getFrameLastClass());
        }
        this.exception = newException;
        if (runtime.getStackTraces() > 5) {
            return;
        }
        runtime.setStackTraces(runtime.getStackTraces() + 1);
        if (newException.callMethod(context, "backtrace").isNil() && context.getSourceFile() != null) {
            IRubyObject backtrace = context.createBacktrace(0, nativeException);
            newException.callMethod(context, "set_backtrace", backtrace);
        }
        runtime.setStackTraces(runtime.getStackTraces() - 1);
    }
}

