/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jruby.IRuby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.exceptions.RaiseException;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaArray;
import org.jruby.javasupport.JavaConstructor;
import org.jruby.javasupport.JavaField;
import org.jruby.javasupport.JavaMethod;
import org.jruby.javasupport.JavaObject;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.Arity;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callback.Callback;

public class JavaClass
extends JavaObject {
    private static final Pattern CAMEL_CASE_SPLITTER = Pattern.compile("([a-z])([A-Z])");

    private JavaClass(IRuby runtime, Class javaClass) {
        super(runtime, runtime.getModule("Java").getClass("JavaClass"), javaClass);
    }

    public static JavaClass get(IRuby runtime, Class klass) {
        JavaClass javaClass = runtime.getJavaSupport().getJavaClassFromCache(klass);
        if (javaClass == null) {
            javaClass = new JavaClass(runtime, klass);
            runtime.getJavaSupport().putJavaClassIntoCache(javaClass);
        }
        return javaClass;
    }

    public static RubyClass createJavaClassClass(IRuby runtime, RubyModule javaModule) {
        RubyClass result = javaModule.defineClassUnder("JavaClass", javaModule.getClass("JavaObject"));
        CallbackFactory callbackFactory = runtime.callbackFactory(JavaClass.class);
        result.includeModule(runtime.getModule("Comparable"));
        JavaObject.registerRubyMethods(runtime, result);
        result.defineSingletonMethod("for_name", callbackFactory.getSingletonMethod("for_name", IRubyObject.class));
        result.defineMethod("public?", callbackFactory.getMethod("public_p"));
        result.defineMethod("protected?", callbackFactory.getMethod("protected_p"));
        result.defineMethod("private?", callbackFactory.getMethod("private_p"));
        result.defineMethod("final?", callbackFactory.getMethod("final_p"));
        result.defineMethod("interface?", callbackFactory.getMethod("interface_p"));
        result.defineMethod("array?", callbackFactory.getMethod("array_p"));
        result.defineMethod("name", callbackFactory.getMethod("name"));
        result.defineMethod("to_s", callbackFactory.getMethod("name"));
        result.defineMethod("superclass", callbackFactory.getMethod("superclass"));
        result.defineMethod("<=>", callbackFactory.getMethod("op_cmp", IRubyObject.class));
        result.defineMethod("java_instance_methods", callbackFactory.getMethod("java_instance_methods"));
        result.defineMethod("java_class_methods", callbackFactory.getMethod("java_class_methods"));
        result.defineMethod("java_method", callbackFactory.getOptMethod("java_method"));
        result.defineMethod("constructors", callbackFactory.getMethod("constructors"));
        result.defineMethod("constructor", callbackFactory.getOptMethod("constructor"));
        result.defineMethod("array_class", callbackFactory.getMethod("array_class"));
        result.defineMethod("new_array", callbackFactory.getMethod("new_array", IRubyObject.class));
        result.defineMethod("fields", callbackFactory.getMethod("fields"));
        result.defineMethod("field", callbackFactory.getMethod("field", IRubyObject.class));
        result.defineMethod("interfaces", callbackFactory.getMethod("interfaces"));
        result.defineMethod("primitive?", callbackFactory.getMethod("primitive_p"));
        result.defineMethod("assignable_from?", callbackFactory.getMethod("assignable_from_p", IRubyObject.class));
        result.defineMethod("component_type", callbackFactory.getMethod("component_type"));
        result.defineMethod("declared_instance_methods", callbackFactory.getMethod("declared_instance_methods"));
        result.defineMethod("declared_class_methods", callbackFactory.getMethod("declared_class_methods"));
        result.defineMethod("declared_fields", callbackFactory.getMethod("declared_fields"));
        result.defineMethod("declared_field", callbackFactory.getMethod("declared_field", IRubyObject.class));
        result.defineMethod("declared_constructors", callbackFactory.getMethod("declared_constructors"));
        result.defineMethod("declared_constructor", callbackFactory.getOptMethod("declared_constructor"));
        result.defineMethod("declared_method", callbackFactory.getOptMethod("declared_method"));
        result.defineMethod("define_instance_methods_for_proxy", callbackFactory.getMethod("define_instance_methods_for_proxy", IRubyObject.class));
        result.getMetaClass().undefineMethod("new");
        return result;
    }

    public static JavaClass for_name(IRubyObject recv, IRubyObject name) {
        String className = name.asSymbol();
        Class klass = recv.getRuntime().getJavaSupport().loadJavaClass(className);
        return JavaClass.get(recv.getRuntime(), klass);
    }

    private Map getMethodsClumped(boolean isStatic) {
        HashMap<String, RubyArray> map = new HashMap<String, RubyArray>();
        if (((Class)this.getValue()).isInterface()) {
            return map;
        }
        Method[] methods = this.javaClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (isStatic != Modifier.isStatic(methods[i].getModifiers())) continue;
            String key = methods[i].getName();
            RubyArray methodsWithName = (RubyArray)map.get(key);
            if (methodsWithName == null) {
                methodsWithName = this.getRuntime().newArray();
                map.put(key, methodsWithName);
            }
            methodsWithName.append(JavaMethod.create(this.getRuntime(), methods[i]));
        }
        return map;
    }

    private Map getPropertysClumped() {
        BeanInfo info;
        HashMap map = new HashMap();
        try {
            info = Introspector.getBeanInfo(this.javaClass());
        }
        catch (IntrospectionException e) {
            return map;
        }
        PropertyDescriptor[] descriptors = info.getPropertyDescriptors();
        for (int i = 0; i < descriptors.length; ++i) {
            Method writeMethod;
            Method readMethod = descriptors[i].getReadMethod();
            if (readMethod != null) {
                String key = readMethod.getName();
                ArrayList<String> aliases = (ArrayList<String>)map.get(key);
                if (aliases == null) {
                    aliases = new ArrayList<String>();
                    map.put(key, aliases);
                }
                if (readMethod.getReturnType() == Boolean.class || readMethod.getReturnType() == Boolean.TYPE) {
                    aliases.add(descriptors[i].getName() + "?");
                }
                aliases.add(descriptors[i].getName());
            }
            if ((writeMethod = descriptors[i].getWriteMethod()) == null) continue;
            String key = writeMethod.getName();
            ArrayList<String> aliases = (ArrayList<String>)map.get(key);
            if (aliases == null) {
                aliases = new ArrayList<String>();
                map.put(key, aliases);
            }
            aliases.add(descriptors[i].getName() + "=");
        }
        return map;
    }

    private void define_instance_method_for_proxy(final RubyClass proxy, List names, final RubyArray methods) {
        final RubyModule javaUtilities = this.getRuntime().getModule("JavaUtilities");
        Callback method = new Callback(){

            @Override
            public IRubyObject execute(IRubyObject self, IRubyObject[] args) {
                IRubyObject[] argsArray = new IRubyObject[args.length + 1];
                ThreadContext context = self.getRuntime().getCurrentContext();
                argsArray[0] = self.callMethod(context, "java_object");
                RubyArray argsAsArray = JavaClass.this.getRuntime().newArray();
                for (int j = 0; j < args.length; ++j) {
                    argsArray[j + 1] = Java.ruby_to_java(proxy, args[j]);
                    argsAsArray.append(argsArray[j + 1]);
                }
                IRubyObject[] mmArgs = new IRubyObject[]{methods, argsAsArray};
                IRubyObject result = javaUtilities.callMethod(context, "matching_method", mmArgs);
                return Java.java_to_ruby(self, result.callMethod(context, "invoke", argsArray));
            }

            @Override
            public Arity getArity() {
                return Arity.optional();
            }
        };
        for (String methodName : names) {
            if (methodName.equals("class")) continue;
            proxy.defineMethod(methodName, method);
            String rubyCasedName = this.getRubyCasedName(methodName);
            if (rubyCasedName == null) continue;
            proxy.defineAlias(rubyCasedName, methodName);
        }
    }

    private String getRubyCasedName(String javaCasedName) {
        Matcher m = CAMEL_CASE_SPLITTER.matcher(javaCasedName);
        String rubyCasedName = m.replaceAll("$1_$2").toLowerCase();
        if (rubyCasedName.equals(javaCasedName)) {
            return null;
        }
        return rubyCasedName;
    }

    public IRubyObject define_instance_methods_for_proxy(IRubyObject arg) {
        assert (arg instanceof RubyClass);
        Map aliasesClump = this.getPropertysClumped();
        Map methodsClump = this.getMethodsClumped(false);
        RubyClass proxy = (RubyClass)arg;
        for (String name : methodsClump.keySet()) {
            RubyArray methods = (RubyArray)methodsClump.get(name);
            ArrayList<String> aliases = (ArrayList<String>)aliasesClump.get(name);
            if (aliases == null) {
                aliases = new ArrayList<String>();
            }
            aliases.add(name);
            this.define_instance_method_for_proxy(proxy, aliases, methods);
        }
        return this.getRuntime().getNil();
    }

    public RubyBoolean public_p() {
        return this.getRuntime().newBoolean(Modifier.isPublic(this.javaClass().getModifiers()));
    }

    public RubyBoolean protected_p() {
        return this.getRuntime().newBoolean(Modifier.isProtected(this.javaClass().getModifiers()));
    }

    public RubyBoolean private_p() {
        return this.getRuntime().newBoolean(Modifier.isPrivate(this.javaClass().getModifiers()));
    }

    Class javaClass() {
        return (Class)this.getValue();
    }

    public RubyBoolean final_p() {
        return this.getRuntime().newBoolean(Modifier.isFinal(this.javaClass().getModifiers()));
    }

    public RubyBoolean interface_p() {
        return this.getRuntime().newBoolean(this.javaClass().isInterface());
    }

    public RubyBoolean array_p() {
        return this.getRuntime().newBoolean(this.javaClass().isArray());
    }

    public RubyString name() {
        return this.getRuntime().newString(this.javaClass().getName());
    }

    public IRubyObject superclass() {
        Class superclass = this.javaClass().getSuperclass();
        if (superclass == null) {
            return this.getRuntime().getNil();
        }
        return JavaClass.get(this.getRuntime(), superclass);
    }

    public RubyFixnum op_cmp(IRubyObject other) {
        if (!(other instanceof JavaClass)) {
            throw this.getRuntime().newTypeError("<=> requires JavaClass (" + other.getType() + " given)");
        }
        JavaClass otherClass = (JavaClass)other;
        if (this.javaClass() == otherClass.javaClass()) {
            return this.getRuntime().newFixnum(0L);
        }
        if (otherClass.javaClass().isAssignableFrom(this.javaClass())) {
            return this.getRuntime().newFixnum(-1L);
        }
        return this.getRuntime().newFixnum(1L);
    }

    public RubyArray java_instance_methods() {
        return this.java_methods(this.javaClass().getMethods(), false);
    }

    public RubyArray declared_instance_methods() {
        return this.java_methods(this.javaClass().getDeclaredMethods(), false);
    }

    private RubyArray java_methods(Method[] methods, boolean isStatic) {
        RubyArray result = this.getRuntime().newArray(methods.length);
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (isStatic != Modifier.isStatic(method.getModifiers())) continue;
            result.append(JavaMethod.create(this.getRuntime(), method));
        }
        return result;
    }

    public RubyArray java_class_methods() {
        return this.java_methods(this.javaClass().getMethods(), true);
    }

    public RubyArray declared_class_methods() {
        return this.java_methods(this.javaClass().getDeclaredMethods(), true);
    }

    public JavaMethod java_method(IRubyObject[] args) throws ClassNotFoundException {
        String methodName = args[0].asSymbol();
        Class[] argumentTypes = this.buildArgumentTypes(args);
        return JavaMethod.create(this.getRuntime(), this.javaClass(), methodName, argumentTypes);
    }

    public JavaMethod declared_method(IRubyObject[] args) throws ClassNotFoundException {
        String methodName = args[0].asSymbol();
        Class[] argumentTypes = this.buildArgumentTypes(args);
        return JavaMethod.createDeclared(this.getRuntime(), this.javaClass(), methodName, argumentTypes);
    }

    private Class[] buildArgumentTypes(IRubyObject[] args) throws ClassNotFoundException {
        if (args.length < 1) {
            throw this.getRuntime().newArgumentError(args.length, 1);
        }
        Class[] argumentTypes = new Class[args.length - 1];
        for (int i = 1; i < args.length; ++i) {
            JavaClass type = JavaClass.for_name(this, args[i]);
            argumentTypes[i - 1] = type.javaClass();
        }
        return argumentTypes;
    }

    public RubyArray constructors() {
        return this.buildConstructors(this.javaClass().getConstructors());
    }

    public RubyArray declared_constructors() {
        return this.buildConstructors(this.javaClass().getDeclaredConstructors());
    }

    private RubyArray buildConstructors(Constructor[] constructors) {
        RubyArray result = this.getRuntime().newArray(constructors.length);
        for (int i = 0; i < constructors.length; ++i) {
            result.append(new JavaConstructor(this.getRuntime(), constructors[i]));
        }
        return result;
    }

    public JavaConstructor constructor(IRubyObject[] args) {
        try {
            Class[] parameterTypes = this.buildClassArgs(args);
            Constructor constructor = this.javaClass().getConstructor(parameterTypes);
            return new JavaConstructor(this.getRuntime(), constructor);
        }
        catch (NoSuchMethodException nsme) {
            throw this.getRuntime().newNameError("no matching java constructor", null);
        }
    }

    public JavaConstructor declared_constructor(IRubyObject[] args) {
        try {
            Class[] parameterTypes = this.buildClassArgs(args);
            Constructor constructor = this.javaClass().getDeclaredConstructor(parameterTypes);
            return new JavaConstructor(this.getRuntime(), constructor);
        }
        catch (NoSuchMethodException nsme) {
            throw this.getRuntime().newNameError("no matching java constructor", null);
        }
    }

    private Class[] buildClassArgs(IRubyObject[] args) {
        Class[] parameterTypes = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            String name = args[i].asSymbol();
            parameterTypes[i] = this.getRuntime().getJavaSupport().loadJavaClass(name);
        }
        return parameterTypes;
    }

    public JavaClass array_class() {
        return JavaClass.get(this.getRuntime(), Array.newInstance(this.javaClass(), 0).getClass());
    }

    public JavaObject new_array(IRubyObject lengthArgument) {
        if (!(lengthArgument instanceof RubyInteger)) {
            throw this.getRuntime().newTypeError(lengthArgument, this.getRuntime().getClass("Integer"));
        }
        int length = (int)((RubyInteger)lengthArgument).getLongValue();
        return new JavaArray(this.getRuntime(), Array.newInstance(this.javaClass(), length));
    }

    public RubyArray fields() {
        return this.buildFieldResults(this.javaClass().getFields());
    }

    public RubyArray declared_fields() {
        return this.buildFieldResults(this.javaClass().getDeclaredFields());
    }

    private RubyArray buildFieldResults(Field[] fields) {
        RubyArray result = this.getRuntime().newArray(fields.length);
        for (int i = 0; i < fields.length; ++i) {
            result.append(new JavaField(this.getRuntime(), fields[i]));
        }
        return result;
    }

    public JavaField field(IRubyObject name) {
        String stringName = name.asSymbol();
        try {
            Field field = this.javaClass().getField(stringName);
            return new JavaField(this.getRuntime(), field);
        }
        catch (NoSuchFieldException nsfe) {
            throw this.undefinedFieldError(stringName);
        }
    }

    public JavaField declared_field(IRubyObject name) {
        String stringName = name.asSymbol();
        try {
            Field field = this.javaClass().getDeclaredField(stringName);
            return new JavaField(this.getRuntime(), field);
        }
        catch (NoSuchFieldException nsfe) {
            throw this.undefinedFieldError(stringName);
        }
    }

    private RaiseException undefinedFieldError(String name) {
        return this.getRuntime().newNameError("undefined field '" + name + "' for class '" + this.javaClass().getName() + "'", name);
    }

    public RubyArray interfaces() {
        Class<?>[] interfaces = this.javaClass().getInterfaces();
        RubyArray result = this.getRuntime().newArray(interfaces.length);
        for (int i = 0; i < interfaces.length; ++i) {
            result.append(JavaClass.get(this.getRuntime(), interfaces[i]));
        }
        return result;
    }

    public RubyBoolean primitive_p() {
        return this.getRuntime().newBoolean(this.isPrimitive());
    }

    public RubyBoolean assignable_from_p(IRubyObject other) {
        if (!(other instanceof JavaClass)) {
            throw this.getRuntime().newTypeError("assignable_from requires JavaClass (" + other.getType() + " given)");
        }
        Class otherClass = ((JavaClass)other).javaClass();
        if (!this.javaClass().isPrimitive() && otherClass == Void.TYPE || this.javaClass().isAssignableFrom(otherClass)) {
            return this.getRuntime().getTrue();
        }
        otherClass = JavaUtil.primitiveToWrapper(otherClass);
        Class thisJavaClass = JavaUtil.primitiveToWrapper(this.javaClass());
        if (thisJavaClass.isAssignableFrom(otherClass)) {
            return this.getRuntime().getTrue();
        }
        if (Number.class.isAssignableFrom(thisJavaClass)) {
            if (Number.class.isAssignableFrom(otherClass)) {
                return this.getRuntime().getTrue();
            }
            if (otherClass.equals(Character.class)) {
                return this.getRuntime().getTrue();
            }
        }
        if (thisJavaClass.equals(Character.class) && Number.class.isAssignableFrom(otherClass)) {
            return this.getRuntime().getTrue();
        }
        return this.getRuntime().getFalse();
    }

    private boolean isPrimitive() {
        return this.javaClass().isPrimitive();
    }

    public JavaClass component_type() {
        if (!this.javaClass().isArray()) {
            throw this.getRuntime().newTypeError("not a java array-class");
        }
        return JavaClass.get(this.getRuntime(), this.javaClass().getComponentType());
    }
}

