/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.builtin.meta;

import org.jruby.IRuby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.runtime.Arity;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.builtin.meta.AbstractMetaClass;
import org.jruby.runtime.builtin.meta.ObjectMetaClass;
import org.jruby.util.collections.SinglyLinkedList;

public class ModuleMetaClass
extends ObjectMetaClass {
    public ModuleMetaClass(IRuby runtime, RubyClass superClass) {
        super(runtime, null, superClass, runtime.getObject().getCRef(), "Module", RubyModule.class);
    }

    public ModuleMetaClass(IRuby runtime) {
        super("Module", RubyModule.class, runtime.getObject());
    }

    public ModuleMetaClass(String name, RubyClass superClass, SinglyLinkedList parentCRef) {
        super(name, RubyModule.class, superClass, parentCRef);
    }

    protected ModuleMetaClass(String name, Class builtinClass, RubyClass superClass) {
        super(name, builtinClass, superClass);
    }

    protected ModuleMetaClass(String name, Class builtinClass, RubyClass superClass, SinglyLinkedList parentCRef) {
        super(name, builtinClass, superClass, parentCRef);
    }

    @Override
    protected AbstractMetaClass.Meta getMeta() {
        return new ModuleMeta();
    }

    @Override
    public RubyClass newSubClass(String name, SinglyLinkedList parentCRef) {
        return new ModuleMetaClass(name, (RubyClass)this, parentCRef);
    }

    @Override
    protected IRubyObject allocateObject() {
        RubyModule instance = RubyModule.newModule(this.getRuntime(), null);
        instance.setMetaClass(this);
        return instance;
    }

    protected void defineModuleFunction(String name, Arity arity) {
        this.definePrivateMethod(name, arity);
        this.defineSingletonMethod(name, arity);
    }

    protected void defineModuleFunction(String name, Arity arity, String javaName) {
        this.definePrivateMethod(name, arity, javaName);
        this.defineSingletonMethod(name, arity, javaName);
    }

    public RubyArray nesting() {
        IRuby runtime = this.getRuntime();
        RubyClass object = runtime.getObject();
        SinglyLinkedList base = runtime.getCurrentContext().peekCRef();
        RubyArray result = runtime.newArray();
        SinglyLinkedList current = base;
        while (current.getValue() != object) {
            result.append((RubyModule)current.getValue());
            current = current.getNext();
        }
        return result;
    }

    protected class ModuleMeta
    extends AbstractMetaClass.Meta {
        protected ModuleMeta() {
        }

        @Override
        public void initializeClass() {
            ModuleMetaClass.this.defineMethod("===", Arity.singleArgument(), "op_eqq");
            ModuleMetaClass.this.defineMethod("<=>", Arity.singleArgument(), "op_cmp");
            ModuleMetaClass.this.defineMethod("<", Arity.singleArgument(), "op_lt");
            ModuleMetaClass.this.defineMethod("<=", Arity.singleArgument(), "op_le");
            ModuleMetaClass.this.defineMethod(">", Arity.singleArgument(), "op_gt");
            ModuleMetaClass.this.defineMethod(">=", Arity.singleArgument(), "op_ge");
            ModuleMetaClass.this.defineMethod("ancestors", Arity.noArguments());
            ModuleMetaClass.this.defineMethod("class_variables", Arity.noArguments());
            ModuleMetaClass.this.defineMethod("clone", Arity.noArguments(), "rbClone");
            ModuleMetaClass.this.defineMethod("const_defined?", Arity.singleArgument(), "const_defined");
            ModuleMetaClass.this.defineMethod("const_get", Arity.singleArgument(), "const_get");
            ModuleMetaClass.this.defineMethod("const_missing", Arity.singleArgument());
            ModuleMetaClass.this.defineMethod("const_set", Arity.twoArguments());
            ModuleMetaClass.this.defineMethod("constants", Arity.noArguments());
            ModuleMetaClass.this.defineMethod("dup", Arity.noArguments());
            ModuleMetaClass.this.defineMethod("extended", Arity.singleArgument());
            ModuleMetaClass.this.defineMethod("included", Arity.singleArgument());
            ModuleMetaClass.this.defineMethod("included_modules", Arity.noArguments());
            ModuleMetaClass.this.defineMethod("initialize", Arity.optional());
            ModuleMetaClass.this.defineMethod("instance_method", Arity.singleArgument());
            ModuleMetaClass.this.defineMethod("instance_methods", Arity.optional());
            ModuleMetaClass.this.defineMethod("method_defined?", Arity.singleArgument(), "method_defined");
            ModuleMetaClass.this.defineMethod("module_eval", Arity.optional());
            ModuleMetaClass.this.defineMethod("name", Arity.noArguments());
            ModuleMetaClass.this.defineMethod("private_class_method", Arity.optional());
            ModuleMetaClass.this.defineMethod("private_instance_methods", Arity.optional());
            ModuleMetaClass.this.defineMethod("protected_instance_methods", Arity.optional());
            ModuleMetaClass.this.defineMethod("public_class_method", Arity.optional());
            ModuleMetaClass.this.defineMethod("public_instance_methods", Arity.optional());
            ModuleMetaClass.this.defineMethod("to_s", Arity.noArguments());
            ModuleMetaClass.this.defineAlias("class_eval", "module_eval");
            ModuleMetaClass.this.definePrivateMethod("alias_method", Arity.twoArguments());
            ModuleMetaClass.this.definePrivateMethod("append_features", Arity.singleArgument());
            ModuleMetaClass.this.definePrivateMethod("attr", Arity.optional());
            ModuleMetaClass.this.definePrivateMethod("attr_reader", Arity.optional());
            ModuleMetaClass.this.definePrivateMethod("attr_writer", Arity.optional());
            ModuleMetaClass.this.definePrivateMethod("attr_accessor", Arity.optional());
            ModuleMetaClass.this.definePrivateMethod("define_method", Arity.optional());
            ModuleMetaClass.this.definePrivateMethod("extend_object", Arity.singleArgument());
            ModuleMetaClass.this.definePrivateMethod("include", Arity.optional());
            ModuleMetaClass.this.definePrivateMethod("method_added", Arity.singleArgument());
            ModuleMetaClass.this.definePrivateMethod("module_function", Arity.optional());
            ModuleMetaClass.this.definePrivateMethod("public", Arity.optional(), "rbPublic");
            ModuleMetaClass.this.definePrivateMethod("protected", Arity.optional(), "rbProtected");
            ModuleMetaClass.this.definePrivateMethod("private", Arity.optional(), "rbPrivate");
            ModuleMetaClass.this.definePrivateMethod("remove_class_variable", Arity.singleArgument());
            ModuleMetaClass.this.definePrivateMethod("remove_const", Arity.singleArgument());
            ModuleMetaClass.this.definePrivateMethod("remove_method", Arity.singleArgument());
            ModuleMetaClass.this.definePrivateMethod("undef_method", Arity.singleArgument());
            ModuleMetaClass.this.defineSingletonMethod("nesting", Arity.noArguments());
        }
    }
}

