/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.jruby.Main;
import org.jruby.exceptions.MainExitException;

public class CommandlineParser {
    private final String[] arguments;
    private Main main;
    private ArrayList loadPaths = new ArrayList();
    private StringBuffer inlineScript = new StringBuffer();
    private String scriptFileName = null;
    private ArrayList requiredLibraries = new ArrayList();
    private boolean benchmarking = false;
    private boolean assumeLoop = false;
    private boolean assumePrinting = false;
    private boolean processLineEnds = false;
    private boolean split = false;
    private boolean verbose = false;
    private boolean debug = false;
    private boolean showVersion = false;
    private String[] scriptArguments = null;
    private boolean shouldRunInterpreter = true;
    private boolean objectSpaceEnabled = true;
    private boolean compilerEnabled = false;
    private String encoding = "ISO8859_1";
    public int argumentIndex = 0;
    public int characterIndex = 0;

    public CommandlineParser(Main main, String[] arguments) {
        this.arguments = arguments;
        this.main = main;
        this.processArguments();
    }

    private void processArguments() {
        while (this.argumentIndex < this.arguments.length && CommandlineParser.isInterpreterArgument(this.arguments[this.argumentIndex])) {
            this.processArgument();
            ++this.argumentIndex;
        }
        if (!this.hasInlineScript() && this.argumentIndex < this.arguments.length) {
            this.setScriptFileName(this.arguments[this.argumentIndex]);
            ++this.argumentIndex;
        }
        this.scriptArguments = new String[this.arguments.length - this.argumentIndex];
        System.arraycopy(this.arguments, this.argumentIndex, this.getScriptArguments(), 0, this.getScriptArguments().length);
    }

    private static boolean isInterpreterArgument(String argument) {
        return argument.charAt(0) == '-';
    }

    private void processArgument() {
        String argument = this.arguments[this.argumentIndex];
        this.characterIndex = 1;
        block18: while (this.characterIndex < argument.length()) {
            switch (argument.charAt(this.characterIndex)) {
                case 'h': {
                    this.main.printUsage();
                    this.shouldRunInterpreter = false;
                    break;
                }
                case 'I': {
                    String s = this.grabValue(" -I must be followed by a directory name to add to lib path");
                    String[] ls = s.split(":");
                    for (int i = 0; i < ls.length; ++i) {
                        this.loadPaths.add(ls[i]);
                    }
                    break block18;
                }
                case 'r': {
                    this.requiredLibraries.add(this.grabValue("-r must be followed by a package to require"));
                    break block18;
                }
                case 'e': {
                    this.inlineScript.append(this.grabValue(" -e must be followed by an expression to evaluate"));
                    this.inlineScript.append('\n');
                    break block18;
                }
                case 'b': {
                    this.benchmarking = true;
                    break;
                }
                case 'p': {
                    this.assumePrinting = true;
                    this.assumeLoop = true;
                    break;
                }
                case 'O': {
                    this.objectSpaceEnabled = false;
                    break;
                }
                case 'C': {
                    this.compilerEnabled = true;
                    break;
                }
                case 'n': {
                    this.assumeLoop = true;
                    break;
                }
                case 'a': {
                    this.split = true;
                    break;
                }
                case 'd': {
                    this.debug = true;
                    this.verbose = true;
                    break;
                }
                case 'l': {
                    this.processLineEnds = true;
                    break;
                }
                case 'v': {
                    this.verbose = true;
                    this.setShowVersion(true);
                    break;
                }
                case 'w': {
                    this.verbose = true;
                    break;
                }
                case 'K': {
                    String eArg = this.grabValue("provide a value for -K");
                    if (!"u".equals(eArg) && !"U".equals(eArg) && !"UTF8".equals(eArg)) break;
                    this.encoding = "UTF-8";
                    break;
                }
                case '-': {
                    if (argument.equals("--version")) {
                        this.setShowVersion(true);
                        break block18;
                    }
                    if (argument.equals("--debug")) {
                        this.debug = true;
                        this.verbose = true;
                        break;
                    }
                    if (argument.equals("--")) break block18;
                }
                default: {
                    throw new MainExitException(1, "unknown option " + argument.charAt(this.characterIndex));
                }
            }
            ++this.characterIndex;
        }
    }

    private String grabValue(String errorMessage) {
        ++this.characterIndex;
        if (this.characterIndex < this.arguments[this.argumentIndex].length()) {
            return this.arguments[this.argumentIndex].substring(this.characterIndex);
        }
        ++this.argumentIndex;
        if (this.argumentIndex < this.arguments.length) {
            return this.arguments[this.argumentIndex];
        }
        MainExitException mee = new MainExitException(1, "invalid argument " + this.argumentIndex + "\n" + errorMessage);
        mee.setUsageError(true);
        throw mee;
    }

    public boolean hasInlineScript() {
        return this.inlineScript.length() > 0;
    }

    public String inlineScript() {
        return this.inlineScript.toString();
    }

    public List requiredLibraries() {
        return this.requiredLibraries;
    }

    public List loadPaths() {
        return this.loadPaths;
    }

    public boolean shouldRunInterpreter() {
        return this.isShouldRunInterpreter();
    }

    private boolean isSourceFromStdin() {
        return this.getScriptFileName() == null;
    }

    public Reader getScriptSource() {
        try {
            if (this.hasInlineScript()) {
                return new StringReader(this.inlineScript());
            }
            if (this.isSourceFromStdin()) {
                return new InputStreamReader(System.in, this.encoding);
            }
            File file = new File(this.getScriptFileName());
            return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), this.encoding));
        }
        catch (IOException e) {
            throw new MainExitException(1, "Error opening script file: " + e.getMessage());
        }
    }

    public String displayedFileName() {
        if (this.hasInlineScript()) {
            return "-e";
        }
        if (this.isSourceFromStdin()) {
            return "-";
        }
        return this.getScriptFileName();
    }

    private void setScriptFileName(String scriptFileName) {
        this.scriptFileName = scriptFileName;
    }

    public String getScriptFileName() {
        return this.scriptFileName;
    }

    public boolean isBenchmarking() {
        return this.benchmarking;
    }

    public boolean isAssumeLoop() {
        return this.assumeLoop;
    }

    public boolean isAssumePrinting() {
        return this.assumePrinting;
    }

    public boolean isProcessLineEnds() {
        return this.processLineEnds;
    }

    public boolean isSplit() {
        return this.split;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isShowVersion() {
        return this.showVersion;
    }

    protected void setShowVersion(boolean showVersion) {
        this.showVersion = showVersion;
        this.shouldRunInterpreter = false;
    }

    public String[] getScriptArguments() {
        return this.scriptArguments;
    }

    public boolean isShouldRunInterpreter() {
        return this.shouldRunInterpreter;
    }

    public boolean isObjectSpaceEnabled() {
        return this.objectSpaceEnabled;
    }

    public boolean isCompilerEnabled() {
        return this.compilerEnabled;
    }

    public String getEncoding() {
        return this.encoding;
    }
}

