/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import org.jruby.IRuby;

public class IOModes
implements Cloneable {
    public static final int RDONLY = 0;
    public static final int WRONLY = 1;
    public static final int RDWR = 2;
    public static final int CREAT = 64;
    public static final int EXCL = 128;
    public static final int NOCTTY = 256;
    public static final int TRUNC = 512;
    public static final int APPEND = 1024;
    public static final int NONBLOCK = 2048;
    public static final int BINARY = 4096;
    private IRuby runtime;
    private int modes;

    public IOModes(IRuby runtime) {
        this.modes = 0;
        this.runtime = runtime;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            return null;
        }
    }

    public IOModes(IRuby runtime, String modesString) {
        this(runtime, IOModes.convertModesStringToModesInt(runtime, modesString));
    }

    public IOModes(IRuby runtime, long modes) {
        this.modes = (int)modes;
        this.runtime = runtime;
    }

    public boolean isReadable() {
        return (this.modes & 2) != 0 || this.modes == 0 || this.modes == 4096;
    }

    public boolean isWriteable() {
        return this.isWritable();
    }

    public boolean isBinary() {
        return (this.modes & 0x1000) == 4096;
    }

    public boolean isWritable() {
        return (this.modes & 2) != 0 || (this.modes & 1) != 0 || (this.modes & 0x40) != 0;
    }

    public boolean isAppendable() {
        return (this.modes & 0x400) != 0;
    }

    public boolean shouldTruncate() {
        return (this.modes & 0x200) != 0;
    }

    public void checkSubsetOf(IOModes superset) {
        if (!superset.isReadable() && this.isReadable() || !superset.isWriteable() && this.isWriteable() || !superset.isAppendable() && this.isAppendable()) {
            throw this.runtime.newErrnoEINVALError("bad permissions");
        }
    }

    public String toString() {
        return "" + this.modes;
    }

    public static int convertModesStringToModesInt(IRuby runtime, String modesString) {
        int modes = 0;
        if (modesString.length() == 0) {
            throw runtime.newArgumentError("illegal access mode");
        }
        switch (modesString.charAt(0)) {
            case 'r': {
                modes |= 0;
                break;
            }
            case 'a': {
                modes |= 0x400;
                modes |= 1;
                break;
            }
            case 'w': {
                modes |= 1;
                modes |= 0x200;
                break;
            }
            default: {
                throw runtime.newArgumentError("illegal access mode " + modes);
            }
        }
        if (modesString.length() > 1) {
            int i;
            int n = i = modesString.charAt(1) == 'b' ? 2 : 1;
            if (modesString.length() > i) {
                if (modesString.charAt(i) == '+') {
                    modes = (modes & 0x400) != 0 ? 1026 : ((modes & 1) != 0 ? 514 : 2);
                } else {
                    throw runtime.newArgumentError("illegal access mode " + modes);
                }
            }
            if (i == 2) {
                modes |= 0x1000;
            }
        }
        return modes;
    }
}

