/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import org.jruby.IRuby;
import org.jruby.RubyArray;
import org.jruby.RubyFloat;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.runtime.builtin.IRubyObject;

public class Pack {
    private static final String sSp10 = "          ";
    private static final String sNil10 = "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000";
    private static final int IS_STAR = -1;
    private static final String NATIVE_CODES = "sSiIlL";
    private static final String sTooFew = "too few arguments";
    private static final char[] hex_table;
    private static final char[] uu_table;
    private static final char[] b64_table;
    private static final int[] b64_xtable;
    private static final char[] sHexDigits;
    private static HashMap converters;

    private static StringBuffer encodes(IRuby runtime, StringBuffer io2Append, String i2Encode, int iLength, char iType) {
        char lNextChar;
        char lCurChar;
        char lPadding;
        iLength = iLength < i2Encode.length() ? iLength : i2Encode.length();
        io2Append.ensureCapacity(iLength * 4 / 3 + 6);
        int i = 0;
        char[] lTranslationTable = iType == 'u' ? uu_table : b64_table;
        char[] l2Encode = i2Encode.toCharArray();
        if (iType == 'u') {
            if (iLength >= lTranslationTable.length) {
                throw runtime.newArgumentError("" + iLength + " is not a correct value for the number of bytes per line in a u directive.  Correct values range from 0 to " + lTranslationTable.length);
            }
            io2Append.append(lTranslationTable[iLength]);
            lPadding = '`';
        } else {
            lPadding = '=';
        }
        while (iLength >= 3) {
            lCurChar = l2Encode[i++];
            lNextChar = l2Encode[i++];
            char lNextNextChar = l2Encode[i++];
            io2Append.append(lTranslationTable[0x3F & lCurChar >>> 2]);
            io2Append.append(lTranslationTable[0x3F & (lCurChar << 4 & 0x30 | lNextChar >>> 4 & 0xF)]);
            io2Append.append(lTranslationTable[0x3F & (lNextChar << 2 & 0x3C | lNextNextChar >>> 6 & 3)]);
            io2Append.append(lTranslationTable[0x3F & lNextNextChar]);
            iLength -= 3;
        }
        if (iLength == 2) {
            lCurChar = l2Encode[i++];
            lNextChar = l2Encode[i++];
            io2Append.append(lTranslationTable[0x3F & lCurChar >>> 2]);
            io2Append.append(lTranslationTable[0x3F & (lCurChar << 4 & 0x30 | lNextChar >> 4 & 0xF)]);
            io2Append.append(lTranslationTable[0x3F & (lNextChar << 2 & 0x3C | 0)]);
            io2Append.append(lPadding);
        } else if (iLength == 1) {
            lCurChar = l2Encode[i++];
            io2Append.append(lTranslationTable[0x3F & lCurChar >>> 2]);
            io2Append.append(lTranslationTable[0x3F & (lCurChar << 4 & 0x30 | 0)]);
            io2Append.append(lPadding);
            io2Append.append(lPadding);
        }
        io2Append.append('\n');
        return io2Append;
    }

    private static StringBuffer qpencode(StringBuffer io2Append, String i2Encode, int iLength) {
        io2Append.ensureCapacity(1024);
        int lCurLineLength = 0;
        int lPrevChar = -1;
        char[] l2Encode = i2Encode.toCharArray();
        try {
            int i = 0;
            while (true) {
                int lCurChar;
                if ((lCurChar = l2Encode[i]) > 126 || lCurChar < 32 && lCurChar != 10 && lCurChar != 9 || lCurChar == 61) {
                    io2Append.append('=');
                    io2Append.append(hex_table[lCurChar >> 4]);
                    io2Append.append(hex_table[lCurChar & 0xF]);
                    lCurLineLength += 3;
                    lPrevChar = -1;
                } else if (lCurChar == 10) {
                    if (lPrevChar == 32 || lPrevChar == 9) {
                        io2Append.append('=');
                        io2Append.append((char)lCurChar);
                    }
                    io2Append.append((char)lCurChar);
                    lCurLineLength = 0;
                    lPrevChar = lCurChar;
                } else {
                    io2Append.append((char)lCurChar);
                    ++lCurLineLength;
                    lPrevChar = lCurChar;
                }
                if (lCurLineLength > iLength) {
                    io2Append.append('=');
                    io2Append.append('\n');
                    lCurLineLength = 0;
                    lPrevChar = 10;
                }
                ++i;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            if (lCurLineLength > 0) {
                io2Append.append('=');
                io2Append.append('\n');
            }
            return io2Append;
        }
    }

    private static String convert2String(IRubyObject l2Conv) {
        IRuby runtime = l2Conv.getRuntime();
        if (l2Conv.getMetaClass() != runtime.getString()) {
            l2Conv = l2Conv.convertToType("String", "to_s", true);
        }
        return ((RubyString)l2Conv).toString();
    }

    /*
     * Unable to fully structure code
     */
    public static RubyArray unpack(String encodedString, RubyString formatString) {
        runtime = formatString.getRuntime();
        result = runtime.newArray();
        format = new PtrList(formatString.toString());
        encode = new PtrList(encodedString);
        type = format.nextChar();
        while (!format.isAtEnd()) {
            next = format.nextChar();
            if (next == '_' || next == '!') {
                if ("sSiIlL".indexOf(type) == -1) {
                    throw runtime.newArgumentError("'" + next + "' allowed only after types " + "sSiIlL");
                }
                next = format.nextChar();
            }
            occurrences = 0;
            if (format.isAtEnd()) {
                occurrences = 1;
            } else if (next == '*') {
                occurrences = -1;
                next = format.nextChar();
            } else if (Character.isDigit(next)) {
                format.backup(1);
                occurrences = format.nextAsciiNumber();
                next = format.nextChar();
            } else {
                occurrences = type == '@' ? 0 : 1;
            }
            converter = (Converter)Pack.converters.get(new Character(type));
            if (converter != null) {
                Pack.decode(runtime, encode, occurrences, result, converter);
                type = next;
                continue;
            }
            switch (type) {
                case '@': {
                    encode.setPosition(occurrences);
                    break;
                }
                case '%': {
                    throw runtime.newArgumentError("% is not supported");
                }
                case 'A': {
                    if (occurrences == -1 || occurrences > encode.remaining()) {
                        occurrences = encode.remaining();
                    }
                    potential = encode.nextSubstring(occurrences);
                    t = occurrences - 1;
                    while (occurrences > 0 && ((c = potential.charAt(t)) == '\u0000' || c == ' ')) {
                        --occurrences;
                        --t;
                    }
                    potential = potential.substring(0, occurrences);
                    result.append(runtime.newString(potential));
                    break;
                }
                case 'Z': {
                    if (occurrences == -1 || occurrences > encode.remaining()) {
                        occurrences = encode.remaining();
                    }
                    potential = encode.nextSubstring(occurrences);
                    t = occurrences - 1;
                    while (occurrences > 0 && (c = potential.charAt(t)) == '\u0000') {
                        --occurrences;
                        --t;
                    }
                    potential = potential.substring(0, occurrences);
                    result.append(runtime.newString(potential));
                    break;
                }
                case 'a': {
                    if (occurrences == -1 || occurrences > encode.remaining()) {
                        occurrences = encode.remaining();
                    }
                    result.append(runtime.newString(encode.nextSubstring(occurrences)));
                    break;
                }
                case 'b': {
                    if (occurrences == -1 || occurrences > encode.remaining() * 8) {
                        occurrences = encode.remaining() * 8;
                    }
                    bits = 0;
                    lElem = new StringBuffer(occurrences);
                    for (lCurByte = 0; lCurByte < occurrences; ++lCurByte) {
                        bits = (lCurByte & 7) != 0 ? (bits >>>= 1) : (int)encode.nextChar();
                        lElem.append((bits & 1) != 0 ? '1' : '0');
                    }
                    result.append(runtime.newString(lElem.toString()));
                    break;
                }
                case 'B': {
                    if (occurrences == -1 || occurrences > encode.remaining() * 8) {
                        occurrences = encode.remaining() * 8;
                    }
                    bits = 0;
                    lElem = new StringBuffer(occurrences);
                    for (lCurByte = 0; lCurByte < occurrences; ++lCurByte) {
                        bits = (lCurByte & 7) != 0 ? (bits <<= 1) : (int)encode.nextChar();
                        lElem.append((bits & 128) != 0 ? '1' : '0');
                    }
                    result.append(runtime.newString(lElem.toString()));
                    break;
                }
                case 'h': {
                    if (occurrences == -1 || occurrences > encode.remaining() * 2) {
                        occurrences = encode.remaining() * 2;
                    }
                    bits = 0;
                    lElem = new StringBuffer(occurrences);
                    for (lCurByte = 0; lCurByte < occurrences; ++lCurByte) {
                        bits = (lCurByte & 1) != 0 ? (bits >>>= 4) : (int)encode.nextChar();
                        lElem.append(Pack.sHexDigits[bits & 15]);
                    }
                    result.append(runtime.newString(lElem.toString()));
                    break;
                }
                case 'H': {
                    if (occurrences == -1 || occurrences > encode.remaining() * 2) {
                        occurrences = encode.remaining() * 2;
                    }
                    bits = 0;
                    lElem = new StringBuffer(occurrences);
                    for (lCurByte = 0; lCurByte < occurrences; ++lCurByte) {
                        bits = (lCurByte & 1) != 0 ? (bits <<= 4) : (int)encode.nextChar();
                        lElem.append(Pack.sHexDigits[bits >>> 4 & 15]);
                    }
                    result.append(runtime.newString(lElem.toString()));
                    break;
                }
                case 'u': {
                    length = encode.remaining() * 3 / 4;
                    lElem = new StringBuffer(length);
                    total = 0;
                    s = encode.nextChar();
                    while (!encode.isAtEnd() && s > ' ' && s < 'a') {
                        hunk = new char[3];
                        len = s - 32 & 63;
                        s = encode.nextChar();
                        if ((total += len) > length) {
                            len -= total - length;
                            total = length;
                        }
                        while (len > 0) {
                            v0 = mlen = len > 3 ? 3 : len;
                            if (!encode.isAtEnd() && s >= ' ') {
                                a = s - 32 & 63;
                                s = encode.nextChar();
                            } else {
                                a = 0;
                            }
                            if (!encode.isAtEnd() && s >= ' ') {
                                b = s - 32 & 63;
                                s = encode.nextChar();
                            } else {
                                b = 0;
                            }
                            if (!encode.isAtEnd() && s >= ' ') {
                                c = s - 32 & 63;
                                s = encode.nextChar();
                            } else {
                                c = 0;
                            }
                            if (!encode.isAtEnd() && s >= ' ') {
                                d = s - 32 & 63;
                                s = encode.nextChar();
                            } else {
                                d = 0;
                            }
                            hunk[0] = (char)((a << 2 | b >> 4) & 255);
                            hunk[1] = (char)((b << 4 | c >> 2) & 255);
                            hunk[2] = (char)((c << 6 | d) & 255);
                            lElem.append(hunk, 0, mlen);
                            len -= mlen;
                        }
                        if (s == '\r') {
                            s = encode.nextChar();
                        }
                        if (s == '\n') {
                            s = encode.nextChar();
                            continue;
                        }
                        if (encode.isAtEnd()) continue;
                        if (encode.nextChar() == '\n') {
                            encode.nextChar();
                            continue;
                        }
                        if (encode.isAtEnd()) continue;
                        encode.backup(1);
                    }
                    result.append(runtime.newString(lElem.toString()));
                    break;
                }
                case 'm': {
                    length = encode.remaining() * 3 / 4;
                    lElem = new StringBuffer(length);
                    a = -1;
                    b = -1;
                    c = 0;
                    while (!encode.isAtEnd()) {
                        while ((s = encode.nextChar()) == '\r' || s == '\n') {
                        }
                        a = Pack.b64_xtable[s];
                        if (a == -1 || (b = Pack.b64_xtable[s = encode.nextChar()]) == -1 || (c = Pack.b64_xtable[s = encode.nextChar()]) == -1 || (d = Pack.b64_xtable[s = encode.nextChar()]) == -1) break;
                        lElem.append((char)((a << 2 | b >> 4) & 255));
                        lElem.append((char)((b << 4 | c >> 2) & 255));
                        lElem.append((char)((c << 6 | d) & 255));
                        a = -1;
                    }
                    if (a != -1 && b != -1) {
                        lElem.append((char)((a << 2 | b >> 4) & 255));
                        if (c != -1) {
                            lElem.append((char)((b << 4 | c >> 2) & 255));
                        }
                    }
                    result.append(runtime.newString(lElem.toString()));
                    break;
                }
                case 'M': {
                    lElem = new StringBuffer(Math.max(encode.remaining(), 0));
                    while (true) {
                        c = encode.nextChar();
                        if (encode.isAtEnd()) break;
                        if (c != '=') {
                            lElem.append(c);
                            continue;
                        }
                        c1 = encode.nextChar();
                        if (encode.isAtEnd()) break;
                        if (c1 == '\n') continue;
                        c2 = encode.nextChar();
                        if (encode.isAtEnd()) break;
                        hexString = new String(new char[]{c1, c2});
                        value = Integer.parseInt(hexString, 16);
                        lElem.append((char)value);
                    }
                    result.append(runtime.newString(lElem.toString()));
                    break;
                }
                case 'U': {
                    if (occurrences == -1 || occurrences > encode.remaining()) {
                        occurrences = encode.remaining();
                    }
                    toUnpack = encode.nextSubstring(occurrences);
                    lUtf8 = null;
                    try {
                        lUtf8 = new String(toUnpack.getBytes("ISO8859_1"), "UTF8");
                    }
                    catch (UnsupportedEncodingException e) {
                        if (Pack.$assertionsDisabled) ** GOTO lbl239
                        throw new AssertionError((Object)"can't convert from UTF8");
                    }
lbl239:
                    // 2 sources

                    c = lUtf8.toCharArray();
                    for (lCurCharIdx = 0; occurrences-- > 0 && lCurCharIdx < c.length; ++lCurCharIdx) {
                        result.append(runtime.newFixnum(c[lCurCharIdx]));
                    }
                    break;
                }
                case 'X': {
                    if (occurrences == -1) {
                        occurrences = encode.getLength() - encode.remaining();
                    }
                    try {
                        encode.backup(occurrences);
                        break;
                    }
                    catch (IllegalArgumentException e) {
                        throw runtime.newArgumentError("in `unpack': X outside of string");
                    }
                }
                case 'x': {
                    if (occurrences == -1) {
                        occurrences = encode.remaining();
                    }
                    try {
                        encode.nextSubstring(occurrences);
                        break;
                    }
                    catch (IllegalArgumentException e) {
                        throw runtime.newArgumentError("in `unpack': x outside of string");
                    }
                }
            }
            type = next;
        }
        return result;
    }

    public static void decode(IRuby runtime, PtrList encode, int occurrences, RubyArray result, Converter converter) {
        int lPadLength = 0;
        if (occurrences == -1) {
            occurrences = encode.remaining() / converter.size;
        } else if (occurrences > encode.remaining() / converter.size) {
            lPadLength = occurrences - encode.remaining() / converter.size;
            occurrences = encode.remaining() / converter.size;
        }
        while (occurrences-- > 0) {
            result.append(converter.decode(runtime, encode));
        }
        while (lPadLength-- > 0) {
            result.append(runtime.getNil());
        }
    }

    public static int encode(IRuby runtime, int occurrences, StringBuffer result, List list, int index, Converter converter) {
        int listSize = list.size();
        while (occurrences-- > 0) {
            if (listSize-- <= 0) {
                throw runtime.newArgumentError(sTooFew);
            }
            IRubyObject from = (IRubyObject)list.get(index++);
            converter.encode(runtime, from, result);
        }
        return index;
    }

    private static final StringBuffer shrink(StringBuffer i2Shrink, int iLength) {
        iLength = i2Shrink.length() - iLength;
        if (iLength < 0) {
            throw new IllegalArgumentException();
        }
        i2Shrink.setLength(iLength);
        return i2Shrink;
    }

    private static final StringBuffer grow(StringBuffer i2Grow, String iPads, int iLength) {
        int lPadLength = iPads.length();
        while (iLength >= lPadLength) {
            i2Grow.append(iPads);
            iLength -= lPadLength;
        }
        i2Grow.append(iPads.substring(0, iLength));
        return i2Grow;
    }

    public static RubyString pack(List list, RubyString formatString) {
        IRuby runtime = formatString.getRuntime();
        PtrList format = new PtrList(formatString.toString());
        StringBuffer result = new StringBuffer();
        int listSize = list.size();
        char type = format.nextChar();
        int idx = 0;
        while (!format.isAtEnd()) {
            char next = format.nextChar();
            if (Character.isWhitespace(type)) {
                type = next;
                continue;
            }
            if (next == '!' || next == '_') {
                if (NATIVE_CODES.indexOf(type) == -1) {
                    throw runtime.newArgumentError("'" + next + "' allowed only after types " + NATIVE_CODES);
                }
                next = format.nextChar();
            }
            boolean isStar = false;
            int occurrences = 1;
            if (next == '*') {
                if ("@Xxu".indexOf(type) != -1) {
                    occurrences = 0;
                } else {
                    occurrences = listSize;
                    isStar = true;
                }
                next = format.nextChar();
            } else if (Character.isDigit(next)) {
                format.backup(1);
                occurrences = format.nextAsciiNumber();
                next = format.nextChar();
            }
            Converter converter = (Converter)converters.get(new Character(type));
            if (converter != null) {
                idx = Pack.encode(runtime, occurrences, result, list, idx, converter);
                type = next;
                continue;
            }
            block2 : switch (type) {
                case '%': {
                    throw runtime.newArgumentError("% is not supported");
                }
                case 'A': 
                case 'B': 
                case 'H': 
                case 'Z': 
                case 'a': 
                case 'b': 
                case 'h': {
                    IRubyObject from;
                    String lCurElemString;
                    if (listSize-- <= 0) {
                        throw runtime.newArgumentError(sTooFew);
                    }
                    String string = lCurElemString = (from = (IRubyObject)list.get(idx++)) == runtime.getNil() ? "" : Pack.convert2String(from);
                    if (isStar) {
                        occurrences = lCurElemString.length();
                    }
                    switch (type) {
                        case 'A': 
                        case 'Z': 
                        case 'a': {
                            if (lCurElemString.length() >= occurrences) {
                                result.append(lCurElemString.toCharArray(), 0, occurrences);
                                break;
                            }
                            result.append(lCurElemString);
                            Pack.grow(result, type == 'a' ? sNil10 : sSp10, occurrences -= lCurElemString.length());
                            break;
                        }
                        case 'b': {
                            int currentByte = 0;
                            int padLength = 0;
                            if (occurrences > lCurElemString.length()) {
                                padLength = occurrences - lCurElemString.length();
                                occurrences = lCurElemString.length();
                            }
                            int i = 0;
                            while (i < occurrences) {
                                if ((lCurElemString.charAt(i++) & '\u0001') != 0) {
                                    currentByte |= 0x80;
                                }
                                if ((i & 7) == 0) {
                                    result.append((char)(currentByte & 0xFF));
                                    currentByte = 0;
                                    continue;
                                }
                                currentByte >>= 1;
                            }
                            if ((occurrences & 7) != 0) {
                                result.append((char)((currentByte >>= 7 - (occurrences & 7)) & 0xFF));
                            }
                            result.setLength(result.length() + padLength);
                            break;
                        }
                        case 'B': {
                            int currentByte = 0;
                            int padLength = 0;
                            if (occurrences > lCurElemString.length()) {
                                padLength = occurrences - lCurElemString.length();
                                occurrences = lCurElemString.length();
                            }
                            int i = 0;
                            while (i < occurrences) {
                                currentByte |= lCurElemString.charAt(i++) & '\u0001';
                                if ((i & 7) == 0) {
                                    result.append((char)(currentByte & 0xFF));
                                    currentByte = 0;
                                    continue;
                                }
                                currentByte <<= 1;
                            }
                            if ((occurrences & 7) != 0) {
                                result.append((char)((currentByte <<= 7 - (occurrences & 7)) & 0xFF));
                            }
                            result.setLength(result.length() + padLength);
                            break;
                        }
                        case 'h': {
                            char currentChar;
                            int currentByte = 0;
                            int padLength = 0;
                            if (occurrences > lCurElemString.length()) {
                                padLength = occurrences - lCurElemString.length();
                                occurrences = lCurElemString.length();
                            }
                            int i = 0;
                            while (i < occurrences) {
                                currentByte = Character.isJavaIdentifierStart(currentChar = lCurElemString.charAt(i++)) ? (currentByte |= ((currentChar & 0xF) + 9 & 0xF) << 4) : (currentByte |= (currentChar & 0xF) << 4);
                                if ((i & 1) != 0) {
                                    currentByte >>= 4;
                                    continue;
                                }
                                result.append((char)(currentByte & 0xFF));
                                currentByte = 0;
                            }
                            if ((occurrences & 1) != 0) {
                                result.append((char)(currentByte & 0xFF));
                            }
                            result.setLength(result.length() + padLength);
                            break;
                        }
                        case 'H': {
                            char currentChar;
                            int currentByte = 0;
                            int padLength = 0;
                            if (occurrences > lCurElemString.length()) {
                                padLength = occurrences - lCurElemString.length();
                                occurrences = lCurElemString.length();
                            }
                            int i = 0;
                            while (i < occurrences) {
                                currentByte = Character.isJavaIdentifierStart(currentChar = lCurElemString.charAt(i++)) ? (currentByte |= (currentChar & 0xF) + 9 & 0xF) : (currentByte |= currentChar & 0xF);
                                if ((i & 1) != 0) {
                                    currentByte <<= 4;
                                    continue;
                                }
                                result.append((char)(currentByte & 0xFF));
                                currentByte = 0;
                            }
                            if ((occurrences & 1) != 0) {
                                result.append((char)(currentByte & 0xFF));
                            }
                            result.setLength(result.length() + padLength);
                        }
                    }
                    break;
                }
                case 'x': {
                    Pack.grow(result, sNil10, occurrences);
                    break;
                }
                case 'X': {
                    try {
                        Pack.shrink(result, occurrences);
                        break;
                    }
                    catch (IllegalArgumentException e) {
                        throw runtime.newArgumentError("in `pack': X outside of string");
                    }
                }
                case '@': {
                    if ((occurrences -= result.length()) > 0) {
                        Pack.grow(result, sNil10, occurrences);
                    }
                    if ((occurrences = -occurrences) <= 0) break;
                    Pack.shrink(result, occurrences);
                    break;
                }
                case 'm': 
                case 'u': {
                    IRubyObject from;
                    if (listSize-- <= 0) {
                        throw runtime.newArgumentError(sTooFew);
                    }
                    String lCurElemString = (from = (IRubyObject)list.get(idx++)) == runtime.getNil() ? "" : Pack.convert2String(from);
                    occurrences = occurrences <= 2 ? 45 : occurrences / 3 * 3;
                    while (true) {
                        Pack.encodes(runtime, result, lCurElemString, occurrences, type);
                        if (occurrences >= lCurElemString.length()) break block2;
                        lCurElemString = lCurElemString.substring(occurrences);
                    }
                }
                case 'M': {
                    IRubyObject from;
                    String lCurElemString;
                    if (listSize-- <= 0) {
                        throw runtime.newArgumentError(sTooFew);
                    }
                    String string = lCurElemString = (from = (IRubyObject)list.get(idx++)) == runtime.getNil() ? "" : Pack.convert2String(from);
                    if (occurrences <= 1) {
                        occurrences = 72;
                    }
                    Pack.qpencode(result, lCurElemString, occurrences);
                    break;
                }
                case 'U': {
                    char[] c = new char[occurrences];
                    int cIndex = 0;
                    while (occurrences-- > 0) {
                        IRubyObject from;
                        if (listSize-- <= 0) {
                            throw runtime.newArgumentError(sTooFew);
                        }
                        long l = (from = (IRubyObject)list.get(idx++)) == runtime.getNil() ? 0L : RubyNumeric.num2long(from);
                        c[cIndex] = (char)l;
                        ++cIndex;
                    }
                    try {
                        byte[] bytes = new String(c).getBytes("UTF8");
                        result.append(RubyString.bytesToString(bytes));
                        break;
                    }
                    catch (UnsupportedEncodingException e) {
                        assert (false) : "can't convert to UTF8";
                        break;
                    }
                }
            }
            type = next;
        }
        return runtime.newString(result.toString());
    }

    private static int decodeIntLittleEndian(PtrList encode) {
        return encode.nextByte() + (encode.nextByte() << 8) + (encode.nextByte() << 16) + (encode.nextByte() << 24);
    }

    private static int decodeIntBigEndian(PtrList encode) {
        return (encode.nextByte() << 24) + (encode.nextByte() << 16) + (encode.nextByte() << 8) + encode.nextByte();
    }

    private static long decodeIntUnsignedBigEndian(PtrList encode) {
        return ((long)encode.nextByte() << 24) + ((long)encode.nextByte() << 16) + ((long)encode.nextByte() << 8) + (long)encode.nextByte();
    }

    private static long decodeIntUnsignedLittleEndian(PtrList encode) {
        return (long)encode.nextByte() + ((long)encode.nextByte() << 8) + ((long)encode.nextByte() << 16) + ((long)encode.nextByte() << 24);
    }

    private static void encodeIntLittleEndian(StringBuffer result, int s) {
        result.append((char)(s & 0xFF)).append((char)(s >> 8 & 0xFF));
        result.append((char)(s >> 16 & 0xFF)).append((char)(s >> 24 & 0xFF));
    }

    private static void encodeIntBigEndian(StringBuffer result, int s) {
        result.append((char)(s >> 24 & 0xFF)).append((char)(s >> 16 & 0xFF));
        result.append((char)(s >> 8 & 0xFF)).append((char)(s & 0xFF));
    }

    private static long decodeLongBigEndian(PtrList encode) {
        int c1 = Pack.decodeIntBigEndian(encode);
        int c2 = Pack.decodeIntBigEndian(encode);
        return ((long)c1 << 32) + ((long)c2 & 0xFFFFFFFFL);
    }

    private static long decodeLongLittleEndian(PtrList encode) {
        int c1 = Pack.decodeIntLittleEndian(encode);
        int c2 = Pack.decodeIntLittleEndian(encode);
        return ((long)c2 << 32) + ((long)c1 & 0xFFFFFFFFL);
    }

    private static void encodeLongLittleEndian(StringBuffer result, long l) {
        Pack.encodeIntLittleEndian(result, (int)(l & 0xFFFFFFFFFFFFFFFFL));
        Pack.encodeIntLittleEndian(result, (int)(l >>> 32));
    }

    private static void encodeLongBigEndian(StringBuffer result, long l) {
        Pack.encodeIntBigEndian(result, (int)(l >>> 32));
        Pack.encodeIntBigEndian(result, (int)(l & 0xFFFFFFFFFFFFFFFFL));
    }

    private static double decodeDoubleLittleEndian(PtrList encode) {
        return Double.longBitsToDouble(Pack.decodeLongLittleEndian(encode));
    }

    private static double decodeDoubleBigEndian(PtrList encode) {
        return Double.longBitsToDouble(Pack.decodeLongBigEndian(encode));
    }

    private static void encodeDoubleLittleEndian(StringBuffer result, double d) {
        Pack.encodeLongLittleEndian(result, Double.doubleToLongBits(d));
    }

    private static void encodeDoubleBigEndian(StringBuffer result, double d) {
        Pack.encodeLongBigEndian(result, Double.doubleToLongBits(d));
    }

    private static float decodeFloatBigEndian(PtrList encode) {
        return Float.intBitsToFloat(Pack.decodeIntBigEndian(encode));
    }

    private static float decodeFloatLittleEndian(PtrList encode) {
        return Float.intBitsToFloat(Pack.decodeIntLittleEndian(encode));
    }

    private static void encodeFloatLittleEndian(StringBuffer result, float f) {
        Pack.encodeIntLittleEndian(result, Float.floatToIntBits(f));
    }

    private static void encodeFloatBigEndian(StringBuffer result, float f) {
        Pack.encodeIntBigEndian(result, Float.floatToIntBits(f));
    }

    private static int decodeShortUnsignedLittleEndian(PtrList encode) {
        return encode.nextByte() + (encode.nextByte() << 8);
    }

    private static int decodeShortUnsignedBigEndian(PtrList encode) {
        return (encode.nextByte() << 8) + encode.nextByte();
    }

    private static short decodeShortBigEndian(PtrList encode) {
        return (short)((short)(encode.nextByte() << 8) + encode.nextByte());
    }

    private static void encodeShortLittleEndian(StringBuffer result, int s) {
        result.append((char)(s & 0xFF)).append((char)((s & 0xFF00) >> 8));
    }

    private static void encodeShortBigEndian(StringBuffer result, int s) {
        result.append((char)((s & 0xFF00) >> 8)).append((char)(s & 0xFF));
    }

    static {
        int i;
        hex_table = "0123456789ABCDEF".toCharArray();
        uu_table = "`!\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_".toCharArray();
        b64_table = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
        b64_xtable = new int[256];
        sHexDigits = "0123456789abcdef0123456789ABCDEFx".toCharArray();
        converters = new HashMap();
        for (i = 0; i < 256; ++i) {
            Pack.b64_xtable[i] = -1;
        }
        for (i = 0; i < 64; ++i) {
            Pack.b64_xtable[Pack.b64_table[i]] = i;
        }
        converters.put(new Character('v'), new Converter(2){

            @Override
            public IRubyObject decode(IRuby runtime, PtrList enc) {
                return runtime.newFixnum(Pack.decodeShortUnsignedLittleEndian(enc));
            }

            @Override
            public void encode(IRuby runtime, IRubyObject o, StringBuffer result) {
                int s = o == runtime.getNil() ? 0 : (int)(RubyNumeric.num2long(o) & 0xFFFFL);
                Pack.encodeShortLittleEndian(result, s);
            }
        });
        converters.put(new Character('e'), new Converter(4){

            @Override
            public IRubyObject decode(IRuby runtime, PtrList enc) {
                return RubyFloat.newFloat(runtime, Pack.decodeFloatLittleEndian(enc));
            }

            @Override
            public void encode(IRuby runtime, IRubyObject o, StringBuffer result) {
                float f = o == runtime.getNil() ? 0.0f : (float)o.convertToFloat().getDoubleValue();
                Pack.encodeFloatLittleEndian(result, f);
            }
        });
        Converter tmp = new Converter(4){

            @Override
            public IRubyObject decode(IRuby runtime, PtrList enc) {
                return RubyFloat.newFloat(runtime, Pack.decodeFloatBigEndian(enc));
            }

            @Override
            public void encode(IRuby runtime, IRubyObject o, StringBuffer result) {
                float f = o == runtime.getNil() ? 0.0f : (float)o.convertToFloat().getDoubleValue();
                Pack.encodeFloatBigEndian(result, f);
            }
        };
        converters.put(new Character('f'), tmp);
        converters.put(new Character('g'), tmp);
        converters.put(new Character('E'), new Converter(8){

            @Override
            public IRubyObject decode(IRuby runtime, PtrList enc) {
                return RubyFloat.newFloat(runtime, Pack.decodeDoubleLittleEndian(enc));
            }

            @Override
            public void encode(IRuby runtime, IRubyObject o, StringBuffer result) {
                double d = o == runtime.getNil() ? 0.0 : o.convertToFloat().getDoubleValue();
                Pack.encodeDoubleLittleEndian(result, d);
            }
        });
        tmp = new Converter(8){

            @Override
            public IRubyObject decode(IRuby runtime, PtrList enc) {
                return RubyFloat.newFloat(runtime, Pack.decodeDoubleBigEndian(enc));
            }

            @Override
            public void encode(IRuby runtime, IRubyObject o, StringBuffer result) {
                double d = o == runtime.getNil() ? 0.0 : o.convertToFloat().getDoubleValue();
                Pack.encodeDoubleBigEndian(result, d);
            }
        };
        converters.put(new Character('d'), tmp);
        converters.put(new Character('G'), tmp);
        converters.put(new Character('s'), new Converter(2){

            @Override
            public IRubyObject decode(IRuby runtime, PtrList enc) {
                return runtime.newFixnum(Pack.decodeShortBigEndian(enc));
            }

            @Override
            public void encode(IRuby runtime, IRubyObject o, StringBuffer result) {
                int s = o == runtime.getNil() ? 0 : (int)(RubyNumeric.num2long(o) & 0xFFFFL);
                Pack.encodeShortBigEndian(result, s);
            }
        });
        tmp = new Converter(2){

            @Override
            public IRubyObject decode(IRuby runtime, PtrList enc) {
                return runtime.newFixnum(Pack.decodeShortUnsignedBigEndian(enc));
            }

            @Override
            public void encode(IRuby runtime, IRubyObject o, StringBuffer result) {
                int s = o == runtime.getNil() ? 0 : (int)(RubyNumeric.num2long(o) & 0xFFFFL);
                Pack.encodeShortBigEndian(result, s);
            }
        };
        converters.put(new Character('S'), tmp);
        converters.put(new Character('n'), tmp);
        converters.put(new Character('c'), new Converter(1){

            @Override
            public IRubyObject decode(IRuby runtime, PtrList enc) {
                char c = enc.nextChar();
                return runtime.newFixnum(c > '\u007f' ? (long)(c - 256) : (long)c);
            }

            @Override
            public void encode(IRuby runtime, IRubyObject o, StringBuffer result) {
                char c = o == runtime.getNil() ? (char)'\u0000' : (char)(RubyNumeric.num2long(o) & 0xFFL);
                result.append(c);
            }
        });
        converters.put(new Character('C'), new Converter(1){

            @Override
            public IRubyObject decode(IRuby runtime, PtrList enc) {
                return runtime.newFixnum(enc.nextChar());
            }

            @Override
            public void encode(IRuby runtime, IRubyObject o, StringBuffer result) {
                char c = o == runtime.getNil() ? (char)'\u0000' : (char)(RubyNumeric.num2long(o) & 0xFFL);
                result.append(c);
            }
        });
        converters.put(new Character('V'), new Converter(4){

            @Override
            public IRubyObject decode(IRuby runtime, PtrList enc) {
                return runtime.newFixnum(Pack.decodeIntUnsignedLittleEndian(enc));
            }

            @Override
            public void encode(IRuby runtime, IRubyObject o, StringBuffer result) {
                int s = o == runtime.getNil() ? 0 : (int)RubyNumeric.num2long(o);
                Pack.encodeIntLittleEndian(result, s);
            }
        });
        tmp = new Converter(4){

            @Override
            public IRubyObject decode(IRuby runtime, PtrList enc) {
                return runtime.newFixnum(Pack.decodeIntUnsignedBigEndian(enc));
            }

            @Override
            public void encode(IRuby runtime, IRubyObject o, StringBuffer result) {
                int s = o == runtime.getNil() ? 0 : (int)RubyNumeric.num2long(o);
                Pack.encodeIntBigEndian(result, s);
            }
        };
        converters.put(new Character('I'), tmp);
        converters.put(new Character('L'), tmp);
        converters.put(new Character('N'), tmp);
        tmp = new Converter(4){

            @Override
            public IRubyObject decode(IRuby runtime, PtrList enc) {
                return runtime.newFixnum(Pack.decodeIntBigEndian(enc));
            }

            @Override
            public void encode(IRuby runtime, IRubyObject o, StringBuffer result) {
                int s = o == runtime.getNil() ? 0 : (int)RubyNumeric.num2long(o);
                Pack.encodeIntBigEndian(result, s);
            }
        };
        converters.put(new Character('l'), tmp);
        converters.put(new Character('i'), tmp);
    }

    static class PtrList {
        private char[] buffer;
        private int index;

        public PtrList(String bufferString) {
            this.buffer = bufferString.toCharArray();
            this.index = 0;
        }

        public int remaining() {
            return this.buffer.length - this.index;
        }

        public String nextSubstring(int length) {
            if (this.index + length > this.buffer.length) {
                throw new IllegalArgumentException();
            }
            String substring = new String(this.buffer, this.index, length);
            this.index += length;
            return substring;
        }

        public void setPosition(int position) {
            if (position < this.buffer.length) {
                this.index = position;
            }
        }

        public int nextAsciiNumber() {
            int i;
            for (i = this.index; i < this.buffer.length && Character.isDigit(this.buffer[i]); ++i) {
            }
            int number = Integer.parseInt(new String(this.buffer, this.index, i - this.index));
            this.index = i;
            return number;
        }

        public int getLength() {
            return this.buffer.length;
        }

        public char nextChar() {
            char next = '\u0000';
            if (this.index < this.buffer.length) {
                next = this.buffer[this.index++];
            } else if (this.index == this.buffer.length) {
                ++this.index;
            }
            return next;
        }

        public int nextByte() {
            return this.nextChar() & 0xFF;
        }

        public void backup(int occurrences) {
            this.index -= occurrences;
            if (this.index < 0) {
                throw new IllegalArgumentException();
            }
        }

        public boolean isAtEnd() {
            return this.index > this.buffer.length;
        }

        public int getIndex() {
            return this.index;
        }
    }

    public static abstract class Converter {
        public int size;

        public Converter(int size) {
            this.size = size;
        }

        public abstract IRubyObject decode(IRuby var1, PtrList var2);

        public abstract void encode(IRuby var1, IRubyObject var2, StringBuffer var3);
    }
}

