package com.ociweb;

import java.awt.Color;
import java.awt.event.ActionEvent;

import javax.swing.JEditorPane;
import javax.swing.UIManager;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledEditorKit;

public class BackgroundAction extends StyledEditorKit.StyledTextAction {
	private Color bg;

	public BackgroundAction(String nm, Color bg) {
		super(nm);
		this.bg = bg;
	}

	public void actionPerformed(ActionEvent e) {
		JEditorPane editor = getEditor(e);
		if (editor != null) {
			Color bg = this.bg;
			if ((e != null) && (e.getSource() == editor)) {
				String s = e.getActionCommand();
				try {
					bg = Color.decode(s);
				} catch (NumberFormatException nfe) {
				}
			}
			if (bg != null) {
				MutableAttributeSet attr = new SimpleAttributeSet();
				StyleConstants.setBackground(attr, bg);
				setCharacterAttributes(editor, attr, false);
			} else {
				UIManager.getLookAndFeel().provideErrorFeedback(editor);
			}
		}
	}
}