require 'java'
require 'text_dsl'
include_class 'java.awt.Color'
include_class 'java.awt.event.ActionEvent'

class UI < Text
  
  def initialize(component)
    # replace double spaces with single spaces to simplify text parsing
    text = component.text.gsub(/  /, ' ')
    super(text)
    @component = component
    @component.text = text
  end

  # expects an array of arrays of integer values representing the
  # ranges of text content needing to be highlighted in Yellow
  # background
  def highlight(ranges)
    markup(ranges, 'Yellow', Color::yellow)
  end

  # expects an array of arrays of integer values representing the
  # ranges of text content needing have their background color set
  # to White
  def clear(ranges)
    markup(ranges, 'White', Color::white)
  end
  
  private
  
  # ranges is expected to be an array of arrays of integer values,
  # where the inner-most array has two values: the starting point
  # of the text that needs to be marked up and the length of text
  # to apply the markup to
  # label should be a string and color is expected to be a
  # java.awt.Color object
  def markup(ranges, label, color)
    background = com.ociweb.BackgroundAction.new(label, color)
    ranges.each do |range|
      @component.select(range[0], range[0] + range[1])
      event = ActionEvent.new(@component, ActionEvent::ACTION_PERFORMED, 'apply markup')
      background.actionPerformed(event)
    end
    @component.select(0,0)
  end
end

UI.new($textpane).instance_eval($dslpane.text) unless $textpane.text.empty? or $dslpane.text.empty?