require 'test/unit'
require 'text_dsl'

class TextDslTest < Test::Unit::TestCase
  #                 111111111122222222223333
  #       0123456789012345678901234567890123
  TEXT = 'The king is. In the? All together!'

  def setup
    @text = Text.new(TEXT)
  end

  def test_each_sentence
    sentences = @text.instance_eval('each sentence')
    assert_equal 3, sentences.length
    assert_equal [0, 12], sentences[0]
    assert_equal [13, 7], sentences[1]
    assert_equal [21, 13], sentences[2]  
  end
  
  def test_each_word_of_the_first_sentence
    arr = @text.instance_eval('each word of the first sentence')
    assert_equal 1, arr.length

    first_sentence = arr[0]
    assert_equal 3, first_sentence.length

    assert_equal [0,3], first_sentence[0]
    assert_equal [4,4], first_sentence[1]
    assert_equal [9,2], first_sentence[2]
  end

  def test_first_sentence
    sentence = @text.sentence.first
    assert_equal [0, 12], sentence 
  end

  def test_first_word_of_each_sentence
    words = @text.instance_eval('first word of each sentence')
    assert_equal 3, words.length
    assert_equal [0,3], words[0]
    assert_equal [13,2], words[1]
    assert_equal [21,3], words[2]
  end
  
  def test_first_word_of_first_sentence
    words = @text.instance_eval('first word of first sentence')
    assert_equal 1, words.length
    assert_equal [0,3], words[0]
  end
  
  def test_first_word_of_last_sentence
    words = @text.instance_eval('first word of last sentence')
    assert_equal 1, words.length
    assert_equal [21,3], words[0]
  end
  
  def test_garbage
    assert_raise(RuntimeError) do
      @text.instance_eval("first chunk of sentence")
    end
  end   

  def test_invalid
    assert_raise(RuntimeError) { @text.instance_eval 'first' }
    assert_raise(RuntimeError) { @text.instance_eval 'last' }
    assert_raise(RuntimeError) { @text.instance_eval 'sentence word' }
    assert_raise(RuntimeError) { @text.instance_eval 'sentence first word' }
    assert_raise(RuntimeError) { @text.instance_eval 'sentence last word' }
    assert_raise(RuntimeError) { @text.instance_eval 'sentence first' }
    assert_raise(RuntimeError) { @text.instance_eval 'sentence last' }
    assert_raise(RuntimeError) { @text.instance_eval 'word first' }
    assert_raise(RuntimeError) { @text.instance_eval 'word last' }
  end

  def test_last_sentence
    sentences = @text.instance_eval("last sentence")
    assert_equal [21, 13], sentences[0]
  end
  
  def test_last_word_of_each_sentence
    words = @text.instance_eval('last word of each sentence')
    assert_equal 3, words.length
    assert_equal [9,2], words[0]
    assert_equal [16,3], words[1]
    assert_equal [25,8], words[2]
  end

  def test_last_word_of_first_sentence
    words = @text.instance_eval('last word of first sentence')
    assert_equal 1, words.length
    assert_equal [9,2], words[0]
  end
  
  def test_last_word_of_last_sentence
    words = @text.instance_eval('last word of last sentence')
    assert_equal 1, words.length
    assert_equal [25,8], words[0]
  end
  
  
  def test_the_first_sentence
    sentences = @text.instance_eval('the first sentence')
    assert_equal 1, sentences.length
    assert_equal [0,12], sentences[0]
  end

  def test_word_of_each_sentence
    words = @text.instance_eval('word of each sentence')
    assert_equal 3, words.length, "number of sentences"
    assert_equal 3, words[0].length, "number of words in 1st sentence"
    assert_equal 2, words[1].length, "number of words in 2nd sentence"
    assert_equal 2, words[2].length, "number of words in 3rd sentence"
  end
  
end
