package com.ociweb;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.InputStream;
import java.io.InputStreamReader;

import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;

import org.jruby.exceptions.RaiseException;

public class MainFrame extends JFrame {
	private JTextPane textPane;
	private JTextPane dslPane;
	private ScriptEngine engine;

	protected void init() {
		setJMenuBar(configureMenu());
		
		textPane = newTextPane(this);
		JPanel dslPanel = new JPanel();
		dslPane = newTextPane(dslPanel, "DSL Commands:");
		JButton eval = newEvalButton();
		dslPanel.add(eval, BorderLayout.EAST);
		add(dslPanel, BorderLayout.SOUTH);
		
		ScriptEngineManager manager = new ScriptEngineManager();
		engine = manager.getEngineByName("ruby");
		engine.put("textpane", textPane);
		engine.put("dslpane", dslPane);
		//Preload the script so that execution is speedy
		try {
			executeScript();
		} catch (ScriptException e) {
			System.err.println("Error during Ruby script execution");
			e.printStackTrace();
		}
	}

	private JMenuBar configureMenu() {
		JMenuBar menu = new JMenuBar();
		menu.add(new JMenu("Add text for markup below..."));
		menu.add(Box.createHorizontalGlue());
		menu.add(getHelpMenu());
		return menu;
	}

	private JMenu getHelpMenu() {
		JMenu menu = new JMenu("Help");
		JMenuItem menuItem = new JMenuItem("Show DSL Instructions...");
		menuItem.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				JOptionPane.showMessageDialog(MainFrame.this, getDSLInstructions(), "DSL Help", JOptionPane.INFORMATION_MESSAGE);
			}
		});
		menu.add(menuItem);
		
		return menu;
	}

	private String getDSLInstructions() {
		return 
			"This DSL supports the markup \"highlight\" and \"clear\" (which undoes the \"highlight\"\n" +
			"background). The syntax expects the markup instruction followed by the boundaries\n" +
			"of content for markup.  Boundardies can be \"sentence\", \"word\", \"each\", \"every\",\n" +
			"\"first\", and \"last\".  For example, \"highlight each word of the first sentence\", or \n" +
			"\"clear the last sentence\", or \"clear the last word of each sentence\".  Words like\n" +
			"\"of\" and \"the\" are ignored.";
	}

	private JButton newEvalButton() {
		JButton button = new JButton("Evaluate");
		button.addActionListener(new ActionListener() {

			public void actionPerformed(ActionEvent e) {
				try {
					executeScript();
				} catch (ScriptException e1) {
					Throwable cause = e1.getCause();
					if (cause instanceof RaiseException) {
						RaiseException re = (RaiseException)cause;
						JOptionPane.showMessageDialog(MainFrame.this, re.getException().toString(), "DSL Text Error", JOptionPane.ERROR_MESSAGE);
					}
				}
			}
		});
		return button;
	}

	private JTextPane newTextPane(Container container, String... labelText) {
		container.setLayout(new BorderLayout());
		JTextPane textPane = new JTextPane();
		for(String label : labelText) {
			container.add(new JLabel(label), BorderLayout.NORTH);
		}
		JScrollPane scrollpane = new JScrollPane(textPane);
		container.add(scrollpane, BorderLayout.CENTER);
		return textPane;
	}

	private void executeScript() throws ScriptException {
		InputStream resource = MainFrame.class.getClassLoader().getResourceAsStream("swing_ui.rb");
		engine.eval(new InputStreamReader(resource));
	}

	public static void main(String[] args) {
		javax.swing.SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				MainFrame gui = new MainFrame();
				gui.init();
				gui.setTitle("January 2007 Java News Brief (OCI)");
				Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
				gui.pack();
				gui.setSize(400, 500);
				gui.setLocation((int) ((dim.getWidth() - gui.getWidth()) / 2),
						(int) ((dim.getHeight() - gui.getHeight()) / 6));
				gui.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
				gui.setVisible(true);
			}
		});
	}
}