package com.ociweb.emma.ex1;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;

class Card implements Comparable {

    // this class uses old-style (and unsafe) enums for brevity    

    public static final int TWO = 2, THREE = 3, FOUR = 4, FIVE = 5, SIX = 6, SEVEN = 7, 
                            EIGHT = 8, NINE = 9, TEN = 10, JACK = 11, QUEEN = 12, KING = 13, ACE = 14;
    public static final int CLUBS = 0, DIAMONDS = 1, HEARTS = 2, SPADES = 3;
    
    private final int rank;
    private final int suit;    
    
    public Card(int rank, int suit) {
        this.rank = rank;
        this.suit = suit;
    }
    
    public int getSuit() { return suit; }
    public int getRank() { return rank; }
    
    public boolean equalsRank(Card card) { return this.rank == card.rank; }
    public boolean equalsSuit(Card card) { return this.suit == card.suit; }
    
    public int compareTo(Object obj) {
        int result = 0;
        
        Card card = (Card) obj;
        
        if( this.rank != card.rank ) {
            result = ( this.rank < card.rank ) ? -1 : 1;
        }
        
        return result;
    }
}

public class PokerHand {
    public enum Hand { STRAIGHT_FLUSH, THREE_OF_KIND, STRAIGHT, FLUSH, PAIR, HIGH_CARD };

    private List cards;                    // generics are not used, to increase readability 
    private boolean isPair;

    public PokerHand(List cards) {
        // TODO: the hand should be verified as being legal, this check is omitted
        // to keep the example simple
        this.cards = cards;
//      Collections.sort(this.cards);
    }
    
    public Hand evaluate() {
        Hand result = null;

        isPair = false;
        
        Iterator iterator = cards.iterator();
        Card previousCard = (Card) iterator.next();
        
        while( iterator.hasNext() ) {
            Card thisCard = (Card) iterator.next();
            
            if( previousCard.equalsRank(thisCard) ) {
                
                if( !isPair ) {
                    // one pair encountered
                    isPair = true;                    
                } else {
                    // we have already seen one pair, so this 2nd pair => 3 of a kind
                    isPair = false;
                }                
            } 
            
            previousCard = thisCard;            
        }

        result = (isPair) ? Hand.PAIR : Hand.HIGH_CARD;
        
        return result;
    }    
}
