/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.emma.report;

import com.vladium.emma.EMMARuntimeException;
import com.vladium.emma.data.ClassDescriptor;
import com.vladium.emma.data.ICoverageData;
import com.vladium.emma.data.IMetaData;
import com.vladium.emma.report.AbstractItemVisitor;
import com.vladium.emma.report.IItemMetadata;
import com.vladium.emma.report.IReportDataModel;
import com.vladium.emma.report.IReportDataView;
import com.vladium.emma.report.IReportGenerator;
import com.vladium.emma.report.ItemComparator;
import com.vladium.emma.report.ReportProperties;
import com.vladium.emma.report.SourcePathCache;
import com.vladium.emma.report.xml.ReportGenerator;
import com.vladium.logging.Logger;
import com.vladium.util.Descriptors;
import com.vladium.util.IProperties;
import com.vladium.util.IntIntMap;
import com.vladium.util.IntVector;
import com.vladium.util.ObjectIntMap;
import java.util.Iterator;
import java.util.TreeSet;

public abstract class AbstractReportGenerator
extends AbstractItemVisitor
implements IReportGenerator {
    protected ReportProperties.ParsedProperties m_settings;
    protected SourcePathCache m_cache;
    protected IReportDataView m_view;
    protected boolean m_srcView;
    protected boolean m_hasSrcFileInfo;
    protected boolean m_hasLineNumberInfo;
    protected ItemComparator[] m_typeSortComparators;
    protected int[] m_metrics;
    protected Logger m_log;
    protected boolean m_verbose;
    private static final int MAX_DEBUG_INFO_WARNING_COUNT = 3;

    public static IReportGenerator create(String type) {
        if (type == null || type.length() == 0) {
            throw new IllegalArgumentException("null/empty input: type");
        }
        if ("html".equals(type)) {
            return new com.vladium.emma.report.html.ReportGenerator();
        }
        if ("txt".equals(type)) {
            return new com.vladium.emma.report.txt.ReportGenerator();
        }
        if ("xml".equals(type)) {
            return new ReportGenerator();
        }
        throw new EMMARuntimeException("no report generator class found for type [" + type + "]");
    }

    public void initialize(IMetaData mdata, ICoverageData cdata, SourcePathCache cache, IProperties properties) throws EMMARuntimeException {
        this.m_log = Logger.getLogger();
        this.m_verbose = this.m_log.atVERBOSE();
        this.m_settings = ReportProperties.parseProperties(properties, this.getType());
        this.m_cache = cache;
        this.m_hasSrcFileInfo = mdata.hasSrcFileData();
        this.m_hasLineNumberInfo = mdata.hasLineNumberData();
        boolean debugInfoWarning = false;
        boolean bailOut = false;
        if (!mdata.hasSrcFileData() && this.m_settings.getViewType() == 1) {
            debugInfoWarning = true;
            this.m_log.warning("not all instrumented classes were compiled with source file");
            this.m_log.warning("debug data: no sources will be embedded in the report.");
            this.m_settings.setViewType(0);
        }
        if (!this.m_hasLineNumberInfo) {
            int[] userColumnIDs = this.m_settings.getColumnOrder();
            IntVector columnIDs = new IntVector();
            boolean removed = false;
            for (int c = 0; c < userColumnIDs.length; ++c) {
                if (userColumnIDs[c] == 4) {
                    removed = true;
                    continue;
                }
                columnIDs.add(userColumnIDs[c]);
            }
            if (removed) {
                debugInfoWarning = true;
                if (columnIDs.size() == 0) {
                    this.m_log.warning("line coverage requested in a report of type [" + this.getType() + "] but");
                    this.m_log.warning("not all instrumented classes were compiled with line number");
                    this.m_log.warning("debug data: since this was the only requested column, no report will be generated.");
                    bailOut = true;
                } else {
                    this.m_log.warning("line coverage requested in a report of type [" + this.getType() + "] but");
                    this.m_log.warning("not all instrumented classes were compiled with line number");
                    this.m_log.warning("debug data: this column will be removed from the report.");
                    this.m_settings.setColumnOrder(columnIDs.values());
                    int[] userSort = this.m_settings.getSortOrder();
                    IntVector sort = new IntVector();
                    for (int c = 0; c < userSort.length; c += 2) {
                        if (Math.abs(userSort[c]) == 4) continue;
                        sort.add(userSort[c]);
                        sort.add(userSort[c + 1]);
                    }
                    this.m_settings.setSortOrder(sort.values());
                }
            }
        }
        if (debugInfoWarning && this.m_log.atINFO()) {
            TreeSet<String> sampleClassNames = new TreeSet<String>();
            ObjectIntMap countMap = new ObjectIntMap();
            int[] _count = new int[1];
            Iterator descriptors = mdata.iterator();
            while (descriptors.hasNext()) {
                String packageVMName;
                int count;
                ClassDescriptor cls = (ClassDescriptor)descriptors.next();
                if (cls.hasCompleteLineNumberInfo() && cls.hasSrcFileInfo() || (count = countMap.get(packageVMName = cls.getPackageVMName(), _count) ? _count[0] : 0) >= 3) continue;
                sampleClassNames.add(Descriptors.vmNameToJavaName(cls.getClassVMName()));
                countMap.put(packageVMName, count + 1);
            }
            this.m_log.info("showing up to 3 classes without full debug info per package:");
            Iterator names = sampleClassNames.iterator();
            while (names.hasNext()) {
                this.m_log.info("  " + names.next());
            }
        }
        if (bailOut) {
            throw new EMMARuntimeException("BAILED OUT");
        }
        IItemMetadata[] allTypes = IItemMetadata.Factory.getAllTypes();
        this.m_typeSortComparators = new ItemComparator[allTypes.length];
        for (int t = 0; t < allTypes.length; ++t) {
            IntVector orderedAttrIDsWithDir = new IntVector();
            long typeAttrIDSet = allTypes[t].getAttributeIDs();
            for (int s = 0; s < this.m_settings.getSortOrder().length; s += 2) {
                int attrID = this.m_settings.getSortOrder()[s];
                if ((typeAttrIDSet & (long)(1 << attrID)) == 0L) continue;
                orderedAttrIDsWithDir.add(attrID);
                int dir = this.m_settings.getSortOrder()[s + 1];
                orderedAttrIDsWithDir.add(dir);
            }
            this.m_typeSortComparators[t] = ItemComparator.Factory.create(orderedAttrIDsWithDir.values(), this.m_settings.getUnitsType());
        }
        this.m_metrics = new int[allTypes.length];
        IntIntMap metrics = this.m_settings.getMetrics();
        for (int t = 0; t < this.m_metrics.length; ++t) {
            this.m_metrics[t] = -1;
            metrics.get(t, this.m_metrics, t);
        }
        IReportDataModel model = IReportDataModel.Factory.create(mdata, cdata);
        this.m_view = model.getView(this.m_settings.getViewType());
        this.m_srcView = this.m_settings.getViewType() == 1;
    }

    public void cleanup() {
        this.reset();
    }

    protected void reset() {
        this.m_settings = null;
        this.m_cache = null;
        this.m_view = null;
        this.m_srcView = false;
        this.m_typeSortComparators = null;
        this.m_metrics = null;
        this.m_log = null;
    }
}

