package com.ociweb.emma;

import java.util.ArrayList;
import java.util.List;

import junit.framework.TestCase;

public class PokerHandTestCase extends TestCase {

	PokerHand pokerHand = null;
	List cards = null;
	PokerHand.Hand result = null;
	
	public void setUp() {
		cards = new ArrayList();
	}
	
	private PokerHand buildHand( int card1, int suit1, int card2, int suit2, int card3, int suit3) {
		PokerHand pokerHand = null;
		
		cards.add( new Card(card1, suit1) );
		cards.add( new Card(card2, suit2) );
		cards.add( new Card(card3, suit3) );
		
		pokerHand = new PokerHand(cards);
		
		return pokerHand;
	}

	// test three-of-kind
	
	public void testIsThreeOfKind_ThreeOfKind() {
		pokerHand = buildHand( Card.TWO, Card.CLUBS, Card.TWO, Card.HEARTS, Card.TWO, Card.SPADES );
		PokerHand.Hand result = pokerHand.evaluate();
		assertEquals( PokerHand.Hand.THREE_OF_KIND, result );		
	}

	public void testIsThreeOfKind_Pair() {
		pokerHand = buildHand( Card.TWO, Card.CLUBS, Card.THREE, Card.HEARTS, Card.TWO, Card.SPADES );
		PokerHand.Hand result = pokerHand.evaluate();
		assertEquals( PokerHand.Hand.PAIR, result );		
	}

	// test flush
	
	public void testIsFlush_Flush() {
		pokerHand = buildHand( Card.TEN, Card.CLUBS, Card.TWO, Card.CLUBS, Card.ACE, Card.CLUBS);
		PokerHand.Hand result = pokerHand.evaluate();
		assertEquals( PokerHand.Hand.FLUSH, result );		
	}
	
	public void testIsFlush_ThreeOfKind() {
		pokerHand = buildHand( Card.TWO, Card.CLUBS, Card.TWO, Card.HEARTS, Card.TWO, Card.SPADES );
		PokerHand.Hand result = pokerHand.evaluate();
		assertEquals( PokerHand.Hand.THREE_OF_KIND, result );		
	}
	
	// test straight 
	
	public void testIsStraight_OrderedStraight() {
		pokerHand = buildHand( Card.FOUR, Card.HEARTS, Card.FIVE, Card.SPADES, Card.SIX, Card.DIAMONDS);
		PokerHand.Hand result = pokerHand.evaluate();
		assertEquals( PokerHand.Hand.STRAIGHT, result );		
	}
	
	public void testIsStraight_UnOrderedStraight() {
		pokerHand = buildHand( Card.FIVE, Card.HEARTS, Card.SIX, Card.SPADES, Card.FOUR, Card.DIAMONDS);
		PokerHand.Hand result = pokerHand.evaluate();
		assertEquals( PokerHand.Hand.STRAIGHT, result );		
	}

	public void testIsStraight_Pair() {
		pokerHand = buildHand( Card.FIVE, Card.HEARTS, Card.FIVE, Card.SPADES, Card.FOUR, Card.DIAMONDS);
		PokerHand.Hand result = pokerHand.evaluate();
		assertEquals( PokerHand.Hand.PAIR, result );		
	}

	// test straight-flush 
	
	public void testIsStraightFlush_StraightFlush() {
		pokerHand = buildHand( Card.FOUR, Card.HEARTS, Card.FIVE, Card.HEARTS, Card.SIX, Card.HEARTS);
		PokerHand.Hand result = pokerHand.evaluate();
		assertEquals( PokerHand.Hand.STRAIGHT_FLUSH, result );		
	}

	public void testIsStraightFlush_FlushOnly() {
		pokerHand = buildHand( Card.TEN, Card.CLUBS, Card.TWO, Card.CLUBS, Card.ACE, Card.CLUBS);
		PokerHand.Hand result = pokerHand.evaluate();
		assertEquals( PokerHand.Hand.FLUSH, result );		
	}

	public void testIsStraightFlush_StraightOnly() {
		pokerHand = buildHand( Card.FOUR, Card.HEARTS, Card.FIVE, Card.HEARTS, Card.SIX, Card.DIAMONDS );
		PokerHand.Hand result = pokerHand.evaluate();
		assertEquals( PokerHand.Hand.STRAIGHT, result );		
	}

	// test pair  

	public void testIsPair_Pair() {
		pokerHand = buildHand( Card.TWO, Card.CLUBS, Card.THREE, Card.HEARTS, Card.TWO, Card.SPADES );
		PokerHand.Hand result = pokerHand.evaluate();
		assertEquals( PokerHand.Hand.PAIR, result );		
	}
	
	public void testIsPair_ThreeOfKind() {
		pokerHand = buildHand( Card.TWO, Card.CLUBS, Card.TWO, Card.HEARTS, Card.TWO, Card.SPADES );
		PokerHand.Hand result = pokerHand.evaluate();
		assertEquals( PokerHand.Hand.THREE_OF_KIND, result );		
	}
	
	// test high card

	public void testIsHighCard_HighCard() {
		pokerHand = buildHand( Card.TWO, Card.CLUBS, Card.THREE, Card.HEARTS, Card.ACE, Card.SPADES );
		PokerHand.Hand result = pokerHand.evaluate();
		assertEquals( PokerHand.Hand.HIGH_CARD, result );		
	}
	
	public void testIsHighCard_ThreeOfKind() {
		pokerHand = buildHand( Card.TWO, Card.CLUBS, Card.TWO, Card.HEARTS, Card.TWO, Card.SPADES );
		PokerHand.Hand result = pokerHand.evaluate();
		assertEquals( PokerHand.Hand.THREE_OF_KIND, result );		
	}
	
}
