package com.ociweb.emma.servlet;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;

class Card implements Comparable {
   
    // this class uses old-style (and unsafe) enums for brevity 
 
    public static final int TWO = 2, THREE = 3, FOUR = 4, FIVE = 5, SIX = 6, SEVEN = 7, 
                            EIGHT = 8, NINE = 9, TEN = 10, JACK = 11, QUEEN = 12, KING = 13, ACE = 14;
    public static final int CLUBS = 0, DIAMONDS = 1, HEARTS = 2, SPADES = 3;
    
    private final int rank;
    private final int suit;    
    
    public Card(int rank, int suit) {
        this.rank = rank;
        this.suit = suit;
    }
    
    public int getSuit() { return suit; }
    public int getRank() { return rank; }
    
    public boolean equalsRank(Card card) { return this.rank == card.rank; }
    public boolean equalsSuit(Card card) { return this.suit == card.suit; }
    
    public int compareTo(Object obj) {
        int result = 0;
        
        Card card = (Card) obj;
        
        if( this.rank != card.rank ) {
            result = ( this.rank < card.rank ) ? -1 : 1;
        }
        
        return result;
    }
}

public class PokerHand {
    public enum Hand { STRAIGHT_FLUSH, THREE_OF_KIND, STRAIGHT, FLUSH, PAIR, HIGH_CARD };

    private List cards;                    // generics are not used, to increase readability
    private boolean isThreeOfKind;
    private boolean isFlush;
    private boolean isStraight;
    private boolean isPair;

    public PokerHand(List cards) {
        // TODO: the hand should be verified as being legal, this check is omitted
        // to keep the example simple        
        this.cards = cards;
        Collections.sort(this.cards);
    }

    private Hand whichHand() {
        Hand result = Hand.HIGH_CARD;

        if( isFlush && isStraight ) {
            result = Hand.STRAIGHT_FLUSH; 
        } else if( isThreeOfKind ) {
            result = Hand.THREE_OF_KIND;
        } else if( isFlush ) {
            result = Hand.FLUSH;
        } else if( isStraight ) {
            result = Hand.STRAIGHT;
        } else if( isPair ) {
            result = Hand.PAIR;
        }
        
        return result;
    }
    
    public Hand evaluate() {
        Hand result = Hand.HIGH_CARD;

        isThreeOfKind = true;
        isFlush = true;
        isStraight = true;
        isPair = false;
        
        Iterator iterator = cards.iterator();
        Card previousCard = (Card) iterator.next();
        
        while( iterator.hasNext() ) {
            Card thisCard = (Card) iterator.next();
            
            if( !previousCard.equalsRank(thisCard) ) {
                isThreeOfKind = false;
            } else {                
                if( !isPair ) {
                    isPair = true;                    
                } else {
                    isPair = false;
                }                
            }
            
            if( !previousCard.equalsSuit(thisCard) ) {
                isFlush = false;
            } 
            
            if( previousCard.getRank() != ( thisCard.getRank() - 1 ) ) {
                isStraight = false;
            }
                    
            previousCard = thisCard;            
        }

        result = whichHand();
        
        return result;
    }
}
