package com.ociweb.emma.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PokerHandServlet extends HttpServlet {

    final static String CARD_RANK_1 = "cardRank1";
    final static String CARD_RANK_2 = "cardRank2";
    final static String CARD_RANK_3 = "cardRank3";

    final static String CARD_SUIT_1 = "cardSuit1";
    final static String CARD_SUIT_2 = "cardSuit2";
    final static String CARD_SUIT_3 = "cardSuit3";
    
    private Card buildCard(HttpServletRequest req, String rankKey, String suitKey) {
        Card card = null;
        
        String rankStr = req.getParameter(rankKey);
        
        int rank = Integer.parseInt(rankStr);
        
        String suitStr = req.getParameter(suitKey);

        int suit = Integer.parseInt(suitStr);
        
        card = new Card(rank, suit);
        
        return card;
    }
    
    public void doGet(HttpServletRequest req, HttpServletResponse res)
                                    throws ServletException, IOException {

        res.setContentType("text/html");
        PrintWriter out = res.getWriter();
        
        out.println("<html><body>");
        
        Card card1 = buildCard(req, CARD_RANK_1, CARD_SUIT_1);
        Card card2 = buildCard(req, CARD_RANK_2, CARD_SUIT_2);
        Card card3 = buildCard(req, CARD_RANK_3, CARD_SUIT_3);
        
        List cards = new ArrayList();
        
        cards.add(card1);
        cards.add(card2);
        cards.add(card3);
        
        PokerHand hand = new PokerHand(cards);
        PokerHand.Hand result = hand.evaluate();
        
        String resultStr = null;
        
        if( result == PokerHand.Hand.STRAIGHT_FLUSH ) {
            resultStr = "The hand is a straight flush.";
        } else if( result == PokerHand.Hand.THREE_OF_KIND ) {
            resultStr = "The hand is a 3-of-a-kind.";
        } else if( result == PokerHand.Hand.FLUSH ) {
            resultStr = "The hand is a flush.";
        } else if( result == PokerHand.Hand.STRAIGHT ) {
            resultStr = "The hand is a straight.";
        } else if( result == PokerHand.Hand.PAIR ) {
            resultStr = "The hand is a pair.";
        } else if( result == PokerHand.Hand.HIGH_CARD ) {
            resultStr = "The hand is only a high-card.";
        }

        out.println(resultStr);
        
        out.println("</body></html>");
    }
}
