
package com.ociweb.demo;

import javax.xml.ws.Holder;

class SpidermanInc {
	public static void main(String args[]){
        // get the service
        
    	AcmeWebService service = new AcmeWebService();
        
        // get the port
        AcmeWebOrderInterface acmeWebOrder = service.getAcmeWebOrderPort();

        System.out.println("\nNeed web material. Requesting estimate... ");
        
        OrderRecord estimate = acmeWebOrder.getEstimate( "Webslinger", 50 );
        
        System.out.println("\nReceived estimate: ");
        System.out.println("customer = " + estimate.customerId);
        System.out.println("units = " + estimate.numUnits);
        System.out.println("cost = " + estimate.cost);

        System.out.println("\nAssuming that cost is approved. placing order... ");
        
        Holder<OrderRecord> orderHolder = new Holder<OrderRecord>();
        orderHolder.value = estimate;
        boolean result = acmeWebOrder.placeOrder( orderHolder );
        
        if( result ) {
            OrderRecord order = orderHolder.value;
            System.out.println("\nConfirmed order: ");
            System.out.println("orderCode = " + order.orderCode);
            System.out.println("expectedArrival = " + order.expectedArrival );

            for( int i = 0 ; i < 6 ; i++ ) {            
                System.out.println("\nTime passes... ");
                try { Thread.sleep(1000); } catch(Exception e) {}
            }
            
            System.out.println("\nShipment arrived!  Sending confirmation....");
            
            acmeWebOrder.confirmReceipt(order.orderCode);
            
            System.out.println("\nexample complete");
            
        } else {
            System.out.println("\ninternal error with example. expected order to succeed");
            System.exit(-1);
        }
	}
}
