package com.ociweb.demo;

import java.io.Serializable;

/**
 * Data model for the HomeActivity. Fires events when the data
 * fetch thread begins and ends.
 */
public class HomeModel implements Serializable {
  private static final long serialVersionUID = 1L;
  
  public enum State { NOT_STARTED, RUNNING, FINISHED }
  
  private State state = State.NOT_STARTED;
  private HomeModelListener homeModelListener;
  
  public synchronized void setHomeModelListener(HomeModelListener l) {
    homeModelListener = l;
  }
  
  public void setState(State state) {
    // copy to a local variable inside the synchronized block
    // to avoid synchronization while calling homeModelChanged()
    HomeModelListener hml = null;
    synchronized (this) {
      if (this.state == state) {
        return; // no change
      }
      this.state = state;
      hml = this.homeModelListener;      
    }
    
    // notify the listener here, not synchronized
    if (hml != null) {
      hml.homeModelChanged(this);
    }
  }
  
  public synchronized State getState() {
    return state;
  }
}
