package com.ociweb.jnb.feb2009;

public class TimeSlip implements Comparable<TimeSlip> {
    String driver;
    int elapsedTime;

    public TimeSlip(String driver, int elapsedTime) {
        this.driver = driver;
        this.elapsedTime = elapsedTime;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TimeSlip)) {
            return false;
        }
        TimeSlip rhs = (TimeSlip) o;
        return rhs.driver.equals(driver) && rhs.elapsedTime == elapsedTime;
    }

    @Override
    public int hashCode() {
        int result = 17;
        result = 31 * result + driver.hashCode();
        result = 31 * result + elapsedTime;
        return result;

    }

    public int compareTo(TimeSlip timeSlip) {
        if (timeSlip == this) {
            return 0;
        }
        if (elapsedTime < timeSlip.elapsedTime) {
            return -1;
        } else if (elapsedTime == timeSlip.elapsedTime) {
            return 0;
        } else {
            return +1;
        }
    }

    @Override
    public String toString() {
        return String.format("%s/%d", driver, elapsedTime);
    }
}
