package com.ociweb.jnb.feb2009;

import com.google.common.collect.*;
import com.google.common.base.Join;

public class CollectUserDefinedTypes {
    public static void main(String[] args) {
        BiMap<String, Combination> locks = Maps.newHashBiMap();
        locks.put("school", new Combination(36, 22, 36));
        locks.put("ymca", new Combination(14, 7, 28));
        locks.put("club", new Combination(3, 18, 6));

        // later, we find a slip of paper on the table with the combination, but which lock does it belong to?
        BiMap<Combination, String> locksInv = locks.inverse();
        System.out.println(locksInv.get(new Combination(36, 22, 36)));


        Multimap<String, TimeSlip> weekend = Multimaps.newTreeMultimap();
        weekend.put("Friday", new TimeSlip("Carey", 13));
        weekend.put("Friday", new TimeSlip("Dan", 14));
        weekend.put("Sunday", new TimeSlip("Dean", 10));
        weekend.put("Friday", new TimeSlip("Dean", 12));
        weekend.put("Saturday", new TimeSlip("Dan", 13));
        weekend.put("Saturday", new TimeSlip("Dean", 11));
        weekend.put("Sunday", new TimeSlip("Dan", 12));
        weekend.put("Saturday", new TimeSlip("Carey", 12));
        weekend.put("Sunday", new TimeSlip("Carey", 11));

        System.out.printf("Friday's Times: %s\n", Join.join(", ", weekend.get("Friday")));
        System.out.printf("Saturday's Times: %s\n", Join.join(", ", weekend.get("Saturday")));
        System.out.printf("Sunday's Times: %s\n", Join.join(", ", weekend.get("Sunday")));
    }
}
