package com.ociweb.jnb.feb2009;

import com.google.common.base.Join;
import com.google.common.collect.*;

import java.util.*;


public class UseTheRightCollection {
    public static void main(String[] args) {

        // sets do not allow repetition and do not preserve order
        Set<String> dontForget = Sets.newHashSet("Keys", "Badge", "Wallet");
        dontForget.add("Keys"); // ignored, set will still only contain one instance of "Keys"

        // multisets (also known as bags) do allow repetition but do not preserve order
        Multiset<String> groceries = Multisets.newHashMultiset("Apple", "Orange", "Orange", "Banana", "Pear");
        System.out.printf("groceries contains %d oranges\n", groceries.count("Orange"));

        // lists allow repetition and preserve order
        List<Integer> combination = Lists.newArrayList(36, 22, 36);

        // maps do not allow duplicate keys, and each key maps to only one value, but multiple keys may refer to the
        // same value
        Map<String, Integer> numLegs = Maps.newHashMap();
        numLegs.put("Horse", 4);
        numLegs.put("Zebra", 4);
        numLegs.put("Spider", 8);
        numLegs.put("Monkey", 2);

        // Depending upon the implementation of a map, multiple keys may map to the same value.
        // such a map, if inverted, would be a multimap.  BiMap excludes this possibility at
        // runtime but also provides an efficient inverse lookup capability
        BiMap<String, String> usCoinsFrontBack1998 = Maps.newHashBiMap();
        usCoinsFrontBack1998.put("Abraham Lincoln", "Lincoln Memorial");
        usCoinsFrontBack1998.put("Thomas Jefferson", "Monticello");
        usCoinsFrontBack1998.put("Franklin D. Roosevelt", "Olive branch, Torch, Oak Branch");
        usCoinsFrontBack1998.put("George Washington", "Eagle");
        //usCoinsFrontBack1998.put("Not George Washington", "Eagle");  // java.lang.IllegalArgumentException

        String query1 = "Franklin D. Roosevelt";
        System.out.printf("front = %s, back = %s\n", query1, usCoinsFrontBack1998.get(query1));

        String query2 = "Monticello";
        System.out.printf("back = %s, front = %s\n", query2,
            usCoinsFrontBack1998.inverse().get(query2)); // now use the inverse lookup capability

        // multimaps allow a key to map to multiple values
        Multimap<String, String> pets = Multimaps.newHashMultimap();
        pets.put("John", "Cat");
        pets.put("John", "Dog");
        pets.put("Anne", "Fish");
        pets.put("Anne", "Bird");
        pets.put("Anne", "Bunny");
        pets.put("Anne", "Cat");
        pets.put("Dan", "Cat");

        final Collection<String> annePets = pets.get("Anne");
        System.out.printf("Anne's pets: %s\n", Join.join(", ", annePets));

        // Google Collections makes it easy to invert Multimaps and Maps:
        SetMultimap<String, Integer> numLegsMulti = Multimaps.forMap(numLegs);
        HashMultimap<Integer, String> invNumLegsMulti = Multimaps.inverseHashMultimap(numLegsMulti);
        int numLegsQuery = 4;
        System.out.printf("animals with %d legs = %s\n", numLegsQuery,
                Join.join(", ", invNumLegsMulti.get(numLegsQuery)));
    }
}
