package com.ociweb.jnb.feb2009;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;

import java.util.Map;
import java.util.Collections;

public class EnforceImmutability {
    public static void main(String[] args) {
        {
            Map<String, Integer> map = Maps.newHashMap();
            map.put("abc", 123);     // no RuntimeException
        }

        {
            Map<String, Integer> map = ImmutableMap.of("abc", 123);
            map.put("def", 456);    // java.lang.UnsupportedOperationException
        }

        {
            // alternate syntax using Builder
            Map<String, Integer> map = new ImmutableMap.Builder<String, Integer>().put("abc", 123).build();
            map.put("def", 456);    // java.lang.UnsupportedOperationException
        }

        {
            // make a mutable map immutable (Google Collections)
            Map<String, Integer> map = Maps.newHashMap();
            map.put("abc", 123);     // no RuntimeException

            Map<String, Integer> immutableMap = ImmutableMap.copyOf(map);
            immutableMap.put("def", 456);    // java.lang.UnsupportedOperationException
        }

        {
            // make a mutable map immutable (Java Collections Framework)
            Map<String, Integer> map = Maps.newHashMap();
            map.put("abc", 123);     // no RuntimeException

            Map<String, Integer> immutableMap = Collections.unmodifiableMap(map);
            immutableMap.put("def", 456);    // java.lang.UnsupportedOperationException
        }

    }
}
